/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.report.BaseUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import javax.imageio.ImageIO;

public class SummaryInfo
implements Serializable {
    private String title;
    private String aai;
    private String keywords;
    private String subject;
    private String ayu;
    private String comments;
    private Date ayv;
    private Date ayw;
    private transient BufferedImage ayx;
    private byte[] ayy;

    SummaryInfo() {
    }

    public String getAuthor() {
        return this.aai;
    }

    public void setAuthor(String string) {
        this.aai = string;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public void setKeywords(String string) {
        this.keywords = string;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String string) {
        this.comments = string;
    }

    public String getReportTitle() {
        return this.title;
    }

    public void setReportTitle(String string) {
        this.title = string;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String string) {
        this.subject = string;
    }

    public String getTemplate() {
        return this.ayu;
    }

    public void setTemplate(String string) {
        this.ayu = string;
    }

    public Date getCreated() {
        return this.ayw;
    }

    public void setCreated(Date date) {
        this.ayw = date;
    }

    public Date getLastSaved() {
        return this.ayv;
    }

    public void setLastSaved(Date date) {
        this.ayv = date;
    }

    public void setThumbnail(Image image) {
        double d2;
        this.ayy = null;
        if (image == null) {
            this.ayx = null;
            return;
        }
        int n2 = image.getWidth(null);
        int n3 = image.getHeight(null);
        int n4 = n2;
        int n5 = n3;
        if (n2 > n3) {
            d2 = (double)n2 / 96.0;
            n4 = 96;
            n5 = (int)((double)n5 / d2);
        } else {
            d2 = (double)n3 / 96.0;
            n5 = 96;
            n4 = (int)((double)n4 / d2);
        }
        image = image.getScaledInstance(n4, n5, 4);
        BufferedImage bufferedImage = new BufferedImage(n4, n5, 6);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.drawImage(image, 0, 0, Color.WHITE, null);
        graphics.dispose();
        this.ayx = bufferedImage;
        this.getThumbnailData();
    }

    public Image getThumbnail() {
        if (this.ayx == null && this.ayy != null) {
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.ayy);
                this.ayx = ImageIO.read(byteArrayInputStream);
            }
            catch (IOException iOException) {
                BaseUtils.printStackTrace(iOException);
                this.ayy = null;
            }
        }
        return this.ayx;
    }

    public void setThumbnailData(byte[] byArray) {
        this.ayx = null;
        this.ayy = byArray;
    }

    public byte[] getThumbnailData() {
        if (this.ayy == null && this.ayx != null) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)this.ayx, "png", byteArrayOutputStream);
                this.ayy = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                BaseUtils.printStackTrace(iOException);
            }
        }
        return this.ayy;
    }
}

