/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.cache;

import com.inet.lib.util.IOFunctions;
import com.inet.report.BaseUtils;
import com.inet.report.CacheRenderData;
import com.inet.report.Engine;
import com.inet.report.PropertiesChecker;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.cache.EngineFactory;
import com.inet.report.cache.EngineFactoryImpl;
import com.inet.report.cache.ExternalDBCache;
import com.inet.report.cache.KeyNotFoundException;
import com.inet.report.cache.PageOutOfRangeException;
import com.inet.report.cache.ReportCacheKey;
import com.inet.report.cache.b;
import com.inet.report.cache.c;
import com.inet.report.cache.d;
import com.inet.report.cache.e;
import com.inet.report.cache.f;
import com.inet.report.cache.i;
import com.inet.report.cache.k;
import com.inet.report.cache.l;
import com.inet.report.cache.q;
import com.inet.report.cache.r;
import com.inet.report.cache.s;
import com.inet.report.cache.t;
import com.inet.report.config.datasource.DataSourceConfigurationManager;
import com.inet.report.config.structure.model.ConfigKey;
import com.inet.report.dw;
import com.inet.report.i18n.ErrorCode;
import com.inet.report.util.EngineUtils;
import com.inet.report.util.g;
import com.inet.viewer.archive.ArchiveFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Random;
import java.util.prefs.BackingStoreException;

public abstract class Cache {
    private final Hashtable<ReportCacheKey, d> aEK = new Hashtable();
    private final long aEL = System.currentTimeMillis();
    private static EngineFactory aEM = new EngineFactoryImpl();
    private static final Random aEN = new Random();
    protected static Cache aEO;
    private static Cache JF;
    protected static Thread aEP;
    static final s aEQ;
    static t aER;
    static final byte[] aES;
    protected static int aET;
    static final Object aEU;
    public static final int TYPE_MEMORY = 0;
    public static final int TYPE_DATABASE = 1;
    public static final int TYPE_HARDDISK = 2;
    public static final int TYPE_EXTERNAL_DATABASE = 3;

    Cache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Cache getCache() {
        Cache cache = JF;
        if (cache == null) {
            Object object = aEU;
            synchronized (object) {
                g.Zf();
                if (JF == null) {
                    Cache.init();
                }
                cache = JF;
            }
        }
        return cache;
    }

    public static void init() {
        if (dw.azD.get("application", "").equals("i-net Designer")) {
            return;
        }
        Cache cache = JF;
        if (cache != null) {
            cache.destroy();
        }
        f.uy();
        switch (g.Zf()) {
            case 1: {
                JF = aEO = new i();
                if (JF.isValid() || !BaseUtils.isInfo()) break;
                BaseUtils.info("[CACHE] initializing database cache failed. Using MemoryCache now.");
                JF = aEO = new q();
                g.jy(0);
                break;
            }
            case 2: {
                JF = aEO = new l();
                if (JF.isValid() || !BaseUtils.isInfo()) break;
                BaseUtils.info("[CACHE] initializing harddisk cache failed. Using MemoryCache now.");
                JF = aEO = new q();
                g.jy(0);
                break;
            }
            case 3: {
                JF = aEO = new ExternalDBCache();
                if (JF.isValid() || !BaseUtils.isInfo()) break;
                BaseUtils.info("[CACHE] initializing external database cache failed. Using MemoryCache now.");
                JF = aEO = new q();
                g.jy(0);
                break;
            }
            default: {
                JF = aEO = new q();
            }
        }
    }

    public static void shutdown() {
        Cache cache = JF;
        if (cache != null) {
            cache.destroy();
        }
        d.ui();
    }

    private void destroy() {
        BaseUtils.a(aEP);
        t.uP();
        if (BaseUtils.isDebug()) {
            BaseUtils.debug("all writer threads died");
        }
        JF = null;
        aER = null;
        aEP = null;
        aEQ.clear();
        this.aEK.clear();
        t.aGy.clear();
    }

    public static void setEngineFactory(EngineFactory engineFactory) {
        if (engineFactory == null) {
            throw new IllegalArgumentException("EngineFactory should not be null");
        }
        aEM = engineFactory;
    }

    public static EngineFactory getEngineFactory() {
        return aEM;
    }

    public ReportCacheKey getKey(Properties properties) throws ReportException {
        return this.getKey(properties, null, null);
    }

    public ReportCacheKey getKey(Properties properties, PropertiesChecker propertiesChecker, Object object) throws ReportException {
        return this.getKey(properties, propertiesChecker, aEM, object);
    }

    public abstract ReportCacheKey getKey(Properties var1, PropertiesChecker var2, EngineFactory var3, Object var4) throws ReportException;

    public final byte[] getPageAndWait(ReportCacheKey reportCacheKey, int n2) throws PageOutOfRangeException, KeyNotFoundException, ReportException {
        return this.getPageAndWait(reportCacheKey, n2, 0);
    }

    public abstract byte[] getPageAndWait(ReportCacheKey var1, int var2, int var3) throws PageOutOfRangeException, KeyNotFoundException, ReportException;

    public final byte[] getGroupTreeAndWait(ReportCacheKey reportCacheKey, int n2, int n3) throws KeyNotFoundException, ReportException {
        return this.getGroupTreeAndWait(reportCacheKey, n2, n3, 0);
    }

    public byte[] getGroupTreeAndWait(ReportCacheKey reportCacheKey, int n2, int n3, int n4) throws KeyNotFoundException, ReportException {
        byte[] byArray = this.getPageAndWait(reportCacheKey, 0, n4);
        if (byArray == null && BaseUtils.isDebug()) {
            BaseUtils.debug("group tree is not in the cache.");
        }
        return byArray;
    }

    public final int getPageCountAndWait(ReportCacheKey reportCacheKey) throws KeyNotFoundException, ReportException {
        return this.getPageCountAndWait(reportCacheKey, 0);
    }

    public abstract int getPageCountAndWait(ReportCacheKey var1, int var2) throws KeyNotFoundException, ReportException;

    public final int getTotalPageSizeAndWait(ReportCacheKey reportCacheKey) throws KeyNotFoundException, ReportException {
        return this.getTotalPageSizeAndWait(reportCacheKey, 0);
    }

    public abstract int getTotalPageSizeAndWait(ReportCacheKey var1, int var2) throws KeyNotFoundException, ReportException;

    public abstract boolean isPageLimitExceeded(ReportCacheKey var1) throws KeyNotFoundException, ReportException;

    public abstract void lock(ReportCacheKey var1) throws KeyNotFoundException, ReportException;

    public abstract void unlock(ReportCacheKey var1) throws KeyNotFoundException, ReportException;

    public void addEngine(Engine engine, ReportCacheKey reportCacheKey) throws ReportException {
        if (this.exists(reportCacheKey)) {
            Object[] objectArray = new Object[]{};
            throw ReportExceptionFactory.createReportException(ErrorCode.engExistsAlready, objectArray);
        }
        try {
            k k2 = new k(reportCacheKey);
            int n2 = engine.getPageCount();
            for (int i2 = 1; i2 <= n2; ++i2) {
                k2.aD(engine.getPageData(i2));
            }
            k2.aE(engine.getGroupTree());
        }
        catch (Exception exception) {
            throw ReportExceptionFactory.createReportExceptionWithCause(exception);
        }
    }

    public abstract boolean exists(ReportCacheKey var1);

    public ReportCacheKey createKey(Properties properties) throws ReportException {
        return this.createKey(properties, null, null);
    }

    public ReportCacheKey createKey(Properties properties, PropertiesChecker propertiesChecker, Object object) throws ReportException {
        return this.createKey(properties, propertiesChecker, aEM, object);
    }

    public ReportCacheKey createKey(Properties properties, PropertiesChecker propertiesChecker, EngineFactory engineFactory, Object object) throws ReportException {
        try {
            dw.azD.flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        if (Boolean.valueOf(dw.azD.get(ConfigKey.CACHE_CLEAR_ON_REQUEST.getKey(), ConfigKey.CACHE_CLEAR_ON_REQUEST.getDefault())).equals(Boolean.TRUE)) {
            ReportCacheKey[] reportCacheKeyArray = this.getReports();
            if (reportCacheKeyArray != null) {
                for (ReportCacheKey reportCacheKey : reportCacheKeyArray) {
                    this.delete(reportCacheKey);
                }
            }
            if (BaseUtils.isDebug()) {
                BaseUtils.debug("Clear cache on request executed.");
            }
            dw.azD.put(ConfigKey.CACHE_CLEAR_ON_REQUEST.getKey(), "false");
            try {
                dw.azD.flush();
            }
            catch (BackingStoreException backingStoreException) {
                // empty catch block
            }
        }
        if (propertiesChecker != null && properties.get("PropertyChecker") == null) {
            try {
                propertiesChecker.checkProperties(properties, object);
                properties.put("PropertyChecker", "PropertyChecker");
            }
            catch (ReportException reportException) {
                throw reportException;
            }
            catch (Throwable throwable) {
                if (BaseUtils.gk()) {
                    BaseUtils.warning("Could not execute checkProperties, reason:");
                }
                BaseUtils.printStackTrace(throwable);
            }
        }
        return engineFactory.getKey(properties);
    }

    public abstract void delete(String var1) throws ReportException;

    public abstract void delete(ReportCacheKey var1) throws ReportException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean a(r r2) throws ReportException {
        if (!this.exists(r2.uj())) {
            throw new KeyNotFoundException(r2.uj());
        }
        s s2 = aEQ;
        synchronized (s2) {
            d d2 = this.f(r2.uj());
            if (d2 == null) {
                throw new KeyNotFoundException(r2.uj());
            }
            int n2 = r2.getPage();
            if (d2.isFinished() || d2.de(n2)) {
                return true;
            }
            aEQ.b(r2);
            return false;
        }
    }

    final void a(ReportCacheKey reportCacheKey, Properties properties, PropertiesChecker propertiesChecker, Object object) {
        k k2 = new k(reportCacheKey);
        a a2 = new a(reportCacheKey, properties, propertiesChecker, object, k2);
        try {
            a2.init();
            Thread thread = new Thread((Runnable)a2, "jra engine");
            thread.start();
        }
        catch (Throwable throwable) {
            BaseUtils.printStackTrace(throwable);
            k2.aG(IOFunctions.serialize(throwable));
        }
    }

    final d a(ReportCacheKey reportCacheKey, Properties properties, PropertiesChecker propertiesChecker, EngineFactory engineFactory, Object object) throws ReportException {
        if (properties.containsKey("export_fmt") && (properties.get("export_fmt").equals("jar") || properties.get("export_fmt").equals("jra"))) {
            this.a(reportCacheKey, properties, propertiesChecker, object);
            return null;
        }
        if (BaseUtils.isInfo()) {
            BaseUtils.info("### startEngine req" + object);
        }
        if (BaseUtils.isInfo()) {
            BaseUtils.info("### PropertiesChecker " + propertiesChecker);
        }
        properties.put("export_fmt", reportCacheKey.getFormat());
        Engine engine = EngineUtils.createEngine(properties, propertiesChecker, engineFactory, object);
        if ("rfsh".equals(properties.getProperty("cmd"))) {
            dw.x(engine).op().rE();
        }
        k k2 = new k(reportCacheKey);
        d d2 = k2.uH();
        try {
            engine.setCachedPages(k2);
            d2.setEngine(engine);
            engine.execute();
        }
        catch (Throwable throwable) {
            this.a(d2);
            throw ReportExceptionFactory.createReportExceptionWithCause(throwable);
        }
        return d2;
    }

    public boolean isFinished(ReportCacheKey reportCacheKey) throws ReportException {
        d d2 = this.f(reportCacheKey);
        if (d2 == null) {
            return true;
        }
        return d2.isFinished();
    }

    boolean b(ReportCacheKey reportCacheKey) {
        d d2 = this.f(reportCacheKey);
        if (d2 == null) {
            return false;
        }
        return d2.isFinished();
    }

    int c(ReportCacheKey reportCacheKey) {
        d d2 = this.f(reportCacheKey);
        if (d2 == null) {
            return 0;
        }
        return d2.aFg;
    }

    int d(ReportCacheKey reportCacheKey) {
        d d2 = this.f(reportCacheKey);
        if (d2 == null) {
            return -1;
        }
        return d2.aFh;
    }

    int e(ReportCacheKey reportCacheKey) {
        d d2 = this.f(reportCacheKey);
        if (d2 == null) {
            return 0;
        }
        return d2.aFk;
    }

    d f(ReportCacheKey reportCacheKey) {
        return this.a(reportCacheKey, true);
    }

    d a(ReportCacheKey reportCacheKey, boolean bl2) {
        ReportCacheKey reportCacheKey2;
        d d2;
        block7: {
            d2 = this.aEK.get(reportCacheKey);
            if (bl2 && d2 == null && !reportCacheKey.isRequestScheduleInProcessReport()) {
                reportCacheKey2 = reportCacheKey.create(true);
                d2 = this.aEK.get(reportCacheKey2);
            }
            if (d2 == null && aER != null) {
                try {
                    d2 = aER.b(reportCacheKey, bl2);
                    if (d2 != null) {
                        this.a(reportCacheKey, d2);
                    }
                }
                catch (ReportException reportException) {
                    if (!BaseUtils.isDebug()) break block7;
                    BaseUtils.debug(reportException);
                }
            }
        }
        if (d2 != null) {
            return d2;
        }
        if (bl2 && !reportCacheKey.isRequestScheduleInProcessReport()) {
            reportCacheKey2 = reportCacheKey.create(true);
            return this.f(reportCacheKey2);
        }
        return d2;
    }

    void a(ReportCacheKey reportCacheKey, d d2) {
        this.aEK.put(reportCacheKey, d2);
    }

    public boolean containsInRAM(ReportCacheKey reportCacheKey) {
        d d2 = this.aEK.get(reportCacheKey);
        return d2 != null && d2.uk() != null;
    }

    d g(ReportCacheKey reportCacheKey) {
        return this.aEK.get(reportCacheKey);
    }

    public abstract ReportCacheKey[] getReports() throws ReportException;

    void h(ReportCacheKey reportCacheKey) {
        if (reportCacheKey == null) {
            return;
        }
        r r2 = aEQ.d(reportCacheKey, 0);
        if (r2 != null) {
            r2.uO();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.aEK.remove(reportCacheKey);
    }

    Iterator<ReportCacheKey> uc() {
        return Arrays.asList(this.aEK.keySet().toArray(new ReportCacheKey[this.aEK.size()])).iterator();
    }

    Iterator<d> ud() {
        return Arrays.asList(this.aEK.values().toArray(new d[this.aEK.size()])).iterator();
    }

    void a(d d2) {
        d2.setState(4);
        d d3 = this.f(d2.uj());
        if (d3 == d2) {
            this.h(d2.uj());
        }
    }

    public boolean isFinishWrittenToStore(ReportCacheKey reportCacheKey) throws ReportException, KeyNotFoundException {
        if (aER == null) {
            return this.isFinished(reportCacheKey);
        }
        d d2 = this.f(reportCacheKey);
        if (d2 == null) {
            throw new KeyNotFoundException(reportCacheKey);
        }
        if (!d2.isFinished()) {
            return false;
        }
        return d2.aFi || d2.aFc;
    }

    public final void setSchedule(ReportCacheKey reportCacheKey, boolean bl2) throws ReportException {
        this.b(reportCacheKey, bl2 ? 2 : 0);
    }

    abstract void b(ReportCacheKey var1, int var2) throws ReportException;

    public boolean isScheduleReport(ReportCacheKey reportCacheKey) throws ReportException {
        if (this.exists(reportCacheKey)) {
            return this.f(reportCacheKey).um();
        }
        throw new ReportException("[Cache] The report can not be found in the Cache. report " + reportCacheKey.getReport(), 2010);
    }

    public boolean isFailedReport(ReportCacheKey reportCacheKey) throws ReportException {
        d d2 = this.f(reportCacheKey);
        if (d2 != null) {
            return d2.aFc;
        }
        throw new ReportException("[Cache] The report can not be found in the Cache. report " + reportCacheKey.getReport(), 2010);
    }

    public Throwable getFailureCause(ReportCacheKey reportCacheKey) throws ReportException {
        if (this.isFailedReport(reportCacheKey)) {
            byte[] byArray = this.getPageAndWait(reportCacheKey, 1);
            try {
                c c2 = new c(this, new ByteArrayInputStream(byArray));
                Throwable throwable = (Throwable)c2.readObject();
                c2.close();
                return throwable;
            }
            catch (IOException iOException) {
                throw ReportExceptionFactory.createReportExceptionWithCause(iOException, ErrorCode.Cache_getFailureCause, reportCacheKey.getReport());
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw ReportExceptionFactory.createReportExceptionWithCause(classNotFoundException, ErrorCode.Cache_getFailureCause, reportCacheKey.getReport());
            }
        }
        return null;
    }

    abstract void b(d var1);

    public int getType() {
        return g.Zf();
    }

    @Deprecated
    public static boolean isTypeSchedulerCache() {
        return false;
    }

    abstract boolean isValid();

    int ue() {
        int n2 = 0;
        Object[] objectArray = this.aEK.keySet().toArray();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            d d2 = this.aEK.get(objectArray[i2]);
            try {
                e e2 = d2.uk();
                if (e2 == null) continue;
                for (int i3 = -e2.getFontCount(); i3 <= e2.getPageCount(); ++i3) {
                    try {
                        n2 += e2.dg(i3).length;
                        continue;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return n2;
    }

    public void resetCacheTimeout(ReportCacheKey reportCacheKey) {
        d d2 = this.f(reportCacheKey);
        if (d2 != null) {
            d2.ul();
        }
    }

    long uf() {
        return this.aEL;
    }

    static {
        aEQ = new s();
        aES = new byte[0];
        aET = 0;
        aEU = new Object();
        DataSourceConfigurationManager.addDataSourceConfigurationListener(new b());
    }

    static class a
    implements Runnable {
        private final ReportCacheKey Ir;
        private final Properties props;
        private final PropertiesChecker o;
        private final Object aEW;
        private final k aEX;
        private CacheRenderData aEY;
        private ReportCacheKey aEZ;

        public a(ReportCacheKey reportCacheKey, Properties properties, PropertiesChecker propertiesChecker, Object object, k k2) {
            this.Ir = reportCacheKey;
            this.props = properties;
            this.o = propertiesChecker;
            this.aEW = object;
            this.aEX = k2;
        }

        @Override
        public void run() {
            try {
                while (!JF.isFinishWrittenToStore(this.aEZ)) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        BaseUtils.printStackTrace(interruptedException);
                    }
                    if (!BaseUtils.isDebug()) continue;
                    BaseUtils.debug("JRA/JAR waiting for JAVA");
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                if (this.props.get("export_fmt").equals("jra")) {
                    ArchiveFactory.store(byteArrayOutputStream, this.aEY);
                } else {
                    ArchiveFactory.storeWithViewer(byteArrayOutputStream, this.aEY);
                }
                try {
                    byteArrayOutputStream.flush();
                }
                catch (IOException iOException) {
                    BaseUtils.printStackTrace(iOException);
                }
                Cache.getCache().delete(this.aEZ);
                this.aEX.aD(byteArrayOutputStream.toByteArray());
                this.aEX.aE(new byte[0]);
            }
            catch (Throwable throwable) {
                BaseUtils.printStackTrace(throwable);
                this.aEX.aG(IOFunctions.serialize(throwable));
            }
        }

        private void init() throws ReportException {
            Properties properties = (Properties)this.props.clone();
            properties.put("export_fmt", "java");
            properties.remove("file");
            properties.remove("");
            properties.remove("getscheduleinprocessreport");
            properties.put("jra_java_id", String.valueOf(aEN.nextLong()));
            this.aEY = new CacheRenderData(properties, this.o, this.aEW);
            this.aEZ = Cache.getCache().getKey(properties);
        }
    }
}

