/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.cache;

import com.inet.report.BaseUtils;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.cache.Cache;
import com.inet.report.cache.i;
import com.inet.report.i18n.ErrorCode;
import com.inet.report.util.g;
import java.sql.Connection;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class ExternalDBCache
extends i {
    private static final Vector<Connection> aGc = new Vector();
    private static InitialContext aco;

    ExternalDBCache() {
    }

    public static boolean isConnectionNeeded() throws ReportException {
        return aGc.size() < 3;
    }

    public static void addConnection(Connection connection) throws ReportException {
        ExternalDBCache.uK();
        aGc.add(connection);
        ((ExternalDBCache)Cache.getCache()).uB();
    }

    public static void checkConnections(String string) throws ReportException {
        ExternalDBCache.uK();
        String string2 = null;
        if (ExternalDBCache.isConnectionNeeded()) {
            try {
                string2 = "java:comp/env/jdbc/" + string;
                if (aco == null) {
                    aco = new InitialContext();
                }
                DataSource dataSource = (DataSource)aco.lookup(string2);
                if (BaseUtils.isInfo()) {
                    BaseUtils.info("[Cache] lookup of ds okay : " + dataSource);
                }
                while (ExternalDBCache.isConnectionNeeded()) {
                    ExternalDBCache.addConnection(dataSource.getConnection());
                }
            }
            catch (NameNotFoundException nameNotFoundException) {
                if (BaseUtils.gk()) {
                    BaseUtils.warning("[Cache] datasource not found: >" + string2 + "<");
                }
            }
            catch (NamingException namingException) {
                if (BaseUtils.gk()) {
                    BaseUtils.warning("[Cache] JNDI problems: " + namingException.getMessage());
                }
            }
            catch (Exception exception) {
                BaseUtils.printStackTrace(exception);
            }
        }
    }

    private static void uK() throws ReportException {
        if (g.Zf() != 3) {
            Object[] objectArray = new Object[]{};
            throw ReportExceptionFactory.createReportException(ErrorCode.noExternalDBCache, objectArray);
        }
    }

    @Override
    boolean isValid() {
        return true;
    }

    @Override
    Connection uA() throws ReportException {
        for (int i2 = 0; i2 < 10; ++i2) {
            try {
                Connection connection = aGc.remove(0);
                return connection;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    throw ReportExceptionFactory.createReportExceptionWithCause(interruptedException);
                }
            }
        }
        Object[] objectArray = new Object[]{};
        throw ReportExceptionFactory.createReportException(ErrorCode.noConnInCache, objectArray);
    }
}

