/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.cache;

import com.inet.report.BaseUtils;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.bd;
import com.inet.report.i18n.ErrorCode;
import java.util.Hashtable;

public final class ReportCacheKey {
    private final String aFK;
    private final String parameter;
    private final String tg;
    private final long aFJ;
    private final boolean aGw;
    private static final Hashtable<ReportCacheKey, bd> aGx = new Hashtable();

    public ReportCacheKey(String string, String string2, String string3, long l2) throws ReportException {
        this(string, string2, string3, l2, false);
    }

    public ReportCacheKey(String string, String string2, String string3, long l2, boolean bl2) throws ReportException {
        if (string == null || string.length() == 0) {
            throw ReportExceptionFactory.createReportException(ErrorCode.EmptyReport, new Object[0]);
        }
        this.aFK = string;
        this.parameter = string2 != null ? string2 : "";
        this.tg = string3 != null ? string3 : "";
        this.aFJ = l2;
        this.aGw = bl2;
    }

    public int hashCode() {
        return this.aFK.hashCode() + this.parameter.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.hashCode() == object.hashCode() && object instanceof ReportCacheKey) {
            ReportCacheKey reportCacheKey = (ReportCacheKey)object;
            if (this.aFK.equals(reportCacheKey.aFK) && this.parameter.equals(reportCacheKey.parameter) && this.tg.equals(reportCacheKey.tg) && this.aGw == reportCacheKey.aGw) {
                return true;
            }
        }
        return false;
    }

    boolean r(Object object) {
        if (object == null) {
            return false;
        }
        if (this.hashCode() == object.hashCode() && object instanceof ReportCacheKey) {
            ReportCacheKey reportCacheKey = (ReportCacheKey)object;
            if (this.aFK.equals(reportCacheKey.aFK) && this.parameter.equals(reportCacheKey.parameter) && this.tg.equals(reportCacheKey.tg)) {
                return true;
            }
        }
        return false;
    }

    public String getReport() {
        return this.aFK;
    }

    public String getParameter() {
        return this.parameter;
    }

    public long getVGen() {
        return this.aFJ;
    }

    public String getFormat() {
        return this.tg;
    }

    public boolean isRequestScheduleInProcessReport() {
        return this.aGw;
    }

    boolean a(String string, String string2, String string3, int n2) {
        if (this.aFK.equalsIgnoreCase(string) && this.tg.equalsIgnoreCase(string2) && this.parameter.equalsIgnoreCase(string3)) {
            if (this.aGw) {
                return n2 == 2;
            }
            return n2 != 2;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("ReportCacheKey:\n report: " + this.aFK);
        stringBuffer.append("\n format: " + this.tg);
        stringBuffer.append("\n parameter: " + this.parameter);
        stringBuffer.append("\n vgen: " + this.aFJ);
        stringBuffer.append("\n getscheduleinprocessreport: " + this.aGw);
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object s(ReportCacheKey reportCacheKey) {
        Hashtable<ReportCacheKey, bd> hashtable = aGx;
        synchronized (hashtable) {
            bd bd2 = aGx.get(reportCacheKey);
            if (bd2 == null) {
                bd2 = new bd(0);
                aGx.put(reportCacheKey, bd2);
            }
            bd2.kT();
            return bd2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void t(ReportCacheKey reportCacheKey) {
        Hashtable<ReportCacheKey, bd> hashtable = aGx;
        synchronized (hashtable) {
            bd bd2 = aGx.get(reportCacheKey);
            if (bd2 != null) {
                bd2.kU();
                if (bd2.getValue() == 0) {
                    aGx.remove(reportCacheKey);
                }
            } else if (BaseUtils.isDebug()) {
                BaseUtils.debug("Couldn't find Semaphore in clearSemaphore for key:" + reportCacheKey);
            }
        }
    }

    public ReportCacheKey create(boolean bl2) {
        try {
            ReportCacheKey reportCacheKey = new ReportCacheKey(this.aFK, this.parameter, this.tg, this.aFJ, bl2);
            return reportCacheKey;
        }
        catch (ReportException reportException) {
            return null;
        }
    }
}

