/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.certificate;

import com.inet.report.BaseUtils;
import com.inet.report.certificate.b;
import com.inet.report.dk;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.math.BigInteger;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.interfaces.DSAKey;
import java.security.interfaces.RSAKey;
import java.util.HashMap;

public class CertificateInfo {
    private String aGF;
    private String aGG;
    private String aGH;
    private String aGI;
    private String aGJ;
    private String aGK;
    private b aGL;
    private static HashMap<Integer, CertificateInfo> aGM = new HashMap();

    private CertificateInfo(String string, String string2, String string3, String string4, String string5, String string6) {
        this.aGF = string;
        this.aGG = string2;
        this.aGH = string3;
        this.aGI = string4;
        this.aGJ = string5;
        this.aGK = string6;
    }

    public static CertificateInfo getInstance(String string, String string2, String string3, String string4, String string5, String string6) throws IllegalArgumentException {
        Integer n2;
        CertificateInfo certificateInfo;
        String string7 = null;
        if (string == null || string.length() == 0) {
            string7 = "keystore type is not defined";
        } else if (string2 == null || string2.length() == 0) {
            string7 = "keystore file is not defined";
        } else if (string3 == null || string3.length() == 0) {
            string7 = "keystore password is not defined";
        } else if (string5 == null || string5.length() == 0) {
            string5 = string3;
            if (BaseUtils.isDebug()) {
                BaseUtils.debug("key password is not defined: keystore password will be used");
            }
        }
        if (string7 != null) {
            throw new IllegalArgumentException("sign pdf failed: " + string7);
        }
        if (string6 == null || string6.length() == 0) {
            string6 = "SHA1";
        }
        if ((certificateInfo = aGM.get(n2 = CertificateInfo.b(string, string2, string3, string4, string5, string6))) == null) {
            Integer n3 = null;
            if (string5 == null || string5.length() == 0) {
                string5 = string3;
                if (BaseUtils.isDebug()) {
                    BaseUtils.debug("key password is not defined: keystore password will be used");
                }
                n3 = CertificateInfo.b(string, string2, string3, string4, string5, string6);
            }
            try {
                string3 = BaseUtils.decrypt(string3);
                string5 = BaseUtils.decrypt(string5);
                if (string5.length() == 0) {
                    string5 = string3;
                }
                certificateInfo = new CertificateInfo(string, string2, string3, string4, string5, string6);
                certificateInfo.uS();
                aGM.put(n2, certificateInfo);
                if (n3 != null) {
                    aGM.put(n3, certificateInfo);
                }
                return certificateInfo;
            }
            catch (Throwable throwable) {
                throw new IllegalArgumentException("sign pdf failed: " + throwable.getMessage(), throwable);
            }
        }
        return certificateInfo;
    }

    private void uS() {
        Object object;
        KeyStore keyStore = null;
        try {
            keyStore = KeyStore.getInstance(this.aGF);
        }
        catch (KeyStoreException keyStoreException) {
            throw new RuntimeException("invalid or unknown type of keyStore: " + this.aGF, keyStoreException);
        }
        try {
            object = this.aGH.toCharArray();
            keyStore.load(new FileInputStream(this.aGG), (char[])object);
            if (!keyStore.aliases().hasMoreElements()) {
                throw new RuntimeException("Key store has no entries");
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException("file " + this.aGG + " not found", fileNotFoundException);
        }
        catch (Exception exception) {
            throw new RuntimeException("key store loading from  " + this.aGG + " failed:" + exception.getMessage(), exception);
        }
        object = BaseUtils.a(keyStore, this.aGH, this.aGI, this.aGJ, this.aGG, this.aGF, false);
        PrivateKey privateKey = ((dk)object).rP();
        try {
            String string = privateKey.getAlgorithm();
            int n2 = 0;
            if ("RSA".equals(string)) {
                RSAKey rSAKey = (RSAKey)((Object)privateKey);
                n2 = rSAKey.getModulus().bitLength();
            } else if ("DSA".equals(string)) {
                DSAKey dSAKey = (DSAKey)((Object)privateKey);
                BigInteger bigInteger = dSAKey.getParams().getP();
                n2 = bigInteger.bitLength();
            } else {
                throw new RuntimeException("Signature encryption with " + string + " is not supported");
            }
            if (n2 != 0) {
                this.aGL = new b(n2, privateKey, ((dk)object).getCertificate(), ((dk)object).getCertificateChain());
            } else if (BaseUtils.isDebug()) {
                BaseUtils.debug("key string is empty: no signature will be  set");
            }
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Key size can not be determned: " + throwable.getMessage(), throwable);
        }
    }

    private static Integer b(String string, String string2, String string3, String string4, String string5, String string6) {
        if (string == null) {
            throw new IllegalArgumentException("keyStoreType is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("keyStorePath is null");
        }
        if (string3 == null) {
            throw new IllegalArgumentException("keyStorePassword is null");
        }
        int n2 = 1;
        n2 = 31 * n2 + (string6 == null ? 0 : string6.hashCode());
        n2 = 31 * n2 + (string4 == null ? 0 : string4.hashCode());
        n2 = 31 * n2 + (string5 == null ? 0 : string5.hashCode());
        n2 = 31 * n2 + string3.hashCode();
        n2 = 31 * n2 + string2.hashCode();
        n2 = 31 * n2 + string.hashCode();
        return n2;
    }

    public b getSignatureProcessor(String string) {
        if (this.aGL == null) {
            throw new IllegalStateException("processor is not initialized");
        }
        if (string == null) {
            string = this.aGK;
        }
        return this.aGL.cb(string);
    }

    public Certificate getCertificate() {
        if (this.aGL != null) {
            return this.aGL.getCertificate();
        }
        return null;
    }
}

