/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.chart;

import com.inet.report.BaseUtils;
import com.inet.report.Chart2;
import com.inet.report.FormulaField;
import com.inet.report.chart.f;
import com.inet.report.n;
import com.inet.report.o;
import com.inet.report.util.ad;
import java.awt.Font;
import java.io.Serializable;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ChartTitle
implements Serializable {
    public static final String TOKEN_HEADER = "Header";
    public static final String TOKEN_SUBTITLE = "Subtitle";
    public static final String TOKEN_FOOTNOTE = "Footnote";
    public static final String TOKEN_AXIS = "AxisTitle";
    private boolean aGW = true;
    private String title;
    private String aGX;
    private Font font;
    private int color;
    private FormulaField aGY;

    public ChartTitle(Font font, int n2) {
        this.setFont(font);
        this.setColor(n2);
        this.setTitle("");
        this.cc("");
    }

    public boolean isShowAutoTitle() {
        return this.aGW;
    }

    public void setShowAutoTitle(boolean bl2) {
        this.aGW = bl2;
    }

    void cc(String string) {
        if (string == null) {
            throw n.T("autoTitle");
        }
        this.aGX = string;
    }

    String uW() {
        return this.aGX;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        if (string == null) {
            throw n.T("title");
        }
        this.title = string;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int n2) {
        if (n2 == -1) {
            throw n.U("titleColor");
        }
        this.color = n2;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font == null) {
            throw n.T("titleFont");
        }
        this.font = font;
    }

    public boolean isEqualToDefault(ChartTitle chartTitle) {
        if (!this.getFont().equals(chartTitle.getFont())) {
            return false;
        }
        if (this.getColor() != chartTitle.getColor()) {
            return false;
        }
        return this.isShowAutoTitle() && chartTitle.isShowAutoTitle();
    }

    public void saveProperties(StringBuilder stringBuilder, String string, int n2) {
        stringBuilder.append(BaseUtils.L(n2));
        stringBuilder.append("<");
        stringBuilder.append(string);
        stringBuilder.append(' ');
        f.b(stringBuilder, "showAutoTitle", String.valueOf(this.isShowAutoTitle()));
        f.b(stringBuilder, "title", ad.ew(this.getTitle()));
        stringBuilder.append(">\n");
        f.a(stringBuilder, n2, this.getFont(), this.getColor());
        if (this.aGY != null) {
            o.a(stringBuilder, n2, this.aGY, "chartTitle");
        }
        stringBuilder.append(BaseUtils.L(n2));
        stringBuilder.append("<");
        stringBuilder.append("/");
        stringBuilder.append(string);
        stringBuilder.append(">\n");
    }

    public void readProperties(Element element, Chart2 chart2) {
        Object object;
        String string;
        if (element.getAttribute("showAutoTitle").length() > 0) {
            this.setShowAutoTitle(Boolean.parseBoolean(element.getAttribute("showAutoTitle")));
        }
        if ((string = element.getAttribute("title")) == null) {
            string = "";
        }
        this.setTitle(string);
        NodeList nodeList = element.getChildNodes();
        if (nodeList.getLength() > 0) {
            this.setColor(o.b(nodeList.item(0).getChildNodes()));
            this.setFont(o.a(nodeList.item(0).getChildNodes()));
        } else {
            int n2;
            object = f.cd(element.getAttribute("font"));
            if (object != null) {
                this.setFont((Font)object);
            }
            if (element.getAttribute("color").length() > 0 && (n2 = Integer.parseInt(element.getAttribute("color"))) != -1) {
                this.setColor(n2);
            }
        }
        object = element.getChildNodes();
        FormulaField formulaField = o.a((NodeList)object, chart2, "chartTitle");
        if (formulaField != null) {
            this.setTitleFormula(formulaField);
            chart2.updateReferences();
        }
    }

    public ChartTitle clone() {
        ChartTitle chartTitle = new ChartTitle(this.font, this.color);
        chartTitle.aGX = this.aGX;
        chartTitle.aGW = this.aGW;
        chartTitle.title = this.title;
        return chartTitle;
    }

    public void setTitleFormula(FormulaField formulaField) {
        this.aGY = formulaField;
        if (this.aGY != null) {
            this.aGY.resetReferences();
        }
    }

    public FormulaField getTitleFormula() {
        return this.aGY;
    }
}

