/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.chart.axis;

import com.inet.report.BaseUtils;
import com.inet.report.chart.f;
import com.inet.report.n;
import java.io.Serializable;
import java.util.Date;
import org.w3c.dom.Element;

public class DateRange
implements Serializable {
    private Date aHF;
    private Date aHG;
    private boolean YD;

    public DateRange() {
        this.YD = true;
    }

    public DateRange(Date date, Date date2) {
        if (date == null) {
            throw n.T("lower");
        }
        if (date2 == null) {
            throw n.T("upper");
        }
        if (date.after(date2)) {
            throw new IllegalArgumentException("Parameter 'upper' before 'lower'.");
        }
        this.YD = false;
        this.aHF = (Date)date.clone();
        this.aHG = (Date)date2.clone();
    }

    public boolean isAutoRange() {
        return this.YD;
    }

    public void setAutoRange(boolean bl2) {
        this.YD = bl2;
    }

    public Date getLowerBound() {
        if (this.aHF != null) {
            return (Date)this.aHF.clone();
        }
        return null;
    }

    public void setLowerBound(Date date) {
        if (this.aHG != null && this.aHG.before(date)) {
            throw new IllegalArgumentException("Parameter 'lower' greater than upper bound.");
        }
        this.aHF = date != null ? (Date)date.clone() : null;
    }

    public Date getUpperBound() {
        if (this.aHG != null) {
            return (Date)this.aHG.clone();
        }
        return null;
    }

    public void setUpperBound(Date date) {
        if (this.aHF != null && this.aHF.after(date)) {
            throw new IllegalArgumentException("Parameter 'upper' less than 'lower'.");
        }
        this.aHG = date != null ? (Date)date.clone() : null;
    }

    boolean vq() {
        return this.getUpperBound() != null && this.getLowerBound() != null;
    }

    void saveProperties(StringBuilder stringBuilder, int n2) {
        if (!this.isAutoRange() && this.vq()) {
            stringBuilder.append(BaseUtils.L(n2));
            stringBuilder.append("<");
            stringBuilder.append("RangeDate");
            stringBuilder.append(' ');
            if (this.aHF != null) {
                f.b(stringBuilder, "lowerBound", Long.toString(this.aHF.getTime()));
            }
            if (this.aHG != null) {
                f.b(stringBuilder, "upperBound", Long.toString(this.aHG.getTime()));
            }
            stringBuilder.append("/");
            stringBuilder.append(">\n");
        }
    }

    void readProperties(Element element) {
        long l2;
        this.setAutoRange(false);
        String string = element.getAttribute("lowerBound");
        if (string.length() > 0) {
            l2 = Long.valueOf(string);
            this.setLowerBound(new Date(l2));
        }
        if ((string = element.getAttribute("upperBound")).length() > 0) {
            l2 = Long.valueOf(string);
            this.setUpperBound(new Date(l2));
        }
    }
}

