/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.chart.axis;

import com.inet.report.BaseUtils;
import com.inet.report.Chart2;
import com.inet.report.FormulaField;
import com.inet.report.chart.axis.BaseAxis;
import com.inet.report.chart.f;
import com.inet.report.o;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GroupAxis
extends BaseAxis {
    public static final Integer DEFAULT_MAXIMUM_LINES = 2;
    public static final Double DEFAULT_ROTATION_ANGLE = new Double(0.0);
    public static final Float DEFAULT_WIDTH_RATIO = new Float(0.0f);
    private boolean aHL = true;
    private Double aHM;
    private Float aHN = DEFAULT_WIDTH_RATIO;
    private Integer aHO = DEFAULT_MAXIMUM_LINES;
    private int aHP;
    private FormulaField aHQ;

    public GroupAxis() {
        this.aHM = DEFAULT_ROTATION_ANGLE;
        this.setGridlinesVisible(false);
        this.aHP = 1;
    }

    public boolean isAutoFitTickLabel() {
        return this.aHL;
    }

    public void setAutoFitTickLabel(boolean bl2) {
        this.aHL = bl2;
    }

    public Double getTickLabelRotationAngle() {
        return this.aHM;
    }

    public void setTickLabelRotationAngle(Double d2) {
        this.aHM = d2;
    }

    public Float getTickLabelWidthRatio() {
        return this.aHN;
    }

    public void setTickLabelWidthRatio(Float f2) {
        this.aHN = f2;
    }

    public Integer getTickLabelMaximumLines() {
        return this.aHO;
    }

    public void setTickLabelMaximumLines(Integer n2) {
        this.aHO = n2;
    }

    public int getShowEachNthTickLabel() {
        return this.aHP;
    }

    public void setShowEachNthTickLabel(int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("Parameter 'showEachNthTickLabel' should be greater zero");
        }
        this.aHP = n2;
    }

    public FormulaField getShowEachNthTickLabelFormula() {
        return this.aHQ;
    }

    public void setShowEachNthTickLabelFormula(FormulaField formulaField) {
        if (this.aHQ != null) {
            this.aHQ.resetReferences();
        }
        this.aHQ = formulaField;
    }

    @Override
    protected StringBuilder dm(int n2) {
        StringBuilder stringBuilder = super.dm(n2);
        if (!this.isAutoFitTickLabel()) {
            stringBuilder.append(BaseUtils.L(n2));
            stringBuilder.append("<");
            stringBuilder.append("TickLabelAdjusting");
            stringBuilder.append(' ');
            f.b(stringBuilder, "angle", String.valueOf(this.getTickLabelRotationAngle()));
            f.b(stringBuilder, "width", String.valueOf(this.getTickLabelWidthRatio()));
            f.b(stringBuilder, "lines", String.valueOf(this.getTickLabelMaximumLines()));
            stringBuilder.append("/");
            stringBuilder.append(">\n");
        }
        if (this.getShowEachNthTickLabel() > 1) {
            f.b(stringBuilder, n2, "ShowNthLabels", String.valueOf(this.getShowEachNthTickLabel()));
        }
        if (this.aHQ != null) {
            o.a(stringBuilder, n2, this.aHQ, "chartAxisShowNthLabel");
        }
        return stringBuilder;
    }

    @Override
    public void readProperties(Element element, Chart2 chart2) {
        super.readProperties(element, chart2);
        this.setAutoFitTickLabel(true);
        NodeList nodeList = element.getChildNodes();
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            String string;
            if (!(nodeList.item(i2) instanceof Element)) continue;
            Element element2 = (Element)nodeList.item(i2);
            if (element2.getNodeName().equals("TickLabelAdjusting")) {
                this.setAutoFitTickLabel(false);
                string = element2.getAttribute("angle");
                if (string.length() > 0) {
                    if (string.equals("null")) {
                        this.setTickLabelRotationAngle(null);
                    } else {
                        double d2 = Double.parseDouble(string);
                        this.setTickLabelRotationAngle(new Double(d2));
                    }
                }
                if ((string = element2.getAttribute("width")).length() > 0) {
                    if (string.equals("null")) {
                        this.setTickLabelWidthRatio(null);
                    } else {
                        float f2 = Float.parseFloat(string);
                        if (f2 >= 0.0f && f2 <= 1.0f) {
                            this.setTickLabelWidthRatio(new Float(f2));
                        }
                    }
                }
                if ((string = element2.getAttribute("lines")).length() > 0) {
                    if (string.equals("null")) {
                        this.setTickLabelMaximumLines(null);
                    } else {
                        int n2 = Integer.parseInt(string);
                        this.setTickLabelMaximumLines(n2);
                    }
                }
            }
            if (!element2.getNodeName().equals("ShowNthLabels") || (string = element2.getAttribute("value")).length() <= 0) continue;
            int n3 = Integer.parseInt(string);
            this.setShowEachNthTickLabel(n3);
        }
        FormulaField formulaField = o.a(nodeList, chart2, "chartAxisShowNthLabel");
        if (formulaField != null) {
            this.setShowEachNthTickLabelFormula(formulaField);
            chart2.updateReferences();
        }
    }
}

