/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.chart.format;

import com.inet.report.chart.f;
import com.inet.report.chart.format.ChartFormat;
import com.inet.report.chart.format.FormatingProperties;
import com.inet.report.n;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DateTimeFormat
extends DateFormat
implements ChartFormat {
    public static final String PATTERN_CONSTANT_FULL = "DateTimeFormat.PATTERN_FULL";
    public static final String PATTERN_CONSTANT_LONG = "DateTimeFormat.PATTERN_LONG";
    public static final String PATTERN_CONSTANT_MEDIUM = "DateTimeFormat.PATTERN_MEDIUM";
    public static final String PATTERN_CONSTANT_SHORT = "DateTimeFormat.PATTERN_SHORT";
    public static final String PATTERN_CONSTANT_DATE_D_MMMM_YYYY = "d. MMMM yyyy";
    public static final String PATTERN_CONSTANT_DATE_YYYY = "yyyy";
    public static final String PATTERN_CONSTANT_DATE_MMMM_YYYY = "MMMM yyyy";
    public static final String PATTERN_CONSTANT_DATE_MMM_YY = "MMM yy";
    public static final String PATTERN_CONSTANT_DATE_MMMM = "MMMM";
    public static final String PATTERN_CONSTANT_DATE_EEEE = "EEEE";
    public static final String PATTERN_CONSTANT_TIME_MM = "mm";
    public static final String PATTERN_CONSTANT_TIME_SS = "ss";
    private FormatingProperties aIu = new FormatingProperties();
    private SimpleDateFormat aIv;
    private String aIw = "DateTimeFormat.PATTERN_SHORT";
    private String aIx = "DateTimeFormat.PATTERN_SHORT";

    public String getDatePatternConstant() {
        return this.aIw;
    }

    public void setDatePatternConstant(String string) {
        this.aIw = string;
        this.aIv = null;
    }

    public String getTimePatternConstant() {
        return this.aIx;
    }

    public void setTimePatternConstant(String string) {
        this.aIx = string;
        this.aIv = null;
    }

    @Override
    public void setLocale(Locale locale) {
        if (locale == null) {
            throw n.T("locale");
        }
        this.setFormatingProperties(new FormatingProperties(this.aIu.getTimeZone(), locale, this.aIu.getNumeralLanguage()));
    }

    @Override
    public void setFormatingProperties(FormatingProperties formatingProperties) {
        if (formatingProperties == null) {
            throw new IllegalArgumentException("Parameter 'properties' is null.");
        }
        this.aIu = formatingProperties;
        this.aIv = null;
    }

    @Override
    public StringBuffer format(Date date, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (this.aIv == null) {
            this.aIv = new SimpleDateFormat(this.getPattern(), this.aIu.getLocale());
        }
        return this.aIv.format(date, stringBuffer, fieldPosition);
    }

    private String getPattern() {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = DateTimeFormat.cf(this.aIw);
        int n3 = DateTimeFormat.cf(this.aIx);
        if (n2 != -1) {
            stringBuffer.append(((SimpleDateFormat)DateFormat.getDateInstance(n2, this.aIu.getLocale())).toPattern());
            if (n3 != -1 || this.aIx != null) {
                stringBuffer.append(' ');
            }
        } else if (this.aIw != null) {
            stringBuffer.append(this.aIw);
            if (n3 != -1 || this.aIx != null) {
                stringBuffer.append(' ');
            }
        }
        if (n3 != -1) {
            stringBuffer.append(((SimpleDateFormat)DateFormat.getTimeInstance(n3, this.aIu.getLocale())).toPattern());
        } else if (this.aIx != null) {
            stringBuffer.append(this.aIx);
        }
        return stringBuffer.toString();
    }

    private static int cf(String string) {
        if (string == null) {
            return -1;
        }
        if (string.equals(PATTERN_CONSTANT_FULL)) {
            return 0;
        }
        if (string.equals(PATTERN_CONSTANT_LONG)) {
            return 1;
        }
        if (string.equals(PATTERN_CONSTANT_MEDIUM)) {
            return 2;
        }
        if (string.equals(PATTERN_CONSTANT_SHORT)) {
            return 3;
        }
        return -1;
    }

    @Override
    public Date parse(String string, ParsePosition parsePosition) {
        throw new RuntimeException("Method not implemented.");
    }

    @Override
    public void saveProperties(StringBuilder stringBuilder, int n2) {
        f.a(stringBuilder, n2, "Format", "type", this.getName());
        if (this.getDatePatternConstant() != null) {
            f.b(stringBuilder, n2 + 1, "DatePatternConstant", this.getDatePatternConstant());
        }
        if (this.getTimePatternConstant() != null) {
            f.b(stringBuilder, n2 + 1, "TimePatternConstant", this.getTimePatternConstant());
        }
        f.a(stringBuilder, n2, "Format", null, true);
    }

    @Override
    public void readProperties(Element element) {
        NodeList nodeList = element.getChildNodes();
        String string = null;
        String string2 = null;
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            String string3;
            if (!(nodeList.item(i2) instanceof Element)) continue;
            Element element2 = (Element)nodeList.item(i2);
            if (element2.getNodeName().equals("DatePatternConstant")) {
                string3 = element2.getAttribute("value");
                if (string3.length() <= 0) continue;
                string = string3;
                continue;
            }
            if (!element2.getNodeName().equals("TimePatternConstant") || (string3 = element2.getAttribute("value")).length() <= 0) continue;
            string2 = string3;
        }
        this.setDatePatternConstant(string);
        this.setTimePatternConstant(string2);
    }

    protected String getName() {
        return "DateTimeFormat";
    }

    @Override
    public DateTimeFormat clone() {
        DateTimeFormat dateTimeFormat = new DateTimeFormat();
        dateTimeFormat.aIw = this.aIw;
        dateTimeFormat.aIx = this.aIx;
        dateTimeFormat.aIu = (FormatingProperties)this.aIu.clone();
        return dateTimeFormat;
    }
}

