/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.chart.format;

import com.inet.report.chart.f;
import com.inet.report.chart.format.Abbreviation;
import com.inet.report.chart.format.ChartFormat;
import com.inet.report.chart.format.FormatingProperties;
import com.inet.report.n;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FixedNumberFormat
extends NumberFormat
implements ChartFormat {
    public static final int DEFAULT_NUMBER_OF_DECIMAL_PLACES = 2;
    public static final boolean DEFAULT_USE_THOUSANDS_SEPARATOR = true;
    public static final Abbreviation DEFAULT_ABBREVIATION = Abbreviation.ABBREVIATION_NONE;
    public static final int MINUS_SIGN_BEFORE = 0;
    public static final int MINUS_SIGN_AFTER = 1;
    public static final int MINUS_SIGN_BRACKETS = 2;
    public static final int MINUS_SIGN_SYSTEM_DEFAULT = 4;
    public static final int FORMAT_NUMBER = 0;
    public static final int FORMAT_PERCENT = 1;
    public static final int FORMAT_CURRENCY = 2;
    private FormatingProperties aIu = new FormatingProperties();
    private int aIy = 2;
    private boolean aIz = true;
    private int aIA = 4;
    private Abbreviation aIB = Abbreviation.ABBREVIATION_NONE;
    private DecimalFormat aIC;
    private int type;

    public FixedNumberFormat() {
        this(0);
    }

    public FixedNumberFormat(int n2) {
        if (n2 < 0 || n2 > 2) {
            throw new IllegalArgumentException("The parameter 'type' is illegal.");
        }
        this.type = n2;
    }

    public Abbreviation getAbbreviation() {
        return this.aIB;
    }

    public void setAbbreviation(Abbreviation abbreviation) {
        if (abbreviation == null) {
            throw n.T("abbreviation");
        }
        this.aIB = abbreviation;
    }

    public int getNumberOfDecimalPlaces() {
        return this.aIy;
    }

    public void setNumberOfDecimalPlaces(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("The parameter 'numberOfDecimalPlaces' is less than zero.");
        }
        this.aIy = n2;
        this.aIC = null;
    }

    public boolean isUseThousandSeparator() {
        return this.aIz;
    }

    public void setUseThousandSeparator(boolean bl2) {
        this.aIz = bl2;
        this.aIC = null;
    }

    public int getMinusSymbol() {
        return this.aIA;
    }

    public void setMinusSymbol(int n2) {
        this.aIA = n2;
    }

    @Override
    public void setLocale(Locale locale) {
        if (locale == null) {
            throw n.T("locale");
        }
        this.setFormatingProperties(new FormatingProperties(this.aIu.getTimeZone(), locale, this.aIu.getNumeralLanguage()));
    }

    @Override
    public void setFormatingProperties(FormatingProperties formatingProperties) {
        if (formatingProperties == null) {
            throw new IllegalArgumentException("Parameter 'properties' is null.");
        }
        this.aIu = formatingProperties;
        this.aIC = null;
    }

    @Override
    public StringBuffer format(double d2, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.a(d2, stringBuffer, fieldPosition);
    }

    @Override
    public StringBuffer format(long l2, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.a(l2, stringBuffer, fieldPosition);
    }

    @Override
    public Number parse(String string, ParsePosition parsePosition) {
        throw new RuntimeException("Method not implemented.");
    }

    private StringBuffer a(double d2, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (this.aIC == null) {
            String string = FixedNumberFormat.a(this);
            switch (this.type) {
                case 2: {
                    this.aIC = (DecimalFormat)NumberFormat.getCurrencyInstance(this.aIu.getLocale());
                    DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getCurrencyInstance(this.aIu.getLocale());
                    if (this.getMinusSymbol() == 4) {
                        this.aIC.applyPattern(string);
                        this.aIC.setPositivePrefix(decimalFormat.getPositivePrefix());
                        this.aIC.setPositiveSuffix(decimalFormat.getPositiveSuffix());
                        this.aIC.setNegativePrefix(decimalFormat.getNegativePrefix());
                        this.aIC.setNegativeSuffix(decimalFormat.getNegativeSuffix());
                        break;
                    }
                    String string2 = decimalFormat.getDecimalFormatSymbols().getCurrencySymbol();
                    string = decimalFormat.getPositivePrefix().indexOf(string2) != -1 ? string2 + string : string + string2;
                    string = this.a(string, this);
                    this.aIC.applyPattern(string);
                    break;
                }
                case 0: {
                    string = this.a(string, this);
                    this.aIC = (DecimalFormat)NumberFormat.getInstance(this.aIu.getLocale());
                    this.aIC.applyPattern(string);
                    break;
                }
                case 1: {
                    this.aIC = (DecimalFormat)NumberFormat.getPercentInstance(this.aIu.getLocale());
                    string = string + '%';
                    string = this.a(string, this);
                    this.aIC.applyPattern(string);
                }
            }
        }
        if (this.type == 0 && !this.aIB.equals(Abbreviation.ABBREVIATION_NONE)) {
            stringBuffer.append(this.aIB.a(d2, this.aIC));
            return stringBuffer;
        }
        return this.aIC.format(d2, stringBuffer, fieldPosition);
    }

    private static String a(FixedNumberFormat fixedNumberFormat) {
        StringBuffer stringBuffer = null;
        stringBuffer = fixedNumberFormat.isUseThousandSeparator() ? new StringBuffer("#,##0") : new StringBuffer("###0");
        int n2 = fixedNumberFormat.getNumberOfDecimalPlaces();
        if (n2 > 0) {
            stringBuffer.append('.');
            for (int i2 = 0; i2 < n2; ++i2) {
                stringBuffer.append('0');
            }
        }
        return stringBuffer.toString();
    }

    private String a(String string, FixedNumberFormat fixedNumberFormat) {
        StringBuffer stringBuffer = new StringBuffer();
        switch (fixedNumberFormat.getMinusSymbol()) {
            case 1: {
                stringBuffer.append(';');
                stringBuffer.append(string);
                stringBuffer.append('-');
                break;
            }
            case 0: {
                stringBuffer.append(';');
                stringBuffer.append('-');
                stringBuffer.append(string);
                break;
            }
            case 2: {
                stringBuffer.append(';');
                stringBuffer.append('(');
                stringBuffer.append(string);
                stringBuffer.append(')');
                break;
            }
        }
        return string + stringBuffer;
    }

    @Override
    public void saveProperties(StringBuilder stringBuilder, int n2) {
        f.a(stringBuilder, n2, "Format", "type", this.getName());
        f.b(stringBuilder, n2 + 1, "Type", String.valueOf(this.type));
        if (this.getNumberOfDecimalPlaces() != 2) {
            f.b(stringBuilder, n2 + 1, "NumberOfDecimalPlaces", String.valueOf(this.getNumberOfDecimalPlaces()));
        }
        if (!this.isUseThousandSeparator()) {
            f.b(stringBuilder, n2 + 1, "UseThousandsSeparator", String.valueOf(this.isUseThousandSeparator()));
        }
        if (this.getMinusSymbol() != 4) {
            f.b(stringBuilder, n2 + 1, "NegativeType", String.valueOf(this.getMinusSymbol()));
        }
        if (this.getAbbreviation() != null) {
            this.getAbbreviation().g(stringBuilder, n2 + 1);
        }
        f.a(stringBuilder, n2, "Format", null, true);
    }

    @Override
    public void readProperties(Element element) {
        NodeList nodeList = element.getChildNodes();
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            Abbreviation abbreviation;
            if (!(nodeList.item(i2) instanceof Element)) continue;
            Element element2 = (Element)nodeList.item(i2);
            if (element2.getNodeName().equals("type") || element2.getNodeName().equals("Type")) {
                int n2;
                if (element2.getAttribute("value").length() <= 0) continue;
                this.type = n2 = Integer.parseInt(element2.getAttribute("value"));
                continue;
            }
            if (element2.getNodeName().equals("NumberOfDecimalPlaces")) {
                if (element2.getAttribute("value").length() <= 0) continue;
                int n3 = Integer.parseInt(element2.getAttribute("value"));
                this.setNumberOfDecimalPlaces(n3);
                continue;
            }
            if (element2.getNodeName().equals("UseThousandSeperators") || element2.getNodeName().equals("UseThousandsSeparator")) {
                String string = element2.getAttribute("value");
                if (string.length() <= 0) continue;
                this.setUseThousandSeparator(Boolean.valueOf(string));
                continue;
            }
            if (element2.getNodeName().equals("NegativeType")) {
                if (element2.getAttribute("value").length() <= 0) continue;
                int n4 = Integer.parseInt(element2.getAttribute("value"));
                this.setMinusSymbol(n4);
                continue;
            }
            if (!element2.getNodeName().equals("Abbreviation") || (abbreviation = Abbreviation.getAbbreviation(element2)) == null) continue;
            this.setAbbreviation(abbreviation);
        }
    }

    @Override
    public FixedNumberFormat clone() {
        FixedNumberFormat fixedNumberFormat = new FixedNumberFormat(this.type);
        fixedNumberFormat.aIB = this.aIB;
        fixedNumberFormat.aIA = this.aIA;
        fixedNumberFormat.aIy = this.aIy;
        fixedNumberFormat.aIz = this.aIz;
        fixedNumberFormat.aIu = (FormatingProperties)this.aIu.clone();
        return fixedNumberFormat;
    }

    protected String getName() {
        return "FixedNumberFormat";
    }

    public int getType() {
        return this.type;
    }
}

