/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.chart.plot;

import com.inet.jfree.chart.labels.CategoryItemLabelGenerator;
import com.inet.report.Chart2;
import com.inet.report.chart.axis.ContinuousNumberAxis;
import com.inet.report.chart.axis.GroupAxis;
import com.inet.report.chart.f;
import com.inet.report.chart.plot.AbstractPlot;
import com.inet.report.chart.plot.BarStyle;
import com.inet.report.chart.plot.ChartStyle;
import com.inet.report.chart.plot.StandardPlot;
import com.inet.report.n;
import java.util.Locale;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BarPlot
extends StandardPlot {
    public static final BarStyle DEFAULT_STYLE = BarStyle.BAR2D;
    public static final int ITEM_LABEL_ALIGNMENT_AUTO = 0;
    public static final int ITEM_LABEL_ALIGNMENT_VERTICAL = 1;
    public static final int ITEM_LABEL_ALIGNMENT_HORIZONTAL = 2;
    @Deprecated
    public static final double DEFAULT_BAR_MARGIN_PERCENT = 0.2;
    public static final double DEFAULT_BAR_WIDTH = 1.0;
    private BarStyle aJl;
    private int aJm;
    private boolean aJn;
    private double aJo;
    private double aJp;

    public BarPlot() {
        this(DEFAULT_STYLE);
    }

    public BarPlot(BarStyle barStyle) {
        if (barStyle == null) {
            throw n.T("style");
        }
        this.aJl = barStyle;
        super.setCategoryAxis(new GroupAxis());
        super.setDataAxis(new ContinuousNumberAxis());
        this.aJm = 0;
        this.aJn = false;
        this.aJo = 0.2;
        this.aJp = 1.0;
    }

    public void setCategoryAxis(GroupAxis groupAxis) {
        super.setCategoryAxis(groupAxis);
    }

    public void setDataAxis(ContinuousNumberAxis continuousNumberAxis) {
        super.setDataAxis(continuousNumberAxis);
    }

    @Override
    public ChartStyle getStyle() {
        return this.aJl;
    }

    public void setStyle(BarStyle barStyle) {
        if (barStyle == null) {
            throw n.T("style");
        }
        this.aJl = barStyle;
    }

    public int getItemLabelAlignment() {
        return this.aJm;
    }

    public void setItemLabelAlignment(int n2) {
        n.Z(n2);
        this.aJm = n2;
    }

    public boolean isShowTotal() {
        return this.aJn;
    }

    public void setShowTotal(boolean bl2) {
        this.aJn = bl2;
    }

    @Deprecated
    public double getBarMarginPercent() {
        return this.aJo;
    }

    @Deprecated
    public void setBarMarginPercent(double d2) {
        this.aJo = d2;
    }

    public double getBarWidth() {
        return this.aJp;
    }

    public void setBarWidth(double d2) {
        this.aJp = d2;
    }

    CategoryItemLabelGenerator f(Locale locale) {
        BarStyle barStyle = (BarStyle)this.getStyle();
        if (barStyle.isSimpleBar()) {
            return n.a((AbstractPlot)this, locale);
        }
        return n.a(this, barStyle.isPercentBar(), this.isShowCumulativeValues(), locale);
    }

    @Override
    protected StringBuilder dm(int n2) {
        StringBuilder stringBuilder = super.dm(n2);
        if (this.getBarMarginPercent() != 0.2) {
            f.b(stringBuilder, n2, "BarMarginPercent", String.valueOf(this.getBarMarginPercent()));
        }
        if (this.getBarWidth() != 1.0) {
            f.b(stringBuilder, n2, "BarWidth", String.valueOf(this.getBarWidth()));
        }
        if (this.getItemLabelAlignment() != 0) {
            f.b(stringBuilder, n2, "ItemLabelAlignment", String.valueOf(this.getItemLabelAlignment()));
        }
        if (this.isShowTotal()) {
            f.b(stringBuilder, n2, "ShowTotal", String.valueOf(this.isShowTotal()));
        }
        return stringBuilder;
    }

    @Override
    public void readProperties(Element element, Chart2 chart2) {
        super.readProperties(element, chart2);
        NodeList nodeList = element.getChildNodes();
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            String string;
            if (!(nodeList.item(i2) instanceof Element)) continue;
            Element element2 = (Element)nodeList.item(i2);
            if (element2.getNodeName().equals("BarMarginPercent")) {
                double d2;
                string = element2.getAttribute("value");
                if (string.length() <= 0 || !((d2 = Double.parseDouble(string)) >= 0.0)) continue;
                this.setBarMarginPercent(d2);
                continue;
            }
            if (element2.getNodeName().equals("BarWidth")) {
                double d3;
                string = element2.getAttribute("value");
                if (string.length() <= 0 || !((d3 = Double.parseDouble(string)) >= 0.0)) continue;
                this.setBarWidth(d3);
                continue;
            }
            if (element2.getNodeName().equals("ItemLabelAlignment")) {
                int n2;
                string = element2.getAttribute("value");
                if (string.length() <= 0 || (n2 = Integer.parseInt(string)) != 0 && n2 != 2 && n2 != 1) continue;
                this.setItemLabelAlignment(n2);
                continue;
            }
            if (!element2.getNodeName().equals("ShowTotal") || (string = element2.getAttribute("value")).length() <= 0) continue;
            this.setShowTotal(Boolean.valueOf(string));
        }
    }
}

