/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.chart.plot;

import com.inet.report.Chart2;
import com.inet.report.chart.dataset.ForAllRecordsDataset;
import com.inet.report.chart.dataset.ForEachRecordDataset;
import com.inet.report.chart.dataset.OneGroupDataset;
import com.inet.report.chart.dataset.TwoGroupsDataset;
import com.inet.report.chart.dataset.a;
import com.inet.report.chart.plot.AbstractPlot;
import com.inet.report.chart.plot.BarPlot;
import com.inet.report.chart.plot.ChartStyle;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.List;

public class BarStyle
extends ChartStyle {
    public static final BarStyle BAR2D = new BarStyle("BarStyle.BAR2D");
    public static final BarStyle BAR2D_STACKED = new BarStyle("BarStyle.BAR2D_STACKED");
    public static final BarStyle BAR2D_PERCENT = new BarStyle("BarStyle.BAR2D_PERCENT");
    public static final BarStyle BAR3D = new BarStyle("BarStyle.BAR3D");
    public static final BarStyle BAR3D_STACKED = new BarStyle("BarStyle.BAR3D_STACKED");
    public static final BarStyle BAR3D_PERCENT = new BarStyle("BarStyle.BAR3D_PERCENT");

    private BarStyle(String string) {
        super(string);
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof BarStyle)) {
            return false;
        }
        BarStyle barStyle = (BarStyle)object;
        return this.toString().equals(barStyle.toString());
    }

    @Override
    public AbstractPlot getDefaultPlot() {
        return new BarPlot(this);
    }

    @Override
    public List getAllowedDatasets(Chart2 chart2) {
        ArrayList<a> arrayList = new ArrayList<a>(4);
        arrayList.add(new ForAllRecordsDataset(chart2));
        arrayList.add(new ForEachRecordDataset(chart2));
        arrayList.add(new OneGroupDataset(chart2));
        arrayList.add(new TwoGroupsDataset(chart2));
        return arrayList;
    }

    public boolean isSimpleBar() {
        return this.equals(BAR2D) || this.equals(BAR3D);
    }

    public boolean isStackedBar() {
        return this.equals(BAR2D_STACKED) || this.equals(BAR3D_STACKED);
    }

    public boolean isPercentBar() {
        return this.equals(BAR2D_PERCENT) || this.equals(BAR3D_PERCENT);
    }

    private Object readResolve() throws ObjectStreamException {
        BarStyle barStyle = null;
        if (this.equals(BAR2D)) {
            barStyle = BAR2D;
        } else if (this.equals(BAR2D_PERCENT)) {
            barStyle = BAR2D_PERCENT;
        } else if (this.equals(BAR2D_STACKED)) {
            barStyle = BAR2D_STACKED;
        } else if (this.equals(BAR3D)) {
            barStyle = BAR3D;
        } else if (this.equals(BAR3D_PERCENT)) {
            barStyle = BAR3D_PERCENT;
        } else if (this.equals(BAR3D_STACKED)) {
            barStyle = BAR3D_STACKED;
        }
        return barStyle;
    }
}

