/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.chart.plot;

import com.inet.chart3d.geom.ViewParams;
import com.inet.lib.util.ColorUtils;
import com.inet.report.Chart2;
import com.inet.report.chart.a;
import com.inet.report.chart.axis.BaseAxis;
import com.inet.report.chart.axis.DiscreteNumberAxis;
import com.inet.report.chart.dataset.LabelProvider;
import com.inet.report.chart.f;
import com.inet.report.chart.plot.Chart3DStyle;
import com.inet.report.chart.plot.ChartStyle;
import com.inet.report.chart.plot.StandardPlot;
import com.inet.report.n;
import java.awt.Color;
import java.io.PrintWriter;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Chart3DPlot
extends StandardPlot {
    public static final Chart3DStyle DEFAULT_STYLE = Chart3DStyle.BAR;
    public static final int DEFAULT_WALL_COLOR = ColorUtils.toCcColor(new Color(230, 230, 230));
    public static final int DEFAULT_BASE_COLOR = ColorUtils.toCcColor(new Color(180, 180, 180));
    private Chart3DStyle aJq;
    private BaseAxis aJr;
    private int aJs;
    private ViewParams fM;

    public Chart3DPlot() {
        this(DEFAULT_STYLE);
    }

    public Chart3DPlot(Chart3DStyle chart3DStyle) {
        if (chart3DStyle == null) {
            throw n.T("style");
        }
        this.aJq = chart3DStyle;
        this.setCategoryAxis(new BaseAxis());
        this.setSeriesAxis(new BaseAxis());
        this.setDataAxis(new DiscreteNumberAxis());
        this.setBackColor(DEFAULT_BASE_COLOR);
        this.setWallBackColor(DEFAULT_WALL_COLOR);
        this.fM = ViewParams.createDefault();
    }

    public int getWallBackColor() {
        return this.aJs;
    }

    public void setWallBackColor(int n2) {
        this.aJs = n2;
    }

    public BaseAxis getSeriesAxis() {
        return this.aJr;
    }

    public void setSeriesAxis(BaseAxis baseAxis) {
        if (baseAxis == null) {
            throw n.T("seriesAxis");
        }
        this.aJr = baseAxis;
    }

    @Override
    public ChartStyle getStyle() {
        return this.aJq;
    }

    public void setStyle(Chart3DStyle chart3DStyle) {
        if (chart3DStyle == null) {
            throw n.T("style");
        }
        this.aJq = chart3DStyle;
    }

    public ViewParams getViewParams() {
        return this.fM;
    }

    public void setViewParams(ViewParams viewParams) {
        if (viewParams == null) {
            throw n.T("viewParams");
        }
        this.fM = viewParams;
    }

    @Override
    public void refreshAutoTitles(Chart2 chart2) {
        if (this.getDataset() != null) {
            LabelProvider labelProvider = this.getDataset().getLabelProvider();
            a.setAutoTitle(chart2.getHeaderTitle(), labelProvider.getLabel(0));
            a.setAutoTitle(this.getCategoryAxis().getTitle(), labelProvider.getLabel(2));
            a.setAutoTitle(this.getSeriesAxis().getTitle(), labelProvider.getLabel(3));
            a.setAutoTitle(this.getDataAxis().getTitle(), labelProvider.getLabel(4));
        }
    }

    @Override
    protected StringBuilder dm(int n2) {
        StringBuilder stringBuilder = super.dm(n2);
        if (this.getWallBackColor() != DEFAULT_WALL_COLOR) {
            f.b(stringBuilder, n2, "WallBackground", "color", String.valueOf(this.getWallBackColor()));
        }
        if (!this.getViewParams().equals(ViewParams.createDefault())) {
            this.getViewParams().saveProperties(stringBuilder, n2);
        }
        return stringBuilder;
    }

    @Override
    protected void B(PrintWriter printWriter, int n2) {
        super.B(printWriter, n2);
        this.aJr.saveProperties(printWriter, ++n2, "SeriesAxis");
    }

    @Override
    public void readProperties(Element element, Chart2 chart2) {
        super.readProperties(element, chart2);
        NodeList nodeList = element.getChildNodes();
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            if (!(nodeList.item(i2) instanceof Element)) continue;
            Element element2 = (Element)nodeList.item(i2);
            if (element2.getNodeName().equals("SeriesAxis")) {
                this.aJr.readProperties(element2, chart2);
                continue;
            }
            if (element2.getNodeName().equals("WallBackground")) {
                String string = element2.getAttribute("color");
                if (string.length() <= 0) continue;
                int n2 = Integer.parseInt(string);
                this.setWallBackColor(n2);
                continue;
            }
            if (!element2.getNodeName().equals("ViewParam")) continue;
            this.getViewParams().readProperties(element2);
        }
    }
}

