/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.chart.plot;

import com.inet.report.BaseUtils;
import com.inet.report.Chart2;
import com.inet.report.chart.a;
import com.inet.report.chart.dataset.BaseDataset;
import com.inet.report.chart.f;
import com.inet.report.chart.plot.AbstractPlot;
import com.inet.report.chart.plot.AreaStyle;
import com.inet.report.chart.plot.BarStyle;
import com.inet.report.chart.plot.ChartPlot;
import com.inet.report.chart.plot.ChartStyle;
import com.inet.report.chart.plot.ContinuousAreaStyle;
import com.inet.report.chart.plot.ContinuousBarStyle;
import com.inet.report.chart.plot.ContinuousLineStyle;
import com.inet.report.chart.plot.LineStyle;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CombinedPlot
implements ChartPlot {
    public static final String TOKEN_COMBINED_PLOT = "CombinedPlot";
    public static final int COMBINE_ONE_PLOT_WITH_COMMON_GROUP_AXIS = 0;
    public static final int COMBINE_ONE_PLOT_WITH_COMMON_DATA_AXIS = 1;
    public static final int COMBINE_MULTIPLE_PLOTS_WITH_COMMON_GROUP_AXIS = 2;
    public static final int COMBINE_MULTIPLE_PLOTS_WITH_COMMON_DATA_AXIS = 3;
    private ArrayList<AbstractPlot> aJt;
    private int aJu;

    public CombinedPlot() {
        this(0);
    }

    public CombinedPlot(int n2) {
        if (n2 != 2 && n2 != 3 && n2 != 0 && n2 != 1) {
            throw new IllegalArgumentException("Unknown combination type.");
        }
        this.aJt = new ArrayList();
        this.aJu = n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addPlot(AbstractPlot abstractPlot) {
        if (this.aJt.isEmpty()) {
            if (!CombinedPlot.e(abstractPlot) && !CombinedPlot.f(abstractPlot)) throw new IllegalArgumentException("This is a not combinable plot");
            this.aJt.add(abstractPlot);
            return;
        } else {
            AbstractPlot abstractPlot2 = this.aJt.get(0);
            if (CombinedPlot.e(abstractPlot2) && CombinedPlot.e(abstractPlot)) {
                this.aJt.add(abstractPlot);
                return;
            } else {
                if (!CombinedPlot.f(abstractPlot2) || !CombinedPlot.f(abstractPlot)) throw new IllegalArgumentException("Cannot combine this plot with the other plots in the list.");
                this.aJt.add(abstractPlot);
            }
        }
    }

    private static boolean e(AbstractPlot abstractPlot) {
        ChartStyle chartStyle = abstractPlot.getStyle();
        if (chartStyle.equals(BarStyle.BAR2D) || chartStyle.equals(BarStyle.BAR2D_PERCENT) || chartStyle.equals(BarStyle.BAR2D_STACKED)) {
            return true;
        }
        if (chartStyle instanceof LineStyle) {
            return true;
        }
        return chartStyle.equals(AreaStyle.AREA2D_PERCENT) || chartStyle.equals(AreaStyle.AREA2D_STACKED);
    }

    private static boolean f(AbstractPlot abstractPlot) {
        ChartStyle chartStyle = abstractPlot.getStyle();
        return chartStyle instanceof ContinuousLineStyle || chartStyle instanceof ContinuousAreaStyle || chartStyle instanceof ContinuousBarStyle;
    }

    public AbstractPlot removePlot(int n2) {
        return this.aJt.remove(n2);
    }

    public AbstractPlot getPlot(int n2) {
        return this.aJt.get(n2);
    }

    public int size() {
        return this.aJt.size();
    }

    public int getCombineType() {
        return this.aJu;
    }

    public void setCombineType(int n2) {
        if (n2 != 3 && n2 != 2 && n2 != 1 && n2 != 0) {
            throw new IllegalArgumentException("Unknown value of 'combineType': " + n2);
        }
        this.aJu = n2;
    }

    @Override
    public void refreshAutoTitles(Chart2 chart2) {
        for (int i2 = 0; i2 < this.size(); ++i2) {
            this.getPlot(i2).refreshAutoTitles(chart2);
        }
        a.setAutoTitle(chart2.getHeaderTitle(), "");
    }

    @Override
    public void saveProperties(PrintWriter printWriter, int n2) {
        String string = BaseUtils.L(n2);
        ++n2;
        StringBuilder stringBuilder = new StringBuilder();
        f.b(stringBuilder, "type", String.valueOf(this.getCombineType()));
        f.a(printWriter, string, TOKEN_COMBINED_PLOT, stringBuilder, false);
        for (int i2 = 0; i2 < this.aJt.size(); ++i2) {
            this.aJt.get(i2).saveProperties(printWriter, n2);
        }
        f.a(printWriter, string, TOKEN_COMBINED_PLOT, null, true);
    }

    @Override
    public List getReferencedObject() {
        ArrayList arrayList = new ArrayList();
        for (int i2 = 0; i2 < this.size(); ++i2) {
            if (this.getPlot(i2) == null) continue;
            arrayList.addAll(this.getPlot(i2).getReferencedObject());
        }
        return arrayList;
    }

    @Override
    public void readProperties(Element element, Chart2 chart2) {
        String string = element.getAttribute("type");
        if (string.length() > 0) {
            this.setCombineType(Integer.parseInt(string));
        }
        NodeList nodeList = element.getChildNodes();
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            if (!(nodeList.item(i2) instanceof Element)) continue;
            Element element2 = (Element)nodeList.item(i2);
            try {
                if (!element2.getNodeName().equals("Plot")) continue;
                String string2 = element2.getAttribute("style");
                AbstractPlot abstractPlot = null;
                if (string2.length() <= 0) {
                    throw new IllegalArgumentException("Chart style name missing.");
                }
                abstractPlot = f.ce(string2).getDefaultPlot();
                this.addPlot(abstractPlot);
                if (abstractPlot != null) {
                    abstractPlot.readProperties(element2, chart2);
                    continue;
                }
                throw new IllegalArgumentException("Reading sub plot failed.");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                BaseUtils.error("Parsing Chart2 failed!");
                BaseUtils.error(illegalArgumentException);
            }
        }
    }

    @Override
    public BaseDataset getDataset() {
        return null;
    }
}

