/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.chart.plot;

import com.inet.report.Chart2;
import com.inet.report.chart.dataset.ForAllRecordsDataset;
import com.inet.report.chart.dataset.ForEachRecordDataset;
import com.inet.report.chart.dataset.OneGroupDataset;
import com.inet.report.chart.dataset.TwoGroupsDataset;
import com.inet.report.chart.dataset.a;
import com.inet.report.chart.plot.AbstractPlot;
import com.inet.report.chart.plot.ChartStyle;
import com.inet.report.chart.plot.LinePlot;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.List;

public class LineStyle
extends ChartStyle {
    public static final LineStyle LINE = new LineStyle("LineStyle.LINE");
    public static final LineStyle LINE_STACKED = new LineStyle("LineStyle.LINE_STACKED");
    public static final LineStyle LINE_PERCENT = new LineStyle("LineStyle.LINE_PERCENT");
    public static final LineStyle LINE_MARKER = new LineStyle("LineStyle.LINE_MARKER");
    public static final LineStyle LINE_MARKER_STACKED = new LineStyle("LineStyle.LINE_MARKER_STACKED");
    public static final LineStyle LINE_MARKER_PERCENT = new LineStyle("LineStyle.LINE_MARKER_PERCENT");

    private LineStyle(String string) {
        super(string);
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof LineStyle)) {
            return false;
        }
        LineStyle lineStyle = (LineStyle)object;
        return this.toString().equals(lineStyle.toString());
    }

    @Override
    public AbstractPlot getDefaultPlot() {
        return new LinePlot(this);
    }

    @Override
    public List getAllowedDatasets(Chart2 chart2) {
        ArrayList<a> arrayList = new ArrayList<a>(4);
        arrayList.add(new ForAllRecordsDataset(chart2));
        arrayList.add(new ForEachRecordDataset(chart2));
        arrayList.add(new OneGroupDataset(chart2));
        arrayList.add(new TwoGroupsDataset(chart2));
        return arrayList;
    }

    public boolean isSimpleLine() {
        return this.equals(LINE) || this.equals(LINE_MARKER);
    }

    public boolean isStackedLine() {
        return this.equals(LINE_STACKED) || this.equals(LINE_MARKER_STACKED);
    }

    public boolean isPercentLine() {
        return this.equals(LINE_PERCENT) || this.equals(LINE_MARKER_PERCENT);
    }

    public boolean isMarkerLine() {
        return this.equals(LINE_MARKER) || this.equals(LINE_MARKER_PERCENT) || this.equals(LINE_MARKER_STACKED);
    }

    private Object readResolve() throws ObjectStreamException {
        LineStyle lineStyle = null;
        if (this.equals(LINE)) {
            lineStyle = LINE;
        } else if (this.equals(LINE_MARKER)) {
            lineStyle = LINE_MARKER;
        } else if (this.equals(LINE_MARKER_PERCENT)) {
            lineStyle = LINE_MARKER_PERCENT;
        } else if (this.equals(LINE_MARKER_STACKED)) {
            lineStyle = LINE_MARKER_STACKED;
        } else if (this.equals(LINE_PERCENT)) {
            lineStyle = LINE_PERCENT;
        } else if (this.equals(LINE_STACKED)) {
            lineStyle = LINE_STACKED;
        }
        return lineStyle;
    }
}

