/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.chart.plot;

import com.inet.jfree.chart.labels.PieSectionLabelGenerator;
import com.inet.jfree.chart.labels.StandardPieSectionLabelGenerator;
import com.inet.lib.list.IntList;
import com.inet.lib.util.ColorUtils;
import com.inet.report.Chart2;
import com.inet.report.chart.a;
import com.inet.report.chart.dataset.BaseDataset;
import com.inet.report.chart.dataset.LabelProvider;
import com.inet.report.chart.dataset.PieDataset;
import com.inet.report.chart.dataset.b;
import com.inet.report.chart.f;
import com.inet.report.chart.plot.AbstractPlot;
import com.inet.report.chart.plot.ChartStyle;
import com.inet.report.chart.plot.PieLegendLayout;
import com.inet.report.chart.plot.PieStyle;
import com.inet.report.n;
import java.awt.Color;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.StringTokenizer;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PiePlot
extends AbstractPlot {
    public static final PieStyle DEFAULT_STYLE = PieStyle.PIE2D;
    public static final double DEFAULT_ROTATION_ANGLE = 90.0;
    public static final double DEFAULT_ITEM_LABEL_GAP = 0.05;
    public static final int DEFAULT_ITEM_LABEL_BACKGROUND_COLOR = ColorUtils.toCcColor(new Color(255, 255, 192));
    public static final int DEFAULT_ITEM_LABEL_OUTLINE_COLOR = 0;
    public static final int DEFAULT_ITEM_LABEL_OUTLINE_STYLE = 1;
    public static final int DEFAULT_ITEM_LABEL_OUTLINE_WIDTH = 20;
    public static final double DEFAULT_EXPAND_PERCENT = 0.1;
    private PieStyle aJJ;
    private PieDataset aJK;
    private boolean aJL;
    private double aJM;
    private double aJN;
    private int aJO;
    private int aJP;
    private int aJQ;
    private int aJR;
    private boolean aJS;
    private PieLegendLayout aJT;
    private int[] aJU;
    private double aJV;

    public PiePlot() {
        this(DEFAULT_STYLE);
    }

    public PiePlot(PieStyle pieStyle) {
        if (pieStyle == null) {
            throw n.T("style");
        }
        this.aJJ = pieStyle;
        this.setOutlineColor(AbstractPlot.DEFAULT_OUTLINE_COLOR);
        this.aJM = 90.0;
        this.aJN = 0.05;
        this.aJO = DEFAULT_ITEM_LABEL_BACKGROUND_COLOR;
        this.aJP = 0;
        this.aJQ = 1;
        this.aJR = 20;
        this.aJS = true;
        this.aJL = false;
        this.aJT = PieLegendLayout.SHOW_LABEL;
        this.aJU = new int[0];
        this.aJV = 0.1;
    }

    @Override
    public BaseDataset getDataset() {
        return this.aJK;
    }

    public void setDataset(PieDataset pieDataset) {
        if (pieDataset == null) {
            throw n.T("dataset");
        }
        this.aJK = pieDataset;
        this.aJK.updateReferences();
    }

    @Override
    public ChartStyle getStyle() {
        return this.aJJ;
    }

    public void setStyle(PieStyle pieStyle) {
        if (pieStyle == null) {
            throw n.T("style");
        }
        this.aJJ = pieStyle;
    }

    public boolean isIgnoreZeroValues() {
        return this.aJL;
    }

    public void setIgnoreZeroValues(boolean bl2) {
        this.aJL = bl2;
    }

    public double getRotationAngle() {
        return this.aJM;
    }

    public void setRotationAngle(double d2) {
        this.aJM = d2;
    }

    public double getItemLabelGap() {
        return this.aJN;
    }

    public void setItemLabelGap(double d2) {
        if (d2 < 0.0) {
            throw new IllegalArgumentException("The gap is less than zero.");
        }
        if (d2 > 0.49) {
            d2 = 0.49;
        }
        this.aJN = d2;
    }

    public boolean isDrawItemLabelOutline() {
        return this.aJS;
    }

    public void setDrawItemLabelOutline(boolean bl2) {
        this.aJS = bl2;
    }

    public int getItemLabelBackColor() {
        return this.aJO;
    }

    public void setItemLabelBackColor(int n2) {
        this.aJO = n2;
    }

    public int getItemLabelOutlineColor() {
        return this.aJP;
    }

    public void setItemLabelOutlineColor(int n2) {
        if (n2 == -1) {
            throw n.U("outlineColor");
        }
        this.aJP = n2;
    }

    public int getItemLabelOutlineStyle() {
        return this.aJQ;
    }

    public void setItemLabelOutlineStyle(int n2) {
        this.aJQ = n2;
    }

    public int getItemLabelOutlineWidth() {
        return this.aJR;
    }

    public void setItemLabelOutlineWidth(int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("The parameter 'itemLabelOutlineWidth' should be greater zero.");
        }
        this.aJR = n2;
    }

    public PieLegendLayout getLegendLayout() {
        return this.aJT;
    }

    public void setLegendLayout(PieLegendLayout pieLegendLayout) {
        if (pieLegendLayout == null) {
            throw n.T("legendLayout");
        }
        this.aJT = pieLegendLayout;
    }

    public int[] getSectionIndexes() {
        return (int[])this.aJU.clone();
    }

    public void setSectionIndexes(int[] nArray) {
        if (nArray == null) {
            throw n.T("sectionIndexes");
        }
        this.aJU = (int[])nArray.clone();
    }

    public double getExpandPercent() {
        return this.aJV;
    }

    public void setExpandPercent(double d2) {
        if (d2 < 0.0) {
            throw new IllegalArgumentException("Parameter 'expandPercent' less than zero.");
        }
        if (d2 < 0.1) {
            d2 = 0.1;
        }
        this.aJV = d2;
    }

    @Override
    public void refreshAutoTitles(Chart2 chart2) {
        if (this.getDataset() != null) {
            LabelProvider labelProvider = this.getDataset().getLabelProvider();
            a.setAutoTitle(chart2.getHeaderTitle(), labelProvider.getLabel(0));
        }
    }

    PieSectionLabelGenerator g(Locale locale) {
        Serializable serializable;
        NumberFormat numberFormat = NumberFormat.getInstance(locale);
        if (this.getItemLabelFormat() instanceof NumberFormat) {
            serializable = this.getItemLabelFormat();
            serializable.setLocale(locale);
            numberFormat = (NumberFormat)serializable;
        }
        serializable = null;
        boolean bl2 = n.a(this.getItemLabelFormat());
        StringBuffer stringBuffer = new StringBuffer();
        if (bl2) {
            stringBuffer.append("{2}");
        } else {
            stringBuffer.append("{1}");
        }
        if (this.isShowValue()) {
            if (this.isShowLabel()) {
                stringBuffer = new StringBuffer("{0}   ").append(stringBuffer);
            }
            serializable = new StandardPieSectionLabelGenerator(stringBuffer.toString(), numberFormat, numberFormat);
        } else if (this.isShowLabel()) {
            serializable = new StandardPieSectionLabelGenerator("{0}", numberFormat, numberFormat);
        }
        return serializable;
    }

    @Override
    protected StringBuilder dm(int n2) {
        StringBuilder stringBuilder = super.dm(n2);
        if (this.getItemLabelBackColor() != DEFAULT_ITEM_LABEL_BACKGROUND_COLOR) {
            f.b(stringBuilder, n2, "ItemLabelBackground", "value", String.valueOf(this.getItemLabelBackColor()));
        }
        if (this.getItemLabelGap() != 0.05) {
            f.b(stringBuilder, n2, "ItemLabelGap", String.valueOf(this.getItemLabelGap()));
        }
        if (!this.isDrawItemLabelOutline()) {
            f.b(stringBuilder, n2, "DrawItemLabelOutline", String.valueOf(this.isDrawItemLabelOutline()));
        }
        if (this.getItemLabelOutlineColor() != 0 || this.getItemLabelOutlineStyle() != 1 || this.getItemLabelOutlineWidth() != 20) {
            f.a(stringBuilder, "ItemLabelOutline", n2, this.getItemLabelOutlineColor(), this.getItemLabelOutlineStyle(), this.getItemLabelOutlineWidth());
        }
        if (this.isIgnoreZeroValues()) {
            f.b(stringBuilder, n2, "IgnoreZeroValues", String.valueOf(this.isIgnoreZeroValues()));
        }
        if (!this.getLegendLayout().equals(PieLegendLayout.SHOW_LABEL)) {
            stringBuilder.append((CharSequence)this.getLegendLayout().dr(n2));
        }
        if (this.getRotationAngle() != 90.0) {
            f.b(stringBuilder, n2, "RotationAngle", String.valueOf(this.getRotationAngle()));
        }
        if (this.getSectionIndexes().length > 0) {
            int[] nArray = this.getSectionIndexes();
            f.a(stringBuilder, n2, "SectionIndexes", null, false);
            for (int n3 : nArray) {
                f.b(stringBuilder, n2 + 1, "SectionIndex", String.valueOf(n3));
            }
            f.a(stringBuilder, n2, "SectionIndexes", null, true);
            f.b(stringBuilder, n2, "ExpandPercent", String.valueOf(this.getExpandPercent()));
        }
        return stringBuilder;
    }

    @Override
    protected void B(PrintWriter printWriter, int n2) {
        super.B(printWriter, n2);
        ++n2;
        if (this.getDataset() != null) {
            b.a(this.getDataset(), printWriter, n2);
        }
    }

    @Override
    public void readProperties(Element element, Chart2 chart2) {
        super.readProperties(element, chart2);
        NodeList nodeList = element.getChildNodes();
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            Object object;
            if (!(nodeList.item(i2) instanceof Element)) continue;
            Element element2 = (Element)nodeList.item(i2);
            if (element2.getNodeName().equals("ItemLabelBackground")) {
                object = element2.getAttribute("color");
                if (((String)object).length() == 0) {
                    object = element2.getAttribute("value");
                }
                if (((String)object).length() <= 0) continue;
                int n2 = Integer.parseInt((String)object);
                this.setItemLabelBackColor(n2);
                continue;
            }
            if (element2.getNodeName().equals("ItemLabelGap")) {
                double d2;
                object = element2.getAttribute("value");
                if (((String)object).length() <= 0 || !((d2 = Double.valueOf((String)object).doubleValue()) >= 0.0)) continue;
                this.setItemLabelGap(d2);
                continue;
            }
            if (element2.getNodeName().equals("DrawItemLabelOutline")) {
                object = element2.getAttribute("value");
                if (((String)object).length() <= 0) continue;
                this.setDrawItemLabelOutline(Boolean.valueOf((String)object));
                continue;
            }
            if (element2.getNodeName().equals("ItemLabeOutline") || element2.getNodeName().equals("ItemLabelOutline")) {
                object = element2.getAttribute("color");
                if (((String)object).length() > 0) {
                    int n3 = Integer.parseInt((String)object);
                    this.setItemLabelOutlineColor(n3);
                }
                if (((String)(object = element2.getAttribute("style"))).length() > 0) {
                    int n4 = Integer.parseInt((String)object);
                    if (n4 == 0 || n4 == 3 || n4 == 4 || n4 == 1) {
                        this.setItemLabelOutlineStyle(n4);
                    } else {
                        this.setItemLabelOutlineStyle(1);
                    }
                }
                if (((String)(object = element2.getAttribute("width"))).length() <= 0) continue;
                int n5 = Integer.parseInt((String)object);
                if (n5 < 1) {
                    this.setItemLabelOutlineWidth(20);
                    continue;
                }
                this.setItemLabelOutlineWidth(n5);
                continue;
            }
            if (element2.getNodeName().equals("IgnoreZeroValues")) {
                object = element2.getAttribute("value");
                if (((String)object).length() <= 0) continue;
                this.setIgnoreZeroValues(Boolean.valueOf((String)object));
                continue;
            }
            if (element2.getNodeName().equals("LegendLayout")) {
                this.setLegendLayout(PieLegendLayout.f(element2));
                continue;
            }
            if (element2.getNodeName().equals("RotationAngle")) {
                object = element2.getAttribute("value");
                if (((String)object).length() <= 0) continue;
                double d3 = Double.valueOf((String)object);
                this.setRotationAngle(d3);
                continue;
            }
            if (element2.getNodeName().equals("SectionIndexes")) {
                object = element2.getChildNodes();
                if (object.getLength() > 0) {
                    int[] nArray = new int[object.getLength()];
                    for (int i3 = 0; i3 < object.getLength(); ++i3) {
                        nArray[i3] = Integer.valueOf(object.item(i3).getAttributes().getNamedItem("value").getNodeValue());
                    }
                    this.setSectionIndexes(nArray);
                    continue;
                }
                String string = element2.getAttribute("value");
                IntList intList = new IntList();
                if (string.length() <= 0) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
                while (stringTokenizer.hasMoreTokens()) {
                    int n6 = Integer.valueOf(stringTokenizer.nextToken());
                    intList.addElement(n6);
                }
                this.setSectionIndexes(intList.toArray());
                continue;
            }
            if (element2.getNodeName().equals("ExpandPercent")) {
                object = element2.getAttribute("value");
                if (((String)object).length() <= 0) continue;
                double d4 = Double.valueOf((String)object);
                this.setExpandPercent(d4);
                continue;
            }
            if (!element2.getNodeName().equals("Dataset")) continue;
            this.c(element2, chart2);
        }
    }

    protected void c(Element element, Chart2 chart2) {
        this.setDataset((PieDataset)b.b(element, chart2));
    }
}

