/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.chart.plot;

import com.inet.jfree.chart.labels.AbstractXYItemLabelGenerator;
import com.inet.jfree.chart.labels.BubbleXYItemLabelGenerator;
import com.inet.jfree.chart.labels.StandardXYItemLabelGenerator;
import com.inet.jfree.chart.labels.XYItemLabelGenerator;
import com.inet.report.Chart2;
import com.inet.report.chart.a;
import com.inet.report.chart.axis.ContinuousNumberAxis;
import com.inet.report.chart.dataset.LabelProvider;
import com.inet.report.chart.dataset.XYDataset;
import com.inet.report.chart.dataset.b;
import com.inet.report.chart.f;
import com.inet.report.chart.format.ChartFormat;
import com.inet.report.chart.plot.AbstractPlot;
import com.inet.report.chart.plot.ChartStyle;
import com.inet.report.chart.plot.XYStyle;
import com.inet.report.n;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XYPlot
extends AbstractPlot {
    public static final XYStyle DEFAULT_STYLE = XYStyle.SCATTER;
    public static final double DEFAULT_SIZE_COEFFICIENT = 0.3;
    private XYStyle aKi;
    private XYDataset aKj;
    private ContinuousNumberAxis aKk;
    private ContinuousNumberAxis aKh;
    private double aKl;

    public XYPlot() {
        this(DEFAULT_STYLE);
    }

    public XYPlot(XYStyle xYStyle) {
        if (xYStyle == null) {
            throw n.T("style");
        }
        this.aKi = xYStyle;
        this.setCategoryAxis(new ContinuousNumberAxis());
        this.setDataAxis(new ContinuousNumberAxis());
        this.aKl = 0.3;
    }

    @Override
    public XYDataset getDataset() {
        return this.aKj;
    }

    public void setDataset(XYDataset xYDataset) {
        if (xYDataset == null) {
            throw n.T("dataset");
        }
        this.aKj = xYDataset;
        this.aKj.updateReferences();
    }

    public ContinuousNumberAxis getCategoryAxis() {
        return this.aKk;
    }

    public void setCategoryAxis(ContinuousNumberAxis continuousNumberAxis) {
        if (continuousNumberAxis == null) {
            throw n.T("categoryAxis");
        }
        this.aKk = continuousNumberAxis;
    }

    public ContinuousNumberAxis getDataAxis() {
        return this.aKh;
    }

    public void setDataAxis(ContinuousNumberAxis continuousNumberAxis) {
        if (continuousNumberAxis == null) {
            throw n.T("dataAxis");
        }
        this.aKh = continuousNumberAxis;
    }

    @Override
    public ChartStyle getStyle() {
        return this.aKi;
    }

    public void setStyle(XYStyle xYStyle) {
        if (xYStyle == null) {
            throw n.T("style");
        }
        this.aKi = xYStyle;
    }

    public double getSizeCoefficient() {
        return this.aKl;
    }

    public void setSizeCoefficient(double d2) {
        if (d2 < 0.0 || d2 > 1.0) {
            throw new IllegalArgumentException("Coefficient is out of range (0-1).");
        }
        this.aKl = d2;
    }

    @Override
    public void refreshAutoTitles(Chart2 chart2) {
        if (this.aKj != null) {
            LabelProvider labelProvider = this.aKj.getLabelProvider();
            if (this.getStyle() == XYStyle.SCATTER) {
                a.setAutoTitle(chart2.getHeaderTitle(), n.getMsg("ScatterChart", chart2.getLocalizationResources()));
                a.setAutoTitle(chart2.getFootnote(), labelProvider.getLabel(1));
            } else if (this.getStyle() == XYStyle.BUBBLE) {
                a.setAutoTitle(chart2.getHeaderTitle(), n.getMsg("BubbleChart", chart2.getLocalizationResources()));
                a.setAutoTitle(chart2.getFootnote(), n.getMsg("BubbleSize", chart2.getLocalizationResources()) + " " + labelProvider.getLabel(1));
            }
            a.setAutoTitle(this.getCategoryAxis().getTitle(), labelProvider.getLabel(2));
            a.setAutoTitle(this.getDataAxis().getTitle(), labelProvider.getLabel(4));
        }
    }

    XYItemLabelGenerator h(Locale locale) {
        AbstractXYItemLabelGenerator abstractXYItemLabelGenerator = null;
        NumberFormat numberFormat = NumberFormat.getInstance(locale);
        ChartFormat chartFormat = this.getItemLabelFormat();
        if (chartFormat instanceof NumberFormat) {
            chartFormat.setLocale(locale);
            numberFormat = (NumberFormat)((Object)chartFormat);
        }
        if (this.getStyle().equals(XYStyle.SCATTER)) {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.isShowLabel()) {
                stringBuffer.append("{0}");
                if (this.isShowValue()) {
                    stringBuffer.append("  ");
                }
            }
            if (this.isShowValue()) {
                stringBuffer.append("({1}, {2})");
            }
            if (stringBuffer.length() > 0) {
                abstractXYItemLabelGenerator = new StandardXYItemLabelGenerator(stringBuffer.toString(), numberFormat, numberFormat);
            }
        } else if (this.getStyle().equals(XYStyle.BUBBLE)) {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.isShowLabel()) {
                stringBuffer.append("{0}");
                if (this.isShowValue()) {
                    stringBuffer.append("  ");
                }
            }
            if (this.isShowValue()) {
                stringBuffer.append("({1}, {2}, {3})");
            }
            if (stringBuffer.length() > 0) {
                abstractXYItemLabelGenerator = new BubbleXYItemLabelGenerator(stringBuffer.toString(), numberFormat, numberFormat, numberFormat);
            }
        }
        return abstractXYItemLabelGenerator;
    }

    @Override
    protected StringBuilder dm(int n2) {
        StringBuilder stringBuilder = super.dm(n2);
        f.b(stringBuilder, n2, "SizeCoefficient", String.valueOf(this.getSizeCoefficient()));
        return stringBuilder;
    }

    @Override
    protected void B(PrintWriter printWriter, int n2) {
        super.B(printWriter, n2);
        ++n2;
        if (this.aKj != null) {
            b.a(this.aKj, printWriter, n2);
        }
        this.aKk.saveProperties(printWriter, n2, "CategoryAxis");
        this.aKh.saveProperties(printWriter, n2, "DataAxis");
    }

    @Override
    public void readProperties(Element element, Chart2 chart2) {
        super.readProperties(element, chart2);
        NodeList nodeList = element.getChildNodes();
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            if (!(nodeList.item(i2) instanceof Element)) continue;
            Element element2 = (Element)nodeList.item(i2);
            if (element2.getNodeName().equals("CategoryAxis")) {
                this.aKk.readProperties(element2, chart2);
                continue;
            }
            if (element2.getNodeName().equals("DataAxis")) {
                this.aKh.readProperties(element2, chart2);
                continue;
            }
            if (element2.getNodeName().equals("SizeCoefficient")) {
                double d2;
                String string = element2.getAttribute("value");
                if (string.length() <= 0 || !((d2 = Double.valueOf(string).doubleValue()) >= 0.0) || !(d2 <= 1.0)) continue;
                this.setSizeCoefficient(d2);
                continue;
            }
            if (!element2.getNodeName().equals("Dataset")) continue;
            this.setDataset((XYDataset)b.b(element2, chart2));
        }
    }

    @Override
    public List getReferencedObject() {
        List list = super.getReferencedObject();
        list.addAll(this.aKk.getReferencedObjects());
        list.addAll(this.aKh.getReferencedObjects());
        return list;
    }
}

