/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.config;

import com.inet.report.BaseUtils;
import com.inet.report.config.Configuration;
import com.inet.report.config.ConfigurationManager;
import com.inet.report.config.c;
import com.inet.report.config.d;
import com.inet.report.config.structure.MsgAdmin;
import com.inet.report.config.structure.StructureAdmin;
import com.inet.report.config.structure.a;
import com.inet.report.config.structure.b;
import com.inet.report.config.structure.init.PropertyInitializer;
import com.inet.report.config.structure.model.ConfigCategory;
import com.inet.report.config.structure.model.ConfigGroup;
import com.inet.report.config.structure.model.ConfigKey;
import com.inet.report.config.structure.model.ConfigLink;
import com.inet.report.config.structure.model.properties.ConfigProperty;
import com.inet.report.config.structure.model.properties.HasPlusSettings;
import com.inet.report.config.structure.model.properties.InvalidTypeException;
import com.inet.report.config.structure.model.properties.OtherOptionsProperty;
import com.inet.report.config.structure.model.properties.SelectConfigProperty;
import com.inet.report.config.structure.model.properties.SelectOption;
import com.inet.report.config.structure.model.validator.async.ConfigValidator;
import com.inet.report.config.structure.model.validator.async.KeyValidator;
import com.inet.report.config.structure.util.ConfigUtils;
import com.inet.report.i18n.Msg;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.prefs.BackingStoreException;

public class ConfigurationEditHandler {
    private static Collection<PropertyInitializer<?>> aKu = new HashSet();

    public static List<ConfigGroup> getConfigGroups(int n2, String string, Locale locale, int n3) {
        List<ConfigGroup> list = StructureAdmin.getInstance().getGroups();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        ArrayList<ConfigGroup> arrayList = new ArrayList<ConfigGroup>(list.size());
        for (ConfigGroup configGroup : list) {
            ConfigGroup configGroup2 = configGroup.copy();
            configGroup2.setLabel(MsgAdmin.getInstance().getMsg(configGroup.getKey(), locale, new Object[0]));
            arrayList.add(configGroup2);
            List<ConfigCategory> list2 = configGroup2.getCategories();
            Iterator<ConfigCategory> iterator = list2.iterator();
            while (iterator.hasNext()) {
                ConfigCategory configCategory = iterator.next();
                if ((configCategory.getVisibility() & n3) > 0) {
                    configCategory.setLabel(MsgAdmin.getInstance().getMsg(configCategory.getKey(), locale, new Object[0]));
                    configCategory.setDescription(MsgAdmin.getInstance().getMsg(configCategory.getKey() + ".description", locale, new Object[0]));
                    continue;
                }
                iterator.remove();
            }
        }
        Object object = arrayList.iterator();
        while (object.hasNext()) {
            ConfigGroup configGroup;
            configGroup = object.next();
            if (!configGroup.getCategories().isEmpty()) continue;
            object.remove();
        }
        object = ConfigurationManager.getInstance().get(n2, string);
        if (object != null) {
            a.zd().b(string, n2, object.get(ConfigKey.LICENSEKEY.getKey()));
        }
        return arrayList;
    }

    public static ConfigCategory getCategory(int n2, String string, String string2, Locale locale, int n3) {
        Configuration configuration = ConfigurationManager.getInstance().get(n2, string);
        if (configuration == null) {
            BaseUtils.warning("Config " + string + " in scope " + n2 + " not found.");
            return null;
        }
        StructureAdmin structureAdmin = StructureAdmin.createNewInstance();
        ConfigCategory configCategory = structureAdmin.getConfigCategory(string2);
        if (configCategory == null) {
            BaseUtils.warning("Category " + string2 + " not found.");
            return null;
        }
        configCategory.setLabel(MsgAdmin.getInstance().getMsg(string2, locale, new Object[0]));
        configCategory.setDescription(MsgAdmin.getInstance().getMsg(string2 + ".description", locale, new Object[0]));
        if (string2.equals("category.other")) {
            return ConfigurationEditHandler.a(configuration, configCategory);
        }
        boolean bl2 = false;
        boolean bl3 = !ConfigurationManager.isWriteable(configuration.getScope());
        List<ConfigGroup> list = structureAdmin.getGroups();
        for (ConfigGroup object3 : list) {
            List<ConfigCategory> list2 = object3.getCategories();
            for (Object object : list2) {
                boolean bl4 = ConfigurationEditHandler.a(configuration, ((ConfigCategory)object).getProperties(), n3, locale);
                if (((ConfigCategory)object).equals(configCategory)) {
                    bl2 = bl4;
                }
                ((ConfigCategory)object).setReadonly(bl3);
            }
        }
        if (bl2) {
            b b2 = a.zd().c(string, n2, configuration.get(ConfigKey.LICENSEKEY.getKey()));
            for (ConfigGroup configGroup : list) {
                Object object;
                List<ConfigCategory> list3 = configGroup.getCategories();
                object = list3.iterator();
                while (object.hasNext()) {
                    ConfigCategory configCategory2 = (ConfigCategory)object.next();
                    configCategory2.setHavePlusLicense(b2.isPlus());
                    if (configCategory2.getPlusLicenseTextKey() == null) continue;
                    configCategory2.setPlusLicenseText(MsgAdmin.getInstance().getMsg(configCategory2.getPlusLicenseTextKey(), Msg.getThreadLocale(), new Object[0]));
                }
            }
        }
        return configCategory;
    }

    private static boolean a(Configuration configuration, Iterable<ConfigProperty<?>> iterable, int n2, Locale locale) {
        boolean bl2 = false;
        Iterator<ConfigProperty<?>> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            ConfigProperty<?> configProperty = iterator.next();
            if ((configProperty.getVisibility() & n2) == 0) {
                iterator.remove();
                continue;
            }
            bl2 |= ConfigurationEditHandler.a(configuration, configProperty, n2, locale);
        }
        return bl2;
    }

    private static boolean a(Configuration configuration, ConfigProperty configProperty, int n2, Locale locale) {
        ConfigLink configLink;
        Object object;
        Object object3;
        boolean bl2 = false;
        if (configProperty.isNeedPlusLicense()) {
            bl2 = true;
        }
        if (configProperty instanceof HasPlusSettings) {
            bl2 = true;
        }
        if (configProperty instanceof SelectConfigProperty) {
            object3 = (SelectConfigProperty)configProperty;
            for (SelectOption object22 : ((SelectConfigProperty)object3).getOptions()) {
                object22.setLabel(MsgAdmin.getInstance().getMsg(configProperty.getKey() + "." + object22.getLabelKey(), locale, new Object[0]));
                if (!object22.isNeedPlusLicense()) continue;
                bl2 = true;
            }
        }
        if ((object3 = configProperty.getKey()) != null) {
            object = configuration.get((String)object3);
            if (configProperty instanceof SelectConfigProperty) {
                SelectConfigProperty invalidTypeException = (SelectConfigProperty)configProperty;
                try {
                    invalidTypeException.setStringValue((String)object);
                }
                catch (InvalidTypeException invalidTypeException2) {
                    // empty catch block
                }
                invalidTypeException.setOriginalValue(invalidTypeException.getValue());
            }
            try {
                configProperty.setStringValue((String)object);
            }
            catch (InvalidTypeException invalidTypeException) {
                // empty catch block
            }
        }
        if (configProperty.getValue() == null) {
            configProperty.setValue(configProperty.getDefaultValue());
        }
        if (object3 == null) {
            object3 = configProperty.getLabel();
        }
        configProperty.setLabel(MsgAdmin.getInstance().getMsg((String)object3, locale, new Object[0]));
        object = (String)object3 + ".tooltip";
        String string = MsgAdmin.getInstance().getMsg((String)object, locale, new Object[0]);
        if (!("$" + (String)object + "$").equals(string)) {
            configProperty.setTooltip(string);
        }
        if ((configLink = configProperty.getLinkTo()) != null) {
            configLink.setLabel(MsgAdmin.getInstance().getMsg(configLink.getLabelKey(), Msg.getThreadLocale(), new Object[0]));
            if (configLink.getDescriptionKey() != null && !configLink.getDescriptionKey().isEmpty()) {
                configLink.setDescription(MsgAdmin.getInstance().getMsg(configLink.getDescriptionKey(), Msg.getThreadLocale(), new Object[0]));
            }
            bl2 |= ConfigurationEditHandler.a(configuration, configLink.getProperties(), n2, locale);
        }
        ConfigurationEditHandler.performCustomInitialization(configProperty, configuration);
        return bl2 |= ConfigurationEditHandler.a(configuration, configProperty.getChildProperties(), n2, locale);
    }

    public static <T extends Serializable> List<String> validateAsync(ConfigProperty<T> configProperty) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ConfigValidator<T> configValidator : configProperty.getAsyncValidators()) {
            String string = configValidator.check(configProperty);
            if (string == null) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public static List<String> save(int n2, String string, List<ConfigProperty<?>> list, int n3) {
        Configuration configuration;
        if (string == null) {
            configuration = ConfigurationManager.getInstance().getCurrent();
            string = configuration.getName();
            n2 = configuration.getScope();
        }
        if ((configuration = ConfigurationManager.getInstance().get(n2, string)) == null) {
            BaseUtils.warning("Config " + string + " in scope " + n2 + " not found.");
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        List<ConfigGroup> list2 = ConfigurationEditHandler.getConfigGroups(n2, string, Msg.getThreadLocale(), n3);
        HashMap<String, ConfigCategory> hashMap = new HashMap<String, ConfigCategory>();
        ArrayList arrayList2 = new ArrayList(list);
        StructureAdmin structureAdmin = StructureAdmin.createNewInstance();
        boolean bl2 = false;
        for (ConfigGroup object : list2) {
            for (ConfigCategory configCategory : object.getCategories()) {
                ConfigCategory configCategory2 = structureAdmin.getConfigCategory(configCategory.getKey());
                if (configCategory2 == null) continue;
                configCategory2.setLabel(MsgAdmin.getInstance().getMsg(configCategory2.getKey(), Msg.getThreadLocale(), new Object[0]));
                bl2 |= ConfigurationEditHandler.a(configuration, configCategory2.getProperties(), n3, Msg.getThreadLocale());
                hashMap.put(configCategory2.getKey(), configCategory2);
                ConfigUtils.runThroughProperties(configCategory2.getProperties(), new c(arrayList2, arrayList));
            }
        }
        if (arrayList.isEmpty()) {
            ConfigCategory configCategory = (ConfigCategory)hashMap.get("category.other");
            if (configCategory != null) {
                for (ConfigProperty<?> configProperty : arrayList2) {
                    configCategory.addProperty(configProperty);
                }
            }
            if (bl2) {
                b b2 = a.zd().c(string, n2, configuration.get(ConfigKey.LICENSEKEY.getKey()));
                for (ConfigCategory configCategory3 : hashMap.values()) {
                    configCategory3.setHavePlusLicense(b2.isPlus());
                    if (configCategory3.getPlusLicenseTextKey() == null) continue;
                    configCategory3.setPlusLicenseText(MsgAdmin.getInstance().getMsg(configCategory3.getPlusLicenseTextKey(), Msg.getThreadLocale(), new Object[0]));
                }
            }
            for (ConfigCategory configCategory4 : hashMap.values()) {
                ConfigUtils.runThroughProperties(configCategory4.getProperties(), new d(arrayList));
            }
        }
        if (arrayList.isEmpty()) {
            for (ConfigProperty<?> configProperty : list) {
                String string2 = configProperty.getValueAsString();
                configuration.put(configProperty.getKey(), string2);
                if (configProperty instanceof SelectConfigProperty) {
                    SelectConfigProperty selectConfigProperty = (SelectConfigProperty)configProperty;
                    selectConfigProperty.setOriginalValue(selectConfigProperty.getValue());
                }
                if (!configProperty.getKey().equals(ConfigKey.LICENSEKEY.getKey())) continue;
                a.zd().x(string, n2);
                a.zd().b(string, n2, configuration.get(ConfigKey.LICENSEKEY.getKey()));
            }
            try {
                configuration.flush();
            }
            catch (BackingStoreException backingStoreException) {
                BaseUtils.error(backingStoreException);
            }
        }
        return arrayList;
    }

    private static ConfigCategory a(Configuration configuration, ConfigCategory configCategory) {
        for (Object object : configuration.getProperties().keySet()) {
            String string = object.toString();
            if (ConfigKey.valueOf(string) != null) continue;
            OtherOptionsProperty otherOptionsProperty = new OtherOptionsProperty(new ConfigKey(string));
            otherOptionsProperty.setValue(configuration.get(string));
            otherOptionsProperty.setLabel(string);
            otherOptionsProperty.getServerValidators().add(new KeyValidator());
            configCategory.addProperty(otherOptionsProperty);
        }
        configCategory.setReadonly(!ConfigurationManager.isWriteable(configuration.getScope()));
        return configCategory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void performCustomInitialization(ConfigProperty<?> configProperty, Configuration configuration) {
        Collection<PropertyInitializer<?>> collection = aKu;
        synchronized (collection) {
            for (PropertyInitializer<?> propertyInitializer : aKu) {
                if (!propertyInitializer.getType().isAssignableFrom(configProperty.getClass())) continue;
                propertyInitializer.initializeProperty(configProperty, configuration);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addPropertyInitializer(PropertyInitializer<?> propertyInitializer) {
        Collection<PropertyInitializer<?>> collection = aKu;
        synchronized (collection) {
            aKu.add(propertyInitializer);
        }
    }

    private static boolean a(ConfigProperty<?> configProperty) {
        if (configProperty.getParentProperty() != null && !ConfigurationEditHandler.a(configProperty.getParentProperty())) {
            return false;
        }
        if (configProperty.getCondition() != null && !configProperty.getCondition().check()) {
            return false;
        }
        return !configProperty.isNeedPlusLicense() || configProperty.getParentCategory().isHavePlusLicense();
    }

    static /* synthetic */ boolean b(ConfigProperty configProperty) {
        return ConfigurationEditHandler.a(configProperty);
    }
}

