/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.config;

import com.inet.lib.util.PreferencesUtils;
import com.inet.report.BaseUtils;
import com.inet.report.config.Configuration;
import com.inet.report.config.ConfigurationChangeListener;
import com.inet.report.config.LicenseKeyInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class ConfigurationManager {
    private static ConfigurationManager aKA;
    static final String aKB;
    public static final String NAME_DEFAULT = "Default";
    public static final String NAME_TEMP_DEFAULT = "<temporary default>";

    public static ConfigurationManager getInstance() {
        if (aKA == null) {
            try {
                aKA = (ConfigurationManager)BaseUtils.classForName("com.inet.report.config.ConfigurationManagerImpl").newInstance();
            }
            catch (Exception exception) {
                throw (NoClassDefFoundError)new NoClassDefFoundError("com.inet.report.config.ConfigurationManagerImpl").initCause(exception);
            }
        }
        return aKA;
    }

    public abstract void copy(int var1, String var2, int var3, String var4) throws SecurityException;

    public abstract Configuration create(int var1, String var2) throws SecurityException;

    public abstract void delete(Configuration var1) throws SecurityException;

    public abstract void delete(int var1, String var2) throws SecurityException;

    public abstract void exportToStream(int var1, String var2, OutputStream var3) throws SecurityException, IOException;

    @Nullable
    public abstract Configuration get(int var1, String var2) throws SecurityException;

    public abstract Configuration[] getAll(int var1);

    public abstract InetAddress[] getAvailableIPAddresses();

    public abstract void setCurrent(Configuration var1);

    @Nonnull
    public abstract Configuration getCurrent();

    public abstract void importFromStream(int var1, String var2, InputStream var3) throws SecurityException, IOException;

    public abstract LicenseKeyInfo getLicenseKeyInfo(String var1);

    public abstract void put(int var1, String var2, Configuration var3) throws SecurityException;

    public abstract void rename(int var1, String var2, int var3, String var4) throws SecurityException;

    public abstract Configuration setTemporaryProperties(Properties var1);

    public static boolean isReadable(int n2) {
        try {
            switch (n2) {
                case 1: {
                    return PreferencesUtils.isSystemReadable(aKB);
                }
                case 2: {
                    return PreferencesUtils.isUserReadable(aKB);
                }
                case 4: {
                    return true;
                }
            }
            throw new IllegalArgumentException(String.valueOf(n2));
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    public static boolean isWriteable(int n2) {
        try {
            switch (n2) {
                case 1: {
                    return PreferencesUtils.isSystemWriteable(aKB);
                }
                case 2: {
                    return PreferencesUtils.isUserWriteable(aKB);
                }
                case 4: {
                    return true;
                }
            }
            throw new IllegalArgumentException(String.valueOf(n2));
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    public static String getScopeName(int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n2 == 1) {
            stringBuffer.append("System");
        }
        if (n2 == 2) {
            stringBuffer.append("User");
        }
        if (n2 == 4) {
            stringBuffer.append("Temp");
        }
        return stringBuffer.toString();
    }

    public abstract void addConfigurationChangeListener(ConfigurationChangeListener var1);

    public abstract void removeConfigurationChangeListener(ConfigurationChangeListener var1);

    static {
        String string = PreferencesUtils.getRelativePrefPath(ConfigurationManager.class);
        aKB = string.equals("/") ? "/com/inet/report/config/cc" : string + "/cc";
    }
}

