/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.config;

import com.inet.lib.core.OS;
import com.inet.lib.util.DotNetUtils;
import com.inet.lib.util.PreferencesUtils;
import com.inet.report.BaseUtils;
import com.inet.report.ay;
import com.inet.report.config.Configuration;
import com.inet.report.config.ConfigurationChangeEvent;
import com.inet.report.config.ConfigurationChangeListener;
import com.inet.report.config.ConfigurationManager;
import com.inet.report.config.ConfigurationModificationEvent;
import com.inet.report.config.LicenseKeyInfo;
import com.inet.report.config.e;
import com.inet.report.config.g;
import com.inet.report.config.h;
import com.inet.report.config.i;
import com.inet.report.config.j;
import com.inet.report.config.k;
import com.inet.report.config.structure.model.ConfigKey;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ConfigurationManagerImpl
extends ConfigurationManager {
    static final String aKB;
    private static long aKC;
    private static final Object aKD;
    private HashMap<String, Configuration> aKE = new HashMap();
    private int aKF = -1;
    private String aKG;
    private Configuration aKH;
    private long timestamp;
    private long aKI;
    private final List<ConfigurationChangeListener> listeners = new CopyOnWriteArrayList<ConfigurationChangeListener>();
    private boolean aKJ;
    private final i aKK = new j();

    private static boolean du(int n2) {
        return (n2 & 2) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copy(int n2, String string, int n3, String string2) throws SecurityException {
        Configuration configuration = this.get(n2, string);
        if (configuration == null) {
            throw new IllegalArgumentException("trying to copy non-existent configuration");
        }
        Configuration configuration2 = this.get(n3, string2);
        if (configuration2 != null) {
            throw new IllegalArgumentException("trying to copy to already existing configuration");
        }
        Configuration configuration3 = null;
        this.aKJ = true;
        try {
            configuration3 = this.create(n3, string2);
            configuration3.putAll(configuration.getProperties());
        }
        finally {
            this.aKJ = false;
        }
        this.a(configuration3, 5);
    }

    @Override
    public Configuration create(int n2, String string) throws SecurityException {
        if (!this.cg(string)) {
            throw new IllegalArgumentException("illegal name: " + string);
        }
        Configuration configuration = this.get(n2, string);
        if (configuration != null) {
            throw new IllegalArgumentException("configuration already exists for scope " + n2 + " and name " + string);
        }
        Configuration configuration2 = this.D(n2, string);
        if (n2 == 4) {
            this.aKE.put(string, configuration2);
        } else {
            this.put(n2, string, configuration2);
        }
        this.a(configuration2, 1);
        return configuration2;
    }

    private boolean cg(String string) {
        return string != null && string.length() > 0 && string.indexOf(47) == -1;
    }

    @Override
    public void delete(Configuration configuration) throws SecurityException {
        this.delete(configuration.getScope(), configuration.getName());
    }

    @Override
    public void delete(int n2, String string) throws SecurityException {
        this.put(n2, string, null);
    }

    @Override
    public void exportToStream(int n2, String string, OutputStream outputStream) throws SecurityException, IOException {
        Configuration configuration = this.get(n2, string);
        configuration.getProperties().store(outputStream, null);
    }

    @Override
    @Nullable
    public Configuration get(int n2, String string) throws SecurityException {
        if (this.aKH != null && this.aKF != -1 && this.aKH.getScope() == n2 && this.aKH.getName().equals(string)) {
            return this.aKH;
        }
        return this.C(n2, string);
    }

    private Configuration C(int n2, String string) throws SecurityException {
        if (n2 == 4) {
            return this.aKE.get(string);
        }
        try {
            Preferences preferences = this.aKK.dx(n2);
            try {
                if (preferences.nodeExists(string)) {
                    Configuration configuration = this.D(n2, string);
                    return configuration;
                }
                return null;
            }
            catch (BackingStoreException backingStoreException) {
                BaseUtils.printStackTrace(backingStoreException);
                return null;
            }
        }
        catch (SecurityException securityException) {
            if (this.aKK.isReadable(n2)) {
                return null;
            }
            throw securityException;
        }
    }

    @Override
    public Configuration[] getAll(int n2) {
        Preferences preferences;
        ArrayList<Configuration> arrayList = new ArrayList<Configuration>();
        if (n2 <= 0 || n2 > 7) {
            throw new IllegalArgumentException("illegal scope: " + n2);
        }
        try {
            if (ConfigurationManagerImpl.du(n2)) {
                preferences = this.aKK.dx(2);
                for (String string : preferences.childrenNames()) {
                    arrayList.add(this.get(2, string));
                }
            }
        }
        catch (BackingStoreException backingStoreException) {
            BaseUtils.printStackTrace(backingStoreException);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            if (ConfigurationManagerImpl.dw(n2)) {
                preferences = this.aKK.dx(1);
                for (String string : preferences.childrenNames()) {
                    arrayList.add(this.get(1, string));
                }
            }
        }
        catch (BackingStoreException backingStoreException) {
            BaseUtils.printStackTrace(backingStoreException);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (ConfigurationManagerImpl.dv(n2)) {
            arrayList.addAll(this.aKE.values());
        }
        return arrayList.toArray(new Configuration[0]);
    }

    @Override
    public InetAddress[] getAvailableIPAddresses() {
        try {
            InetAddress inetAddress;
            Enumeration<InetAddress> enumeration;
            NetworkInterface networkInterface;
            Enumeration<NetworkInterface> enumeration2 = NetworkInterface.getNetworkInterfaces();
            ArrayList<InetAddress> arrayList = new ArrayList<InetAddress>();
            while (enumeration2.hasMoreElements()) {
                networkInterface = enumeration2.nextElement();
                enumeration = networkInterface.getInetAddresses();
                while (enumeration.hasMoreElements()) {
                    inetAddress = enumeration.nextElement();
                    if (!(inetAddress instanceof Inet4Address) || inetAddress.isLoopbackAddress()) continue;
                    arrayList.add(inetAddress);
                }
            }
            if (arrayList.size() == 0) {
                BaseUtils.error("No IPv4 address found for this system.");
                enumeration2 = NetworkInterface.getNetworkInterfaces();
                while (enumeration2.hasMoreElements()) {
                    networkInterface = enumeration2.nextElement();
                    BaseUtils.error("\t" + networkInterface);
                    enumeration = networkInterface.getInetAddresses();
                    while (enumeration.hasMoreElements()) {
                        inetAddress = enumeration.nextElement();
                        BaseUtils.error("\t\t" + inetAddress);
                    }
                }
            }
            return arrayList.toArray(new InetAddress[arrayList.size()]);
        }
        catch (SocketException socketException) {
            BaseUtils.printStackTrace(socketException);
            return new InetAddress[0];
        }
    }

    @Override
    public void setCurrent(Configuration configuration) {
        if (configuration == null) {
            Configuration configuration2;
            BaseUtils.debug("setCurrent(null) was called");
            this.aKF = -1;
            this.aKG = null;
            this.timestamp = 0L;
            this.aKH = configuration2 = this.vG();
            BaseUtils.status("Setting current configuration to: " + ConfigurationManagerImpl.getScopeName(configuration2.getScope()) + "/" + configuration2.getName());
        } else {
            int n2 = configuration.getScope();
            String string = configuration.getName();
            this.aKF = n2;
            this.aKG = string;
            this.aKH = configuration;
            if (this.aKF != 4 || !this.aKG.equals("<temp copy>")) {
                BaseUtils.status("Setting current configuration to: " + ConfigurationManagerImpl.getScopeName(n2) + "/" + string);
            }
        }
        this.a(this.aKH, 0);
    }

    @Override
    @Nonnull
    public Configuration getCurrent() {
        block10: {
            try {
                if (this.aKH != null) {
                    long l2;
                    String string;
                    if (this.aKI + 30000L < System.currentTimeMillis()) {
                        try {
                            this.aKI = System.currentTimeMillis();
                            ((e)this.aKH).sync();
                        }
                        catch (BackingStoreException backingStoreException) {
                            BaseUtils.printStackTrace(backingStoreException);
                        }
                        catch (SecurityException securityException) {
                            BaseUtils.printStackTrace(securityException);
                        }
                    }
                    if ((string = this.aKH.get("timestamp")) != null && this.timestamp != (l2 = Long.valueOf(string).longValue())) {
                        BaseUtils.debug("timestamp has changed ... fetching new configuration");
                        this.timestamp = l2;
                        int n2 = this.aKH.getScope();
                        String string2 = this.aKH.getName();
                        Configuration configuration = this.C(n2, string2);
                        if (configuration != null) {
                            this.aKH = configuration;
                        }
                    }
                    break block10;
                }
                BaseUtils.debug("currentConfig was null");
                Configuration configuration = this.vG();
                String string = configuration.get("timestamp");
                if (string != null) {
                    this.timestamp = Long.valueOf(string);
                }
                this.setCurrent(configuration);
            }
            catch (Throwable throwable) {
                BaseUtils.error(throwable);
            }
        }
        return this.vG();
    }

    @Nonnull
    private Configuration vG() {
        Object object;
        if (this.aKF != -1) {
            return this.get(this.aKF, this.aKG);
        }
        Configuration configuration = this.vH();
        if (configuration != null) {
            this.setCurrent(configuration);
            return configuration;
        }
        boolean bl2 = false;
        if (OS.isWindows()) {
            try {
                object = System.getProperty("user.name").toUpperCase();
                if (((String)object).endsWith("$") && ((String)object).startsWith(InetAddress.getLocalHost().getHostName().toUpperCase())) {
                    bl2 = true;
                } else if (DotNetUtils.isDotNet() && ((String)object).equals("SYSTEM")) {
                    bl2 = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!bl2 && PreferencesUtils.isUserReadable(aKB) && (object = this.get(2, "Default")) != null) {
            return object;
        }
        if (PreferencesUtils.isSystemReadable(aKB) && (object = this.get(1, "Default")) != null) {
            return object;
        }
        object = this.get(4, "<temporary default>");
        if (object != null) {
            return object;
        }
        BaseUtils.setLogLevel(3);
        BaseUtils.warning("No i-net Clear Reports configuration could be found! Creating a default, temporary(!) i-net Clear Reports configuration called <temporary default>...");
        BaseUtils.warning("auto-generating temporary configuration...");
        Configuration configuration2 = this.create(4, "<temporary default>");
        configuration2.put(ConfigKey.LOG_LEVEL.getKey(), "3");
        this.aKE.put("<temporary default>", configuration2);
        return configuration2;
    }

    private void h(Configuration configuration) {
        configuration.put(ConfigKey.REMOTEINTERFACE_ENABLED.getKey(), "true");
    }

    private Configuration vH() {
        Object object;
        Object object2;
        ConfigurationManager configurationManager;
        String string;
        block22: {
            String string2;
            try {
                string2 = System.getProperty("clearreports.config");
                string = System.getProperty("clearreports.configfile");
            }
            catch (SecurityException securityException) {
                string2 = null;
                string = null;
            }
            configurationManager = ConfigurationManager.getInstance();
            if (string2 != null) {
                int n2 = 0;
                object2 = string2.toUpperCase();
                if (((String)object2).startsWith("SYSTEM")) {
                    n2 = 1;
                } else if (((String)object2).startsWith("USER")) {
                    n2 = 2;
                } else if (((String)object2).startsWith("TEMP")) {
                    n2 = 4;
                }
                if (n2 != 0) {
                    int n3 = string2.indexOf(47);
                    if (n3 != -1) {
                        object = string2.substring(n3 + 1).trim();
                        BaseUtils.status("setting configuration from system property: " + string2);
                        try {
                            if (ConfigurationManager.isReadable(n2)) {
                                Configuration configuration = configurationManager.get(n2, (String)object);
                                if (configuration != null) {
                                    return configuration;
                                }
                                BaseUtils.error("no config could be found at '" + string2 + "'!!!");
                                break block22;
                            }
                            BaseUtils.error("scope '" + ConfigurationManagerImpl.getScopeName(n2) + "' not readable!!!");
                        }
                        catch (SecurityException securityException) {
                            BaseUtils.error("encountered SecurityException while trying to access " + string2 + "!");
                            BaseUtils.printStackTrace(securityException);
                        }
                    } else {
                        BaseUtils.error("no slash found in '" + string2 + "' - ClearReports.config should have a form such as 'USER/myconfig'");
                    }
                } else {
                    BaseUtils.error("scope could not be parsed from '" + string2 + "' - ClearReports.config should start with 'SYSTEM' or 'USER', e.g. 'USER/myconfig'");
                }
            }
        }
        if (string != null) {
            URL uRL = BaseUtils.getURL(string);
            if (uRL != null) {
                try {
                    BaseUtils.status("manually importing " + string + " and using as configuration...");
                    object2 = uRL.openStream();
                    configurationManager.importFromStream(4, "<imported config>", (InputStream)object2);
                    object = (e)configurationManager.get(4, "<imported config>");
                    ((e)object).vF();
                    return object;
                }
                catch (IOException iOException) {
                    BaseUtils.printStackTrace(iOException);
                }
                catch (SecurityException securityException) {
                    BaseUtils.printStackTrace(securityException);
                }
            } else {
                BaseUtils.error("could not find properties file at location given: " + string);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void importFromStream(int n2, String string, InputStream inputStream) throws SecurityException, IOException {
        Properties properties = new Properties();
        properties.load(inputStream);
        for (String string2 : properties.stringPropertyNames()) {
            if (!string2.contains("/")) continue;
            properties.remove(string2);
        }
        this.aKJ = true;
        Object object = null;
        try {
            object = this.D(n2, string);
            object.putAll(properties);
            this.put(n2, string, (Configuration)object);
        }
        finally {
            this.aKJ = false;
        }
        this.a((Configuration)object, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LicenseKeyInfo getLicenseKeyInfo(String string) {
        Object object = aKD;
        synchronized (object) {
            if (string == null) {
                string = "";
            }
            ay ay2 = new ay();
            ay2.v(string, "");
            boolean bl2 = false;
            try {
                bl2 = ay2.aU(string.length());
            }
            catch (Exception exception) {
                bl2 = false;
            }
            boolean bl3 = ay2.aV(0);
            boolean bl4 = !ay2.kJ();
            boolean bl5 = ay2.isValidCPUCount();
            boolean bl6 = ay2.a((short)string.length());
            boolean bl7 = ay2.isPlusVersion();
            boolean bl8 = ay2.isSite();
            Properties properties = new Properties();
            properties.put(ay.WY, string);
            String string2 = ay2.getLicenseText();
            String string3 = ay2.getLicensee();
            if (!bl2) {
                try {
                    long l2;
                    int n2;
                    if (aKC != 0L && (n2 = Math.min(2000, 2000 - (int)(l2 = System.currentTimeMillis() - aKC))) > 0) {
                        aKD.wait(n2);
                    }
                    aKC = System.currentTimeMillis();
                }
                catch (InterruptedException interruptedException) {
                    BaseUtils.printStackTrace(interruptedException);
                    throw new RuntimeException(interruptedException);
                }
            }
            return new LicenseKeyInfo(bl2, bl3, bl4, bl5, bl6, bl7, bl8, string2, string3);
        }
    }

    @Override
    public void put(int n2, String string, Configuration configuration) throws SecurityException {
        Object object;
        Object object2;
        if (configuration != null) {
            configuration.put("timestamp", String.valueOf(this.timestamp));
        }
        if (n2 == 4) {
            if (configuration == null) {
                object2 = this.aKE.remove(string);
            } else {
                object = new k(string);
                ((k)object).putAll(configuration.getProperties());
                this.aKE.put(string, (Configuration)object);
                object2 = object;
            }
        } else {
            object2 = this.get(n2, string);
            try {
                object = this.aKK.dx(n2);
                if (configuration != null) {
                    Properties properties = configuration.getProperties();
                    if (((Preferences)object).nodeExists(string)) {
                        ((Preferences)object).node(string).clear();
                    }
                    Preferences preferences = ((Preferences)object).node(string);
                    this.a(preferences, properties);
                } else if (((Preferences)object).nodeExists(string)) {
                    ((Preferences)object).node(string).removeNode();
                }
            }
            catch (BackingStoreException backingStoreException) {
                BaseUtils.printStackTrace(backingStoreException);
            }
        }
        if (this.aKH != null && this.aKH.getName().equals(string) && this.aKH.getScope() == n2) {
            if (configuration != null) {
                long l2;
                this.aKH = this.vG();
                object = this.aKH.get("timestamp");
                if (object != null && this.timestamp != (l2 = Long.valueOf((String)object).longValue())) {
                    this.timestamp = l2;
                }
            } else {
                this.setCurrent(null);
            }
        }
        if (configuration == null && object2 != null) {
            this.a((Configuration)object2, 3);
        }
    }

    @Override
    public void rename(int n2, String string, int n3, String string2) throws SecurityException {
        this.copy(n2, string, n3, string2);
        this.delete(n2, string);
    }

    @Override
    public Configuration setTemporaryProperties(Properties properties) {
        Configuration configuration = this.D(4, "<temp copy>");
        this.aKE.put("<temp copy>", configuration);
        configuration.putAll(properties, true);
        this.setCurrent(configuration);
        return configuration;
    }

    private Configuration D(int n2, String string) {
        e e2;
        if (n2 == 4) {
            if (string.equals("<temporary default>")) {
                e2 = new k(string, true);
                this.h(e2);
            } else {
                e2 = new k(string);
            }
        } else {
            Preferences preferences = this.aKK.dx(n2).node(string);
            g g2 = this.a(preferences);
            e2 = new e(g2, n2, string);
        }
        return e2;
    }

    protected g a(Preferences preferences) {
        return new h(preferences);
    }

    void a(Preferences preferences, Properties properties) throws BackingStoreException {
        preferences.clear();
        g g2 = this.a(preferences);
        for (String string : properties.keySet()) {
            g2.put(string, properties.getProperty(string));
        }
        preferences.flush();
    }

    private static boolean dv(int n2) {
        return (n2 & 4) != 0;
    }

    private static boolean dw(int n2) {
        return (n2 & 1) != 0;
    }

    @Override
    public void addConfigurationChangeListener(ConfigurationChangeListener configurationChangeListener) {
        if (configurationChangeListener == null) {
            throw new IllegalArgumentException("null is not allowed as a listener");
        }
        if (this.listeners.contains(configurationChangeListener)) {
            throw new IllegalArgumentException("listener has already been added");
        }
        this.listeners.add(configurationChangeListener);
    }

    @Override
    public void removeConfigurationChangeListener(ConfigurationChangeListener configurationChangeListener) {
        if (configurationChangeListener == null) {
            throw new IllegalArgumentException("null can not be removed");
        }
        this.listeners.remove(configurationChangeListener);
    }

    void a(Configuration configuration, int n2) {
        String string = configuration.getName();
        int n3 = configuration.getScope();
        if (this.aKJ) {
            return;
        }
        boolean bl2 = this.a(configuration, n3, string);
        ConfigurationChangeEvent configurationChangeEvent = new ConfigurationChangeEvent(string, n3, bl2, n2);
        this.b(configurationChangeEvent);
    }

    private void b(ConfigurationChangeEvent configurationChangeEvent) {
        RuntimeException runtimeException = null;
        for (ConfigurationChangeListener configurationChangeListener : this.listeners.toArray(new ConfigurationChangeListener[0])) {
            try {
                configurationChangeListener.configurationChanged(configurationChangeEvent);
            }
            catch (RuntimeException runtimeException2) {
                if (runtimeException == null) {
                    runtimeException = runtimeException2;
                }
                BaseUtils.printStackTrace(runtimeException2);
            }
        }
        if (runtimeException != null) {
            throw runtimeException;
        }
    }

    void a(Configuration configuration, List<String> list) {
        String string = configuration.getName();
        int n2 = configuration.getScope();
        boolean bl2 = this.a(configuration, n2, string);
        ConfigurationModificationEvent configurationModificationEvent = new ConfigurationModificationEvent(string, n2, bl2, list);
        this.b(configurationModificationEvent);
    }

    private boolean a(Configuration configuration, int n2, String string) {
        boolean bl2;
        boolean bl3 = bl2 = this.aKH != null && this.aKH.getScope() == n2 && this.aKH.getName().equals(string);
        if (configuration.getScope() == 4) {
            bl2 &= configuration == this.aKH;
        }
        return bl2;
    }

    static {
        String string = PreferencesUtils.getRelativePrefPath(ConfigurationManager.class);
        aKB = string.equals("/") ? "/com/inet/report/config/cc" : string + "/cc";
        aKD = new Object();
    }
}

