/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.config.datasource;

import com.inet.lib.util.DotNetUtils;
import com.inet.report.BaseUtils;
import com.inet.report.DatabaseConfiguration;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.config.datasource.DataSourceConfigurationManager;
import com.inet.report.config.datasource.widget.a;
import com.inet.report.config.datasource.widget.b;
import com.inet.report.config.datasource.widget.c;
import com.inet.report.i18n.ErrorCode;
import com.inet.report.util.UpdateableClassLoader;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;

public class DataSourceConfiguration
implements Serializable,
Comparable {
    private final String aKP;
    private String aKQ = "";
    private String aKR = "";
    private String classpath = "";
    private String url = "";
    private String aKS = "";
    private boolean NL = true;
    private DatabaseConfiguration aKT = DatabaseConfiguration.getDefault();
    public static final String PROPERTY_CATALOG = "catalog";
    public static final String PROPERTY_USER = "user";
    public static final String PROPERTY_PASSWORD = "password";
    public static final String PROPERTY_SAVE_PASSWORD = "savePassword";
    public static final String PROPERTY_URL = "url";
    public static final String PROPERTY_SUPPORTS_SQL92 = "supportsSQL92";
    public static final String PROPERTY_SUPPORTS_ORDERBY = "supportsOrderBy";
    public static final String PROPERTY_SUPPORTS_WHERE = "supportsWhere";
    public static final String PROPERTY_DRIVER_LIBRARY = "driverLibrary";
    public static final String PROPERTY_DRIVER_CLASSNAME = "driverClassName";
    public static final String PROPERTY_DATABASE_CLASSNAME = "databaseClassName";
    public static final String PROPERTY_QUOTES_LOWER_CASE = "quotesLowerCase";
    public static final String PROPERTY_USE_PARENTHESES_FOR_JOIN = "supportsParenthesesForJoin";
    public static final String PROPERTY_IDENTIFIER_QUOTE_STRING = "identifierQuoteString";
    public static final String PROPERTY_ALIASTOKEN = "aliasToken";
    public static final String PROPERTY_ESCAPE_EVERYTHING = "escapeEverything";
    public static final String PROPERTY_VALIDATION_QUERY = "validationQuery";
    public static final String PROPERTY_INITSQL = "initSQL";
    private Properties aKU = new Properties();

    public DataSourceConfiguration(String string) {
        this.aKU.put(PROPERTY_USER, "");
        this.aKU.put(PROPERTY_PASSWORD, "");
        this.aKP = string == null ? "" : string;
    }

    public DataSourceConfiguration(String string, String string2) {
        this(string);
        this.aKQ = string2 == null ? "" : string2;
    }

    public DatabaseConfiguration getDatabaseConfiguration() {
        return (DatabaseConfiguration)this.aKT.clone();
    }

    public int hashCode() {
        return this.aKP.hashCode();
    }

    public void putStylesheetDefaultValues(b b2) {
        this.addProperty(PROPERTY_URL, b2.getUrl());
        this.addProperty(PROPERTY_DRIVER_CLASSNAME, b2.getDriverClassName());
        for (int i2 = 0; i2 < b2.ws(); ++i2) {
            a a2 = b2.dF(i2);
            this.addProperty(a2.getName(), a2.getDefaultValue());
        }
    }

    public void addProperty(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("The DataSource configuration property must not be null.");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("The DataSource configuration property must not be empty.");
        }
        DataSourceConfigurationManager.a(this, string, this.getProperty(string), string2);
        if (string.equals(PROPERTY_SUPPORTS_SQL92)) {
            this.setUseSQL92syntax("true".equals(string2));
        } else if (string.equals(PROPERTY_SUPPORTS_ORDERBY)) {
            this.setUseOrderBy("true".equals(string2));
        } else if (string.equals(PROPERTY_SUPPORTS_WHERE)) {
            this.setUseWhereClause("true".equals(string2));
        } else if (string.equals(PROPERTY_SUPPORTS_SQL92)) {
            this.setUseSQL92syntax("true".equals(string2));
        } else if (string.equals(PROPERTY_QUOTES_LOWER_CASE)) {
            this.setUseQuoteLowerCase("true".equals(string2));
        } else if (string.equals(PROPERTY_USE_PARENTHESES_FOR_JOIN)) {
            this.setUseParenthesiseForJoin("true".equals(string2));
        } else if (string.equals(PROPERTY_DRIVER_LIBRARY)) {
            this.setDriverLibrary(string2);
        } else if (string.equals(PROPERTY_DRIVER_CLASSNAME)) {
            this.aKQ = string2;
        } else if (string.equals(PROPERTY_DATABASE_CLASSNAME)) {
            this.aKR = string2;
        } else if (string.equals(PROPERTY_IDENTIFIER_QUOTE_STRING)) {
            this.setIdentifierQuoteString(string2);
        } else if (string.equals(PROPERTY_ALIASTOKEN)) {
            this.setAliasToken(string2);
        } else if (string.equals(PROPERTY_URL)) {
            this.url = string2;
        } else if (string.equals(PROPERTY_CATALOG)) {
            this.aKS = string2;
        } else if (string.equals(PROPERTY_ESCAPE_EVERYTHING)) {
            this.setUseEscapeEverything("true".equals(string2));
        } else if (string.equals(PROPERTY_SAVE_PASSWORD)) {
            this.setSavePassword("true".equals(string2));
        } else {
            this.aKU.put(string, string2);
        }
    }

    public void addProperties(Properties properties) {
        if (properties == null) {
            return;
        }
        Object[] objectArray = properties.keySet().toArray();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            String string = (String)objectArray[i2];
            if (string.length() <= 0) continue;
            this.addProperty(string, (String)properties.get(objectArray[i2]));
        }
    }

    public boolean isUseOrderBy() {
        return this.aKT.isUseOrderBy();
    }

    public void setUseOrderBy(boolean bl2) {
        DataSourceConfigurationManager.a(this, PROPERTY_SUPPORTS_ORDERBY, Boolean.toString(this.isUseOrderBy()), Boolean.toString(bl2));
        this.aKT.setUseOrderBy(bl2, true);
    }

    public boolean isUseParenthesiseForJoin() {
        return this.aKT.isUseParenthesiseForJoin();
    }

    public void setUseParenthesiseForJoin(boolean bl2) {
        DataSourceConfigurationManager.a(this, PROPERTY_USE_PARENTHESES_FOR_JOIN, Boolean.toString(this.isUseParenthesiseForJoin()), Boolean.toString(bl2));
        this.aKT.setUseParenthesiseForJoin(bl2, true);
    }

    public boolean isUseQuoteLowerCase() {
        return this.aKT.isUseQuoteLowerCase();
    }

    public void setUseQuoteLowerCase(boolean bl2) {
        DataSourceConfigurationManager.a(this, PROPERTY_QUOTES_LOWER_CASE, Boolean.toString(this.isUseQuoteLowerCase()), Boolean.toString(bl2));
        this.aKT.setUseQuoteLowerCase(bl2, true);
    }

    public boolean isUseSQL92syntax() {
        return this.aKT.isUseSQL92syntax();
    }

    public void setUseSQL92syntax(boolean bl2) {
        DataSourceConfigurationManager.a(this, PROPERTY_SUPPORTS_SQL92, Boolean.toString(this.isUseSQL92syntax()), Boolean.toString(bl2));
        this.aKT.setUseSQL92syntax(bl2, false, true);
    }

    public boolean isUseWhereClause() {
        return this.aKT.isUseWhereClause();
    }

    public void setUseWhereClause(boolean bl2) {
        DataSourceConfigurationManager.a(this, PROPERTY_SUPPORTS_WHERE, Boolean.toString(this.isUseWhereClause()), Boolean.toString(bl2));
        this.aKT.setUseWhereClause(bl2, true);
    }

    public String getAliasToken() {
        return this.aKT.getAliasToken();
    }

    public void setAliasToken(String string) {
        DataSourceConfigurationManager.a(this, PROPERTY_ALIASTOKEN, this.getAliasToken(), string);
        this.aKT.setAliasToken(string, true);
    }

    public boolean isUseEscapeEverything() {
        return this.aKT.isUseEscapeEverything();
    }

    public void setUseEscapeEverything(boolean bl2) {
        DataSourceConfigurationManager.a(this, PROPERTY_ESCAPE_EVERYTHING, Boolean.toString(this.isUseEscapeEverything()), Boolean.toString(bl2));
        this.aKT.setUseEscapeEverything(bl2, true);
    }

    public String getIdentifierQuoteString() {
        return this.aKT.getIdentifierQuoteString();
    }

    public void setIdentifierQuoteString(String string) {
        DataSourceConfigurationManager.a(this, PROPERTY_IDENTIFIER_QUOTE_STRING, this.getIdentifierQuoteString(), string);
        this.aKT.setIdentifierQuoteString(string, true);
    }

    public String getDriverClassname() {
        return this.aKQ;
    }

    public String getDatabaseClassname() {
        return this.aKR;
    }

    public void setDriverClassname(String string) {
        DataSourceConfigurationManager.a(this, PROPERTY_DRIVER_CLASSNAME, this.getDriverClassname(), string);
        this.aKQ = string;
    }

    public void setDatabaseClassname(String string) {
        DataSourceConfigurationManager.a(this, PROPERTY_DATABASE_CLASSNAME, this.getDatabaseClassname(), string);
        this.aKR = string == null ? "" : string;
    }

    public String getConfigurationName() {
        return this.aKP;
    }

    public String toString() {
        return this.aKP;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String string) {
        DataSourceConfigurationManager.a(this, PROPERTY_URL, this.getUrl(), string);
        this.url = string;
    }

    public Properties getProperties() {
        Properties properties = (Properties)this.aKU.clone();
        properties.put(PROPERTY_DRIVER_CLASSNAME, this.aKQ);
        properties.put(PROPERTY_DATABASE_CLASSNAME, this.aKR);
        properties.put(PROPERTY_DRIVER_LIBRARY, this.classpath);
        properties.put(PROPERTY_URL, this.url);
        properties.put(PROPERTY_CATALOG, this.aKS);
        properties.put(PROPERTY_SAVE_PASSWORD, this.NL ? "true" : "false");
        properties.put(PROPERTY_SUPPORTS_SQL92, this.aKT.isUseSQL92syntax() ? "true" : "false");
        properties.put(PROPERTY_SUPPORTS_ORDERBY, this.aKT.isUseOrderBy() ? "true" : "false");
        properties.put(PROPERTY_SUPPORTS_WHERE, this.aKT.isUseWhereClause() ? "true" : "false");
        properties.put(PROPERTY_USE_PARENTHESES_FOR_JOIN, this.aKT.isUseParenthesiseForJoin() ? "true" : "false");
        properties.put(PROPERTY_QUOTES_LOWER_CASE, this.aKT.isUseQuoteLowerCase() ? "true" : "false");
        properties.put(PROPERTY_IDENTIFIER_QUOTE_STRING, this.aKT.getIdentifierQuoteString() != null ? this.aKT.getIdentifierQuoteString() : "");
        properties.put(PROPERTY_ALIASTOKEN, this.aKT.getAliasToken() != null ? this.aKT.getAliasToken() : "");
        properties.put(PROPERTY_ESCAPE_EVERYTHING, this.aKT.isUseEscapeEverything() ? "true" : "false");
        return properties;
    }

    Properties vK() {
        Properties properties = this.getProperties();
        return properties;
    }

    public String[] getDriverSpecificProperties() {
        Object[] objectArray = this.aKU.keySet().toArray();
        String[] stringArray = new String[objectArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray[i2] = objectArray[i2].toString();
        }
        return stringArray;
    }

    public String getProperty(String string) {
        String string2 = this.aKU.getProperty(string);
        if (string2 != null) {
            return string2;
        }
        switch (string) {
            case "driverClassName": {
                return this.aKQ;
            }
            case "databaseClassName": {
                return this.aKR;
            }
            case "driverLibrary": {
                return this.classpath;
            }
            case "url": {
                return this.url;
            }
            case "catalog": {
                return this.aKS;
            }
            case "savePassword": {
                return this.NL ? "true" : "false";
            }
            case "supportsSQL92": {
                return this.aKT.isUseSQL92syntax() ? "true" : "false";
            }
            case "supportsOrderBy": {
                return this.aKT.isUseOrderBy() ? "true" : "false";
            }
            case "supportsWhere": {
                return this.aKT.isUseWhereClause() ? "true" : "false";
            }
            case "supportsParenthesesForJoin": {
                return this.aKT.isUseParenthesiseForJoin() ? "true" : "false";
            }
            case "quotesLowerCase": {
                return this.aKT.isUseQuoteLowerCase() ? "true" : "false";
            }
            case "identifierQuoteString": {
                return this.aKT.getIdentifierQuoteString() != null ? this.aKT.getIdentifierQuoteString() : "";
            }
            case "aliasToken": {
                return this.aKT.getAliasToken() != null ? this.aKT.getAliasToken() : "";
            }
            case "escapeEverything": {
                return this.aKT.isUseEscapeEverything() ? "true" : "false";
            }
        }
        return "";
    }

    public String getCatalog() {
        return this.aKS;
    }

    public void setCatalog(String string) {
        if (string == null) {
            string = "";
        }
        DataSourceConfigurationManager.a(this, PROPERTY_CATALOG, this.getUrl(), this.url);
        this.aKS = string;
    }

    public String getUser() {
        return this.aKU.getProperty(PROPERTY_USER, "");
    }

    public void setUser(String string) {
        if (string == null) {
            string = "";
        }
        DataSourceConfigurationManager.a(this, PROPERTY_USER, this.getUser(), string);
        this.aKU.setProperty(PROPERTY_USER, string);
    }

    public String getPassword() {
        return this.aKU.getProperty(PROPERTY_PASSWORD, "");
    }

    public void setPassword(String string) {
        if (string == null) {
            string = "";
        }
        DataSourceConfigurationManager.a(this, PROPERTY_PASSWORD, this.getPassword(), string);
        this.aKU.setProperty(PROPERTY_PASSWORD, string);
    }

    public void setSavePassword(boolean bl2) {
        this.NL = bl2;
    }

    public boolean isSavePassword() {
        return this.NL;
    }

    public boolean isNeedPassword() {
        b b2 = c.k(Locale.getDefault()).d(this);
        if (b2 == null) {
            return true;
        }
        for (int i2 = 0; i2 < b2.ws(); ++i2) {
            a a2 = b2.dF(i2);
            if (!PROPERTY_PASSWORD.equals(a2.getName())) continue;
            return true;
        }
        return false;
    }

    public String getDriverLibrary() {
        return this.classpath != null ? this.classpath : "";
    }

    public void setDriverLibrary(String string) {
        this.classpath = string;
        String string2 = this.getDriverLibrary();
        if (string2.length() != 0) {
            UpdateableClassLoader updateableClassLoader = (UpdateableClassLoader)((Object)BaseUtils.getUpdateableClassLoader());
            updateableClassLoader.addUrlOrPath(string2);
        }
    }

    public void save(int n2) throws SecurityException {
        if (this.getDriverLibrary().length() > 0) {
            ((UpdateableClassLoader)((Object)BaseUtils.getUpdateableClassLoader())).addUrlOrPath(this.getDriverLibrary());
        }
        DataSourceConfigurationManager.saveDataSourceConfiguration(this, n2);
    }

    public static Driver getDriverObject(Class<?> clazz) {
        Driver driver;
        Enumeration<Driver> enumeration = DriverManager.getDrivers();
        while (enumeration.hasMoreElements()) {
            driver = enumeration.nextElement();
            if (!driver.getClass().getName().equals(clazz.getName())) continue;
            return driver;
        }
        try {
            driver = (Driver)clazz.newInstance();
            return driver;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static Driver getDriverObject(String string) {
        try {
            return DataSourceConfiguration.getDriverObject(BaseUtils.getUpdateableClassLoader().loadClass(string));
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Deprecated
    public String checkConnection() throws Throwable {
        this.validate();
        return null;
    }

    public void validate() throws ClassNotFoundException, InstantiationException, IllegalAccessException, SQLException, ReportException {
        String string = this.getDriverClassname();
        Driver driver = null;
        if (string != null && string.trim().length() != 0) {
            driver = (Driver)BaseUtils.classForName(string).newInstance();
            DriverManager.registerDriver(driver);
            Properties properties = (Properties)this.aKU.clone();
            String string2 = DataSourceConfiguration.adaptUrl(this.getUrl(), properties);
            Object object = properties.keySet().toArray(new String[properties.size()]);
            for (int i2 = 0; i2 < ((String[])object).length; ++i2) {
                String string3 = properties.getProperty(object[i2]);
                if (string3 != null && string3.length() != 0) continue;
                properties.remove(object[i2]);
            }
            if (driver != null) {
                object = driver.connect(string2, properties);
                if (object == null) {
                    throw ReportExceptionFactory.createReportException(ErrorCode.PM_InvalidDrvUrl, string2, string);
                }
                object.close();
            }
        } else {
            String string4 = this.getDatabaseClassname();
            Object t2 = BaseUtils.classForName(string4).newInstance();
            Class<?> clazz = t2.getClass();
            Class clazz2 = BaseUtils.classForName("com.inet.report.database.DataFactory");
            if (!clazz2.isAssignableFrom(clazz)) {
                throw new ClassCastException(t2.getClass() + " has to implement com.inet.report.database.DataFactory");
            }
            try {
                Class clazz3 = BaseUtils.classForName("com.inet.report.RDC");
                Object object = this.getMethod(clazz3, "createEmptyEngine", new Class[0]).invoke(null, new Object[0]);
                Object object2 = this.getMethod(object.getClass(), "getDatabaseTables", new Class[0]).invoke(object, new Object[0]);
                Object object3 = this.getMethod(object2.getClass(), "createDatasource", String.class).invoke(object2, this.aKP);
                Method method = this.getMethod(clazz, "getTableSourceInfos", object3.getClass(), String.class);
                method.invoke(t2, object3, "");
            }
            catch (InvocationTargetException invocationTargetException) {
                throw ReportExceptionFactory.createReportExceptionWithCause(invocationTargetException.getTargetException());
            }
            catch (Exception exception) {
                throw ReportExceptionFactory.createReportExceptionWithCause(exception);
            }
        }
    }

    private Method getMethod(Class<?> clazz, String string, Class<?> ... classArray) throws Exception {
        if (DotNetUtils.isDotNet()) {
            string = Character.toUpperCase(string.charAt(0)) + string.substring(1);
        }
        return clazz.getMethod(string, classArray);
    }

    public static String adaptUrl(String string, Properties properties) {
        int n2 = 0;
        while (string.indexOf(123, n2) != -1) {
            int n3;
            int n4;
            if (BaseUtils.isDebug()) {
                BaseUtils.debug("[DataSourceConfiguration] adapt driver URL. " + string);
            }
            if ((n4 = string.indexOf(123, n2)) > (n3 = string.indexOf(125, n2))) break;
            String string2 = string.substring(n4 + 1, n3);
            String string3 = properties.getProperty(string2);
            if (string3 != null) {
                if (BaseUtils.isDebug()) {
                    BaseUtils.debug("[DataSourceConfiguration] adapt driver URL. replace \"{" + string2 + "}\" with \"" + string3 + "\"");
                }
                properties.remove(string2);
                string = string.substring(0, n4) + string3 + string.substring(n3 + 1, string.length());
                continue;
            }
            n2 = n3 + 1;
        }
        return string;
    }

    public void setValidationQuery(String string) {
        this.aKU.put(PROPERTY_VALIDATION_QUERY, string);
    }

    public String getValidationQuery() {
        return this.aKU.getProperty(PROPERTY_VALIDATION_QUERY);
    }

    public int compareTo(Object object) {
        return this.aKP.compareTo(((DataSourceConfiguration)object).aKP);
    }

    void setQuiet(boolean bl2) {
        this.aKT.setQuiet(bl2);
    }

    public boolean isLayoutDataSource() {
        return "LayoutDatasource".endsWith(this.aKP);
    }
}

