/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.config.datasource;

import com.inet.lib.util.PreferencesUtils;
import com.inet.report.BaseUtils;
import com.inet.report.ReportException;
import com.inet.report.ah;
import com.inet.report.config.datasource.DataSourceConfiguration;
import com.inet.report.config.datasource.DataSourceConfigurationChangeListener;
import com.inet.report.config.datasource.a;
import com.inet.report.config.datasource.swing.DataSourceConfigurationDialog;
import com.inet.report.config.datasource.swing.DataSourceManagerDialog;
import com.inet.report.config.datasource.swing.au;
import com.inet.report.servlets.c;
import java.awt.Dialog;
import java.awt.Frame;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.servlet.http.HttpSession;

public class DataSourceConfigurationManager {
    private static ArrayList<DataSourceConfigurationChangeListener> aKV;
    public static final int SYSTEM_PREFERENCES = 1;
    public static final int USER_PREFERENCES = 2;
    public static final int ALL_PREFERENCES = 3;
    public static final int TEMPORARY_PREFERENCES = 4;
    public static final int USER_SESSION = 6;
    private static HashMap<String, DataSourceConfiguration> aKW;
    private static HashMap<String, DataSourceConfiguration> aKX;
    private static HashMap<String, DataSourceConfiguration> aKY;
    private static HashMap<String, DataSourceConfiguration> aKZ;
    private static final String aKB;
    private static long[] aLa;
    private static long[] aLb;
    private static DataSourceConfigurationManager aLc;

    private DataSourceConfigurationManager() {
    }

    private static HashMap<String, DataSourceConfiguration> dy(int n2) {
        DataSourceConfigurationManager.dB(n2);
        switch (n2) {
            case 1: {
                return aKW;
            }
            case 2: {
                return aKX;
            }
            case 3: {
                try {
                    HttpSession httpSession = c.YB();
                    if (httpSession != null) {
                        HashMap hashMap;
                        try {
                            hashMap = (HashMap)httpSession.getAttribute(aKB);
                        }
                        catch (IllegalStateException illegalStateException) {
                            if (BaseUtils.isDebug()) {
                                BaseUtils.debug("Can't use session datasources: " + illegalStateException.getMessage());
                            }
                            hashMap = null;
                        }
                        if (hashMap != null && hashMap.size() > 0) {
                            HashMap<String, DataSourceConfiguration> hashMap2 = new HashMap<String, DataSourceConfiguration>(aKZ);
                            hashMap2.putAll(hashMap);
                            return hashMap2;
                        }
                    }
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    // empty catch block
                }
                return aKZ;
            }
            case 4: {
                return aKY;
            }
            case 6: {
                try {
                    HttpSession httpSession = c.YB();
                    if (httpSession == null) {
                        throw new IllegalStateException("No HttpSession avialable. You use the scope USER_SESSION outside of a servlet call.");
                    }
                    HashMap hashMap = (HashMap)httpSession.getAttribute(aKB);
                    if (hashMap == null) {
                        hashMap = new HashMap();
                        httpSession.setAttribute(aKB, hashMap);
                    }
                    return hashMap;
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    throw new IllegalStateException("No HttpSession avialable. You use the scope USER_SESSION outside of a servlet call.");
                }
            }
        }
        throw new IllegalArgumentException("Invalid value for scope: " + String.valueOf(n2));
    }

    public static String getUniqueName(String string, int n2) {
        int n3 = 1;
        String string2 = string;
        if (string2.length() > 80) {
            string2 = string2.substring(0, 80);
        }
        String string3 = string2 = string2.trim();
        while (DataSourceConfigurationManager.getDataSourceConfiguration(string3, n2) != null) {
            String string4 = " (" + n3 + ")";
            if (string2.length() + string4.length() > 80) {
                string2 = string2.substring(0, 80 - string4.length());
            }
            string3 = string2 + string4;
            ++n3;
        }
        return string3;
    }

    public static String[] getDataSourceConfigurationNames() {
        return DataSourceConfigurationManager.vM().dz(3);
    }

    public static String[] getDataSourceConfigurationNames(int n2) {
        return DataSourceConfigurationManager.vM().dz(n2);
    }

    String[] dz(int n2) {
        HashMap<String, DataSourceConfiguration> hashMap = DataSourceConfigurationManager.dy(n2);
        String[] stringArray = new String[hashMap.size()];
        hashMap.keySet().toArray(stringArray);
        return stringArray;
    }

    public static DataSourceConfiguration[] getDataSourceConfigurations(int n2) {
        HashMap<String, DataSourceConfiguration> hashMap = DataSourceConfigurationManager.dy(n2);
        DataSourceConfiguration[] dataSourceConfigurationArray = new DataSourceConfiguration[hashMap.size()];
        hashMap.values().toArray(dataSourceConfigurationArray);
        return dataSourceConfigurationArray;
    }

    public static DataSourceConfiguration getDataSourceConfiguration(String string, int n2) {
        HashMap<String, DataSourceConfiguration> hashMap = DataSourceConfigurationManager.dy(n2);
        return hashMap.get(string);
    }

    public static boolean exists(String string) {
        return DataSourceConfigurationManager.exists(string, 3);
    }

    public static boolean isWriteable(int n2) {
        return DataSourceConfigurationManager.E(n2, aKB);
    }

    private static boolean E(int n2, String string) {
        switch (n2) {
            case 1: {
                return PreferencesUtils.isSystemWriteable(string);
            }
            case 2: {
                return PreferencesUtils.isUserWriteable(string);
            }
            case 4: {
                return true;
            }
            case 3: {
                return false;
            }
            case 6: {
                try {
                    return DataSourceConfigurationManager.dy(n2) != null;
                }
                catch (IllegalStateException illegalStateException) {
                    return false;
                }
            }
        }
        throw new IllegalArgumentException("Invalid value for scope: " + String.valueOf(n2));
    }

    public static boolean isReadable(int n2) {
        switch (n2) {
            case 1: {
                return PreferencesUtils.isSystemReadable(aKB);
            }
            case 2: {
                return PreferencesUtils.isUserReadable(aKB);
            }
            case 4: {
                return true;
            }
            case 3: {
                return PreferencesUtils.isSystemReadable(aKB) && PreferencesUtils.isUserReadable(aKB);
            }
            case 6: {
                try {
                    return DataSourceConfigurationManager.dy(n2) != null;
                }
                catch (IllegalStateException illegalStateException) {
                    return false;
                }
            }
        }
        throw new IllegalArgumentException("Invalid value for scope: " + String.valueOf(n2));
    }

    public static boolean exists(String string, int n2) {
        return DataSourceConfigurationManager.getDataSourceConfiguration(string, n2) != null;
    }

    private static void a(DataSourceConfiguration[] dataSourceConfigurationArray, int n2, boolean bl2) throws SecurityException {
        for (int i2 = 0; i2 < dataSourceConfigurationArray.length; ++i2) {
            if (DataSourceConfigurationManager.exists(dataSourceConfigurationArray[i2].getConfigurationName(), n2)) {
                if (bl2) continue;
                DataSourceConfiguration dataSourceConfiguration = new DataSourceConfiguration(DataSourceConfigurationManager.getUniqueName(dataSourceConfigurationArray[i2].getConfigurationName(), n2));
                dataSourceConfiguration.addProperties(dataSourceConfigurationArray[i2].getProperties());
                dataSourceConfigurationArray[i2] = dataSourceConfiguration;
            }
            DataSourceConfigurationManager.saveDataSourceConfiguration(dataSourceConfigurationArray[i2], n2);
            if (aKV == null) continue;
            for (int i3 = 0; i3 < aKV.size(); ++i3) {
                aKV.get(i3).addedDataSourceConfiguration(dataSourceConfigurationArray[i2]);
            }
        }
    }

    @Deprecated
    public static void saveDataSourceConfiguration(DataSourceConfiguration dataSourceConfiguration, int n2) throws SecurityException {
        HashMap<String, DataSourceConfiguration> hashMap;
        block11: {
            if (dataSourceConfiguration == null) {
                throw new NullPointerException("[DataSourceConfigurationManager - saveDataSourceConfiguration(DataSourceConfiguration, int)] Parameter 'dsc' must not bo null");
            }
            if (n2 == 3) {
                throw new IllegalArgumentException("Invalid value for parameter 'preferenceScope'");
            }
            if (!DataSourceConfigurationManager.isWriteable(n2) || !DataSourceConfigurationManager.E(n2, aKB + "/" + dataSourceConfiguration.getConfigurationName())) {
                throw new SecurityException("Preferences node for data source '" + dataSourceConfiguration.getConfigurationName() + "' was write protected!");
            }
            hashMap = DataSourceConfigurationManager.dy(n2);
            Preferences preferences = DataSourceConfigurationManager.w(n2, true);
            if (preferences != null) {
                Preferences preferences2 = preferences.node(dataSourceConfiguration.getConfigurationName());
                Properties properties = dataSourceConfiguration.getProperties();
                boolean bl2 = dataSourceConfiguration.isSavePassword();
                Enumeration<Object> enumeration = properties.keys();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    String string2 = properties.getProperty(string);
                    if (string.equals("password")) {
                        if (bl2) {
                            string2 = BaseUtils.encrypt(string2);
                        } else {
                            preferences2.remove(string);
                            continue;
                        }
                    }
                    if (string.length() <= 0) continue;
                    preferences2.put(string, string2);
                }
                preferences.put("timestamp", String.valueOf(System.currentTimeMillis()));
                try {
                    preferences.flush();
                }
                catch (BackingStoreException backingStoreException) {
                    if (!BaseUtils.isError()) break block11;
                    BaseUtils.error("[DataSourceConfigurationManager] save configuration failed");
                }
            }
        }
        if (!hashMap.containsValue(dataSourceConfiguration)) {
            hashMap.put(dataSourceConfiguration.getConfigurationName(), dataSourceConfiguration);
        }
        DataSourceConfigurationManager.vL();
    }

    public static DataSourceConfiguration createDataSourceConfiguration(String string, int n2) throws SecurityException {
        if (string == null) {
            throw new NullPointerException("[DataSourceConfigurationManager - createDataSourceConfiguration(String, int)] The parameter 'configurationName' must not be  null.");
        }
        if ((string = string.trim()).length() == 0) {
            throw new IllegalArgumentException("[DataSourceConfigurationManager - createDataSourceConfiguration(String, int)] The parameter 'configurationName' must not be empty.");
        }
        if (n2 == 3) {
            throw new IllegalArgumentException("[DataSourceConfigurationManager - createDataSourceConfiguration(String, int)] Invalid value for parameter 'preferenceScope'");
        }
        DataSourceConfiguration dataSourceConfiguration = DataSourceConfigurationManager.getDataSourceConfiguration(string, n2);
        if (dataSourceConfiguration != null) {
            string = DataSourceConfigurationManager.getUniqueName(string, n2);
        }
        dataSourceConfiguration = new DataSourceConfiguration(string);
        DataSourceConfigurationManager.saveDataSourceConfiguration(dataSourceConfiguration, n2);
        if (aKV != null) {
            for (int i2 = 0; i2 < aKV.size(); ++i2) {
                aKV.get(i2).addedDataSourceConfiguration(dataSourceConfiguration);
            }
        }
        return dataSourceConfiguration;
    }

    public static void removeDatasourceConfigurations(DataSourceConfiguration[] dataSourceConfigurationArray, int n2) {
        for (int i2 = 0; i2 < dataSourceConfigurationArray.length; ++i2) {
            DataSourceConfigurationManager.removeDatasourceConfiguration(dataSourceConfigurationArray[i2].getConfigurationName(), n2);
        }
    }

    public static void removeDatasourceConfiguration(String string, int n2) {
        HashMap<String, DataSourceConfiguration> hashMap;
        DataSourceConfiguration dataSourceConfiguration;
        block10: {
            if (string == null || string.length() == 0) {
                throw new IllegalArgumentException("[DataSourceConfigurationManager - removeDatasourceConfiguration(String, int)] The parameter 'configurationName' must not be empty or null");
            }
            dataSourceConfiguration = DataSourceConfigurationManager.getDataSourceConfiguration(string, n2);
            if (dataSourceConfiguration == null) {
                return;
            }
            if (n2 == 3) {
                throw new IllegalArgumentException("Invalid value for parameter 'preferenceScope'");
            }
            if (!DataSourceConfigurationManager.isWriteable(n2) || !DataSourceConfigurationManager.E(n2, aKB + "/" + dataSourceConfiguration.getConfigurationName())) {
                throw new SecurityException("Preferences node for data source '" + dataSourceConfiguration.getConfigurationName() + "' was write protected!");
            }
            hashMap = DataSourceConfigurationManager.dy(n2);
            Preferences preferences = DataSourceConfigurationManager.w(n2, true);
            if (BaseUtils.isDebug()) {
                BaseUtils.debug("[DataSourceConfigurationManager] remove configuration \"" + string + "\"");
            }
            if (preferences != null) {
                try {
                    Preferences preferences2 = preferences.node(dataSourceConfiguration.getConfigurationName());
                    preferences2.removeNode();
                    preferences.put("timestamp", String.valueOf(System.currentTimeMillis()));
                    preferences.flush();
                }
                catch (BackingStoreException backingStoreException) {
                    if (!BaseUtils.isError()) break block10;
                    BaseUtils.error("[DataSourceConfigurationManager] remove configuration failed");
                }
            }
        }
        hashMap.remove(dataSourceConfiguration.getConfigurationName());
        DataSourceConfigurationManager.vL();
        if (aKV != null) {
            for (int i2 = 0; i2 < aKV.size(); ++i2) {
                if (aKV.get(i2) == null) continue;
                aKV.get(i2).removedDataSourceConfiguration(dataSourceConfiguration);
            }
        }
    }

    public static void forceImportDataSourceConfigurations(int n2, File file) throws ReportException, SecurityException {
        DataSourceConfiguration[] dataSourceConfigurationArray;
        a a2 = new a(file);
        for (DataSourceConfiguration dataSourceConfiguration : dataSourceConfigurationArray = a2.vN()) {
            if (!DataSourceConfigurationManager.exists(dataSourceConfiguration.getConfigurationName())) continue;
            DataSourceConfigurationManager.removeDatasourceConfiguration(dataSourceConfiguration.getConfigurationName(), n2);
        }
        DataSourceConfigurationManager.a(dataSourceConfigurationArray, n2, true);
    }

    public static void importDataSourceConfigurations(int n2, File file) throws ReportException {
        DataSourceConfigurationManager.importDataSourceConfigurations(n2, file, false);
    }

    public static void importDataSourceConfigurations(int n2, File file, boolean bl2) throws ReportException, SecurityException {
        a a2 = new a(file);
        DataSourceConfiguration[] dataSourceConfigurationArray = a2.vN();
        DataSourceConfigurationManager.a(dataSourceConfigurationArray, n2, bl2);
    }

    public static void exportDataSourceConfigurations(DataSourceConfiguration[] dataSourceConfigurationArray, File file) {
        block2: {
            a a2 = new a(file);
            try {
                a2.a(dataSourceConfigurationArray);
            }
            catch (ReportException reportException) {
                if (!BaseUtils.isError()) break block2;
                BaseUtils.error("[DataSourceConfigurationManager] data source configuration export failed");
            }
        }
    }

    private static Preferences w(int n2, boolean bl2) throws IllegalArgumentException {
        switch (n2) {
            case 1: {
                return PreferencesUtils.systemRoot().node(aKB);
            }
            case 2: {
                return PreferencesUtils.userRoot().node(aKB);
            }
            case 4: 
            case 6: {
                if (!bl2) break;
                return null;
            }
        }
        throw ah.a(n2, "preferenceScope", null);
    }

    private static HashMap<String, DataSourceConfiguration> dA(int n2) {
        HashMap<String, DataSourceConfiguration> hashMap;
        block12: {
            hashMap = new HashMap<String, DataSourceConfiguration>();
            if (!DataSourceConfigurationManager.isReadable(n2)) {
                BaseUtils.warning("can not read from Preferences to get datasource info!");
                return hashMap;
            }
            Preferences preferences = DataSourceConfigurationManager.w(n2, false);
            try {
                String[] stringArray = preferences.childrenNames();
                if (stringArray.length > 0) {
                    for (int i2 = 0; i2 < stringArray.length; ++i2) {
                        String string = stringArray[i2];
                        Preferences preferences2 = preferences.node(string);
                        preferences2.sync();
                        String[] stringArray2 = preferences2.keys();
                        if (stringArray2.length == 0) {
                            try {
                                preferences2.removeNode();
                                preferences2.flush();
                            }
                            catch (Throwable throwable) {
                                BaseUtils.printStackTrace(throwable);
                            }
                            continue;
                        }
                        DataSourceConfiguration dataSourceConfiguration = new DataSourceConfiguration(string);
                        dataSourceConfiguration.setQuiet(true);
                        hashMap.put(string, dataSourceConfiguration);
                        for (int i3 = 0; i3 < stringArray2.length; ++i3) {
                            String string2 = preferences2.get(stringArray2[i3], "");
                            if (stringArray2[i3].equals("password")) {
                                string2 = BaseUtils.decrypt(string2);
                            }
                            dataSourceConfiguration.addProperty(stringArray2[i3], string2);
                        }
                        dataSourceConfiguration.setQuiet(false);
                    }
                } else if (BaseUtils.isDebug()) {
                    String string = n2 == 1 ? " system " : " user ";
                    BaseUtils.debug("no datasource configuration for" + string + "scope");
                }
            }
            catch (BackingStoreException backingStoreException) {
                if (!BaseUtils.isError()) break block12;
                BaseUtils.error("[DataSourceConfigurationManager] - load configuration failed");
            }
        }
        return hashMap;
    }

    private static void vL() {
        aKZ.clear();
        aKZ.putAll(aKW);
        aKZ.putAll(aKX);
        aKZ.putAll(aKY);
    }

    private static void dB(int n2) throws IllegalArgumentException {
        block14: {
            int n3;
            switch (n2) {
                case 1: {
                    n3 = 0;
                    break;
                }
                case 2: {
                    n3 = 1;
                    break;
                }
                case 3: {
                    DataSourceConfigurationManager.dB(1);
                    DataSourceConfigurationManager.dB(2);
                    return;
                }
                case 4: 
                case 6: {
                    return;
                }
                default: {
                    throw ah.a(n2, "preferenceScope", null);
                }
            }
            if (aLb[n3] + 30000L < System.currentTimeMillis()) {
                try {
                    HashMap<String, DataSourceConfiguration> hashMap;
                    String string;
                    long l2;
                    DataSourceConfigurationManager.aLb[n3] = System.currentTimeMillis();
                    Preferences preferences = DataSourceConfigurationManager.w(n2, false);
                    if (DataSourceConfigurationManager.isReadable(n2)) {
                        preferences.sync();
                    }
                    if (aLa[n3] == (l2 = Long.parseLong(string = preferences.get("timestamp", "-1")))) break block14;
                    DataSourceConfigurationManager.aLa[n3] = l2;
                    try {
                        hashMap = DataSourceConfigurationManager.dA(n2);
                    }
                    catch (Throwable throwable) {
                        if (BaseUtils.gk()) {
                            BaseUtils.warning(throwable);
                        }
                        hashMap = new HashMap();
                        DataSourceConfigurationManager.aLb[n3] = 9223372036854475807L;
                    }
                    DataSourceConfigurationManager.a(n2, hashMap);
                }
                catch (BackingStoreException backingStoreException) {
                    DataSourceConfigurationManager.a(n2, new HashMap<String, DataSourceConfiguration>());
                    BaseUtils.printStackTrace(backingStoreException);
                }
                catch (SecurityException securityException) {
                    DataSourceConfigurationManager.a(n2, new HashMap<String, DataSourceConfiguration>());
                    BaseUtils.printStackTrace(securityException);
                }
            }
        }
    }

    private static void a(int n2, HashMap<String, DataSourceConfiguration> hashMap) {
        switch (n2) {
            case 1: {
                aKW = hashMap;
                break;
            }
            case 2: {
                aKX = hashMap;
            }
        }
        if (aKW != null && aKX != null) {
            DataSourceConfigurationManager.vL();
        }
    }

    public static void addDataSourceConfigurationListener(DataSourceConfigurationChangeListener dataSourceConfigurationChangeListener) {
        if (aKV == null) {
            aKV = new ArrayList();
        }
        aKV.add(dataSourceConfigurationChangeListener);
    }

    public static DataSourceConfigurationChangeListener[] getDataSourceConfigurationListeners() {
        return aKV.toArray(new DataSourceConfigurationChangeListener[aKV.size()]);
    }

    public static void removeDataSourceConfigurationListener(DataSourceConfigurationChangeListener dataSourceConfigurationChangeListener) {
        if (aKV == null) {
            return;
        }
        aKV.remove(dataSourceConfigurationChangeListener);
    }

    static void a(DataSourceConfiguration dataSourceConfiguration, String string, String string2, String string3) {
        if (!(aKY != null && aKY.containsValue(dataSourceConfiguration) || aKX != null && aKX.containsValue(dataSourceConfiguration) || aKW != null && aKW.containsValue(dataSourceConfiguration))) {
            return;
        }
        if (string2 == null) {
            string2 = "";
        }
        if (string3 == null) {
            string3 = "";
        }
        if (aKV != null && !string2.equals(string3)) {
            for (int i2 = 0; i2 < aKV.size(); ++i2) {
                aKV.get(i2).propertyChanged(dataSourceConfiguration, string, string2, string3);
            }
        }
    }

    public static void openDataSourceManagerDialog(Frame frame, DataSourceConfiguration dataSourceConfiguration) {
        DataSourceManagerDialog.execute(frame, dataSourceConfiguration);
    }

    public static void openDataSourceManagerDialog(Dialog dialog, DataSourceConfiguration dataSourceConfiguration) {
        DataSourceManagerDialog.execute(dialog, dataSourceConfiguration);
    }

    public static DataSourceConfiguration openReportDataSourceDialog(Frame frame, DataSourceConfiguration dataSourceConfiguration) {
        return au.a(frame, dataSourceConfiguration);
    }

    @Deprecated
    public static DataSourceConfiguration openDataSourceConfigurationDialog(Frame frame, DataSourceConfiguration dataSourceConfiguration, String string) {
        return aLc.a(frame, dataSourceConfiguration, string);
    }

    @Deprecated
    DataSourceConfiguration a(Frame frame, DataSourceConfiguration dataSourceConfiguration, String string) {
        return DataSourceConfigurationDialog.execute(frame, dataSourceConfiguration, string);
    }

    static DataSourceConfigurationManager vM() {
        return aLc;
    }

    static {
        aKZ = new HashMap();
        aKB = PreferencesUtils.getRelativePrefPath(DataSourceConfigurationManager.class);
        aLa = new long[2];
        aLb = new long[2];
        aLc = new DataSourceConfigurationManager();
        aKY = new HashMap();
        DataSourceConfigurationManager.dB(3);
    }
}

