/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.config.datasource;

import com.inet.lib.util.IOFunctions;
import com.inet.report.BaseUtils;
import com.inet.report.config.datasource.DataSourceConfiguration;
import com.inet.report.config.datasource.DataSourceConfigurationManager;
import com.inet.report.config.datasource.DatasourceModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class b {
    private static b aLn = new b();

    b() {
    }

    public static b vO() {
        return aLn;
    }

    public void c(OutputStream outputStream) {
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = BaseUtils.newDocumentBuilderFactory().newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            BaseUtils.printStackTrace(parserConfigurationException);
        }
        Document document = documentBuilder.newDocument();
        Element element = document.createElement("Datasources");
        document.appendChild(element);
        Element element2 = document.createElement("Scope");
        element2.setAttribute("name", "system");
        this.a(document, element2, 1);
        element.appendChild(element2);
        Element element3 = document.createElement("Scope");
        element3.setAttribute("name", "user");
        this.a(document, element3, 2);
        element.appendChild(element3);
        Element element4 = document.createElement("Scope");
        element4.setAttribute("name", "temp");
        this.a(document, element4, 4);
        element.appendChild(element4);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            Transformer transformer = transformerFactory.newTransformer();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF8");
            DOMSource dOMSource = new DOMSource(document);
            StreamResult streamResult = new StreamResult(outputStreamWriter);
            transformer.transform(dOMSource, streamResult);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            BaseUtils.printStackTrace(transformerConfigurationException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            BaseUtils.printStackTrace(unsupportedEncodingException);
        }
        catch (TransformerException transformerException) {
            BaseUtils.printStackTrace(transformerException);
        }
    }

    private void a(Document document, Element element, int n2) {
        DataSourceConfiguration[] dataSourceConfigurationArray;
        for (DataSourceConfiguration dataSourceConfiguration : dataSourceConfigurationArray = DataSourceConfigurationManager.getDataSourceConfigurations(n2)) {
            Element element2 = document.createElement("Datasource");
            element2.setAttribute("name", dataSourceConfiguration.getConfigurationName());
            element2.setAttribute("driver", dataSourceConfiguration.getDriverClassname());
            element.appendChild(element2);
        }
    }

    public void a(OutputStream outputStream, String string) {
        String[] stringArray = string.split("/");
        if (stringArray.length != 2) {
            BaseUtils.error("illegal parameter for getdatasource POST request: " + string);
        } else {
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            int n2 = this.bB(string2);
            DataSourceConfiguration dataSourceConfiguration = DataSourceConfigurationManager.getDataSourceConfiguration(string3, n2);
            try {
                File file = File.createTempFile("tmp", ".xml");
                file.deleteOnExit();
                DataSourceConfigurationManager.exportDataSourceConfigurations(new DataSourceConfiguration[]{dataSourceConfiguration}, file);
                FileInputStream fileInputStream = new FileInputStream(file);
                byte[] byArray = IOFunctions.readBytes(fileInputStream);
                fileInputStream.close();
                outputStream.write(byArray);
            }
            catch (IOException iOException) {
                BaseUtils.printStackTrace(iOException);
            }
        }
    }

    private int bB(String string) {
        int n2 = 0;
        if (string.toLowerCase().equals("temp")) {
            n2 = 4;
        } else if (string.toLowerCase().equals("user")) {
            n2 = 2;
        } else if (string.toLowerCase().equals("system")) {
            n2 = 1;
        } else {
            BaseUtils.error("illegal scope name for getdatasource POST request: " + string);
        }
        return n2;
    }

    public List<DatasourceModel> b(InputStream inputStream) {
        try {
            ArrayList<DatasourceModel> arrayList = new ArrayList<DatasourceModel>();
            DocumentBuilder documentBuilder = BaseUtils.newDocumentBuilderFactory().newDocumentBuilder();
            Document document = documentBuilder.parse(new InputSource(new InputStreamReader(inputStream, "ISO-8859-1")));
            NodeList nodeList = document.getDocumentElement().getChildNodes();
            for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
                Node node = nodeList.item(i2);
                if (node.getNodeType() != 1) continue;
                Element element = (Element)node;
                int n2 = this.bB(element.getAttribute("name"));
                NodeList nodeList2 = element.getChildNodes();
                for (int i3 = 0; i3 < nodeList2.getLength(); ++i3) {
                    Node node2 = nodeList2.item(i3);
                    if (node2.getNodeType() != 1) continue;
                    Element element2 = (Element)node2;
                    String string = element2.getAttribute("name");
                    String string2 = element2.getAttribute("driver");
                    arrayList.add(new DatasourceModel(n2, string, string2));
                }
            }
            return arrayList;
        }
        catch (SAXException sAXException) {
            BaseUtils.printStackTrace(sAXException);
        }
        catch (IOException iOException) {
            BaseUtils.printStackTrace(iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            BaseUtils.printStackTrace(parserConfigurationException);
        }
        return null;
    }
}

