/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.config.datasource.swing;

import com.inet.lib.swing.control.InitializableControlPanel;
import com.inet.lib.swing.control.Message;
import com.inet.report.config.datasource.DataSourceConfiguration;
import com.inet.report.config.datasource.DataSourceConfigurationManager;
import com.inet.report.config.datasource.swing.DataSourceEditor;
import com.inet.report.config.datasource.swing.ad;
import com.inet.report.config.gui.swing.ConfigurationImporter;
import com.inet.report.config.structure.MsgAdmin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JTabbedPane;

public class DataSourceManager
extends InitializableControlPanel
implements ActionListener {
    private static ad aLy = ad.j(Locale.getDefault());
    private String description = aLy.getMsg("dsm.description", new Object[0]);
    private String aMq = MsgAdmin.getInstance().getMsg("config_select.warning", new Object[0]);
    private JTabbedPane aMr;
    private DataSourceConfiguration aMs;

    public DataSourceManager(DataSourceConfiguration dataSourceConfiguration, boolean bl2) {
        super(aLy.getMsg("dsm.name", new Object[0]));
        this.aMs = dataSourceConfiguration;
        if (bl2) {
            this.init();
        }
    }

    @Override
    public synchronized void init() {
        if (!this.isInit()) {
            this.setInit();
            this.bj();
        }
    }

    private void bj() {
        this.setLayout(new BorderLayout());
        this.aMr = new JTabbedPane();
        this.aMr.setName("dsm.tabs");
        this.s("dsm.systemtab", 1);
        this.s("dsm.usertab", 2);
        this.s("dsm.temptab", 4);
        this.aMr.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.add((Component)this.aMr, "Center");
        if (this.aMs != null) {
            for (int i2 = this.aMr.getTabCount() - 1; i2 >= 0; --i2) {
                DataSourceEditor dataSourceEditor = (DataSourceEditor)this.aMr.getComponentAt(i2);
                if (!dataSourceEditor.selectConfiguration(this.aMs)) continue;
                this.aMr.setSelectedComponent(dataSourceEditor);
                break;
            }
        }
    }

    private void s(String string, int n2) {
        if (!DataSourceConfigurationManager.isReadable(n2)) {
            return;
        }
        DataSourceEditor dataSourceEditor = new DataSourceEditor(n2, false);
        dataSourceEditor.setName(string);
        dataSourceEditor.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.aMr.add(aLy.getMsg(string, new Object[0]) + (n2 == 2 ? " (" + System.getProperty("user.name") + ")" : ""), dataSourceEditor);
        dataSourceEditor.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof DataSourceEditor) {
            DataSourceEditor dataSourceEditor = (DataSourceEditor)object;
            dataSourceEditor.wa();
        }
    }

    @Override
    public Icon getIcon() {
        return ConfigurationImporter.getIcon("datasource_32.png");
    }

    @Override
    public Message verify(boolean bl2) {
        return null;
    }

    @Override
    public void commit() {
    }

    @Override
    public String help() {
        return "DatabaseConfiguration";
    }

    private boolean isRemote() {
        Class<DataSourceManager> clazz = DataSourceManager.class;
        URL uRL = clazz.getResource(clazz.getSimpleName() + ".class");
        URLConnection uRLConnection = null;
        try {
            uRLConnection = uRL.openConnection();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!(uRLConnection instanceof JarURLConnection)) {
            return false;
        }
        JarURLConnection jarURLConnection = (JarURLConnection)uRLConnection;
        URL uRL2 = jarURLConnection.getJarFileURL();
        return uRL2.getProtocol().startsWith("http");
    }

    @Override
    public String getDescription() {
        if (this.isRemote()) {
            return this.description + " " + this.aMq;
        }
        return this.description;
    }
}

