/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.config.font;

import com.inet.lib.util.JavaUtils;
import com.inet.report.BaseUtils;
import com.inet.report.config.font.AbstractFontProvider;
import com.inet.report.config.font.FontFamily;
import com.inet.report.config.font.v;
import com.inet.report.config.font.y;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FontProvider
extends AbstractFontProvider
implements ChangeListener {
    private static FontProvider aPF;
    private String aPG = "SansSerif";
    private GraphicsEnvironment aPH;
    private List<FontFamily> aPI = new ArrayList<FontFamily>();
    private List<FontFamily> aPJ;

    FontProvider(GraphicsEnvironment graphicsEnvironment) {
        this.aPH = graphicsEnvironment;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (this.aPJ != null) {
            this.aPJ = null;
            this.fireChangeEvent();
        }
    }

    public static FontProvider getInstance() {
        return aPF;
    }

    static void a(FontProvider fontProvider) {
        if (aPF != null) {
            v.removeChangeListener(aPF);
        }
        aPF = fontProvider;
        if (fontProvider != null) {
            v.addChangeListener(fontProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FontFamily> getAvailableFonts() {
        if (this.aPJ == null) {
            FontProvider fontProvider = this;
            synchronized (fontProvider) {
                if (this.aPJ == null) {
                    this.aPJ = this.xk();
                }
            }
        }
        return this.aPJ;
    }

    protected List<FontFamily> xk() {
        List<FontFamily> list = v.xg();
        this.aPI = new ArrayList<FontFamily>(list);
        if (this.wy()) {
            Font[] fontArray;
            for (Font font : fontArray = this.aPH.getAllFonts()) {
                int n2 = FontProvider.a(list, font.getFamily(Locale.ENGLISH));
                if (n2 == -1) {
                    list.add(new FontFamily(font.getFamily(), font.getFamily(Locale.ENGLISH)));
                    continue;
                }
                list.get(n2).setInstalledInSystem();
            }
            for (int i2 = 0; i2 < list.size(); ++i2) {
                FontFamily fontFamily = list.get(i2);
                if (fontFamily.isInstalledInSystem()) continue;
                this.b(fontFamily);
            }
        } else {
            list.addAll(JAVA_FONTS);
        }
        Collections.sort(list, new a());
        return list;
    }

    protected boolean wy() {
        return y.xl().sE();
    }

    private void b(FontFamily fontFamily) {
        if (JavaUtils.getJavaVersion() >= 1.6) {
            String string = fontFamily.getFontPath();
            try {
                if (string != null) {
                    GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
                    Font font = Font.createFont(0, new File(string));
                    graphicsEnvironment.registerFont(font);
                }
            }
            catch (Throwable throwable) {
                BaseUtils.printStackTrace(throwable);
            }
        }
    }

    private static int a(List<FontFamily> list, String string) {
        FontFamily fontFamily;
        int n2;
        for (n2 = 0; n2 < list.size(); ++n2) {
            fontFamily = list.get(n2);
            if (!fontFamily.getName().equalsIgnoreCase(string)) continue;
            return n2;
        }
        for (n2 = 0; n2 < list.size(); ++n2) {
            fontFamily = list.get(n2);
            if (!fontFamily.getLocalizedName().equalsIgnoreCase(string)) continue;
            return n2;
        }
        return -1;
    }

    @Override
    public String getDefaultFont() {
        return this.aPG;
    }

    @Override
    public boolean isEmbeddedFont(FontFamily fontFamily) {
        return this.aPI.contains(fontFamily);
    }

    public void writeFontListToOutputStream(ByteArrayOutputStream byteArrayOutputStream) {
        Object transformerConfigurationException;
        List<FontFamily> list = this.getAvailableFonts();
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = y.newDocumentBuilderFactory().newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IllegalStateException(parserConfigurationException);
        }
        Document document = documentBuilder.newDocument();
        Element element = document.createElement("Fonts");
        document.appendChild(element);
        for (FontFamily object2 : list) {
            transformerConfigurationException = document.createElement("Font");
            transformerConfigurationException.setAttribute("localized-name", object2.getLocalizedName());
            transformerConfigurationException.setAttribute("name", object2.getName());
            transformerConfigurationException.setAttribute("embedded", "" + object2.isEmbedded());
            transformerConfigurationException.setAttribute("installed", "" + object2.isInstalledInSystem());
            transformerConfigurationException.setAttribute("symbolic", "" + object2.isSymbolicFont());
            element.appendChild((Node)transformerConfigurationException);
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            Transformer transformer = transformerFactory.newTransformer();
            transformerConfigurationException = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF8");
            DOMSource dOMSource = new DOMSource(document);
            StreamResult streamResult = new StreamResult((Writer)transformerConfigurationException);
            transformer.transform(dOMSource, streamResult);
        }
        catch (TransformerConfigurationException unsupportedEncodingException) {
            BaseUtils.error(unsupportedEncodingException);
        }
        catch (UnsupportedEncodingException transformerException) {
            BaseUtils.error(transformerException);
        }
        catch (TransformerException transformerException) {
            BaseUtils.error(transformerException);
        }
    }

    static {
        FontProvider.a(new FontProvider(GraphicsEnvironment.getLocalGraphicsEnvironment()));
    }

    private static class a
    implements Comparator<FontFamily> {
        private a() {
        }

        public int a(FontFamily fontFamily, FontFamily fontFamily2) {
            return fontFamily.getLocalizedName().compareToIgnoreCase(fontFamily2.getLocalizedName());
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.a((FontFamily)object, (FontFamily)object2);
        }
    }
}

