/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.config.gui.widget;

import com.inet.lib.util.IOFunctions;
import com.inet.report.BaseUtils;
import com.inet.report.config.structure.MsgAdmin;

public class IPFilterValidator {
    public static final String IP_VALIDATOR = "\\A(,|\\s)*((((25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3})|(((?:(0{1,4}:){1,6}|::(f{1,4}:)?))(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3})|(((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?) ::((?:[0-9A-Fa-f]{1,4}:)*)(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3})|(((?:[0-9A-Fa-f]{1,4}:){6,6})(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3})|(((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?))|((?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}))\\s*-\\s*|\\s*-\\s*)?(((25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3})|(((?:(0{1,4}:){1,6}|::(f{1,4}:)?))(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3})|(((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?) ::((?:[0-9A-Fa-f]{1,4}:)*)(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3})|(((?:[0-9A-Fa-f]{1,4}:){6,6})(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3})|(((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?))|((?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}))((,|\\s)*\\z|((,|\\s)*?,\\s*?((((25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3})|(((?:(0{1,4}:){1,6}|::(f{1,4}:)?))(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3})|(((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?) ::((?:[0-9A-Fa-f]{1,4}:)*)(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3})|(((?:[0-9A-Fa-f]{1,4}:){6,6})(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3})|(((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?))|((?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}))\\s*-\\s*|\\s*-\\s*)?(((25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3})|(((?:(0{1,4}:){1,6}|::(f{1,4}:)?))(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3})|(((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?) ::((?:[0-9A-Fa-f]{1,4}:)*)(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3})|(((?:[0-9A-Fa-f]{1,4}:){6,6})(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3})|(((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?))|((?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4})))+(,|\\s)*\\z)*";

    public String checkSingle(String string) {
        if (!string.contains("-") && string.trim().matches(IP_VALIDATOR)) {
            return null;
        }
        return MsgAdmin.getInstance().getMsg("IPFilterPanel.InvalidIP", string);
    }

    public String checkRange(String string) {
        String[] stringArray = string.split("\\s*-\\s*");
        if (stringArray.length != 2) {
            return MsgAdmin.getInstance().getMsg("IPFilterPanel.InvalidRange", new Object[0]);
        }
        String string2 = this.checkSingle(stringArray[0]);
        if (string2 != null) {
            return string2;
        }
        string2 = this.checkSingle(stringArray[1]);
        if (string2 != null) {
            return string2;
        }
        try {
            if (IOFunctions.compareIPAdress(stringArray[0], stringArray[1]) > 0) {
                return MsgAdmin.getInstance().getMsg("IPFilterPanel.FirstMustBeLower", new Object[0]);
            }
        }
        catch (Exception exception) {
            BaseUtils.printStackTrace(exception);
        }
        return null;
    }
}

