/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.config.structure;

import com.inet.lib.util.IOFunctions;
import com.inet.report.BaseUtils;
import com.inet.report.config.ConfigurationManager;
import com.inet.report.config.LicenseKeyInfo;
import com.inet.report.config.structure.MsgAdmin;
import com.inet.report.config.structure.model.action.LicenseKeyInfoVO;
import com.inet.report.config.structure.model.properties.LicenseProperty;
import com.inet.report.config.util.RepoDatabaseValidator;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import javax.annotation.Nullable;

public class CustomActionService {
    public static LicenseKeyInfoVO[] checkLicense(LicenseProperty licenseProperty) throws IllegalArgumentException {
        ArrayList arrayList = (ArrayList)licenseProperty.getValue();
        if (arrayList == null) {
            throw new IllegalArgumentException(MsgAdmin.getInstance().getMsg("license.noKeyEntered", new Object[0]));
        }
        ConfigurationManager configurationManager = ConfigurationManager.getInstance();
        ArrayList<LicenseKeyInfoVO> arrayList2 = new ArrayList<LicenseKeyInfoVO>();
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            String string = ((String)arrayList.get(i2)).trim();
            LicenseKeyInfo licenseKeyInfo = configurationManager.getLicenseKeyInfo(string);
            arrayList2.add(new LicenseKeyInfoVO(licenseKeyInfo.isValid(), licenseKeyInfo.isValidVersion(), licenseKeyInfo.isValidIPAddress(), licenseKeyInfo.isValidCPUCount(), licenseKeyInfo.isExpired(), licenseKeyInfo.isPlus(), licenseKeyInfo.isSite(), licenseKeyInfo.getLicenseText(), licenseKeyInfo.getLicensee()));
        }
        return arrayList2.toArray(new LicenseKeyInfoVO[arrayList2.size()]);
    }

    public static String generateTrialLicense(String string, boolean bl2) throws Exception {
        StringBuilder stringBuilder = new StringBuilder("http://www.inetsoftware.de/external-services/licensekeyremoterequest_trial.php?ip=");
        InetAddress inetAddress = InetAddress.getLocalHost();
        if (!string.matches("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}")) {
            throw new IllegalArgumentException(MsgAdmin.getInstance().getMsg("license.noIPSelected.msg", new Object[0]));
        }
        if (string.equals("127.0.0.1") || string.equals("127.0.1.1")) {
            throw new IllegalArgumentException(MsgAdmin.getInstance().getMsg("license.localIPNotAllowed.msg", new Object[0]));
        }
        stringBuilder.append(string);
        stringBuilder.append("&version=");
        stringBuilder.append(13);
        stringBuilder.append("&host=");
        stringBuilder.append(inetAddress.getHostName());
        if (bl2) {
            stringBuilder.append("&type=Plus");
        }
        URL uRL = new URL(stringBuilder.toString());
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setDoInput(true);
        uRLConnection.connect();
        InputStream inputStream = uRLConnection.getInputStream();
        String string2 = IOFunctions.readAsciiString(inputStream);
        return string2;
    }

    public static String validateDatabase(@Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable String string4) {
        return new RepoDatabaseValidator(string, string3, string4, string2, "").validateSettings();
    }

    public static String validateKeyStore(@Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5) {
        return BaseUtils.validateKeyStore(string, string2, string3, string4, string5);
    }
}

