/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.config.structure;

import com.inet.report.config.structure.ConfigStructureProvider;
import com.inet.report.config.structure.ConfigurationStructure;
import com.inet.report.config.structure.model.ConfigCategory;
import com.inet.report.config.structure.model.ConfigGroup;
import com.inet.report.config.structure.model.ConfigLink;
import com.inet.report.config.structure.model.properties.CombinedProperty;
import com.inet.report.config.structure.model.properties.ConfigProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class StructureAdmin
implements Serializable {
    private static StructureAdmin aTj;
    private List<ConfigStructureProvider> aTk = new ArrayList<ConfigStructureProvider>();
    private List<ConfigGroup> aSU = new ArrayList<ConfigGroup>();
    public static final String CATEGORY_OTHER_OPTION = "category.other";
    public static final String GROUP_SYSTEM = "categorygroup.system";
    public static final String GROUP_REPORT = "categorygroup.report";
    public static final String GROUP_SECURITY = "categorygroup.security";
    public static final String GROUP_COMPONENTS = "categorygroup.components";

    protected StructureAdmin() {
    }

    public synchronized void registerConfigStructureProvider(ConfigStructureProvider configStructureProvider) {
        this.aTk.add(configStructureProvider);
        configStructureProvider.createConfigStructure(this);
    }

    public synchronized void removeConfigStructureProvider(ConfigStructureProvider configStructureProvider) {
        if (this.aTk.remove(configStructureProvider)) {
            configStructureProvider.cleanUp();
            this.aSU.clear();
            this.init();
            ArrayList<ConfigStructureProvider> arrayList = new ArrayList<ConfigStructureProvider>(this.aTk);
            for (ConfigStructureProvider configStructureProvider2 : arrayList) {
                configStructureProvider2.createConfigStructure(this);
            }
        }
    }

    protected void init() {
        List<ConfigGroup> list = ConfigurationStructure.getConfigGroups();
        if (list != null) {
            for (ConfigGroup configGroup : list) {
                this.addGroup(configGroup);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGroup(ConfigGroup configGroup) {
        List<ConfigGroup> list = this.aSU;
        synchronized (list) {
            this.aSU.add(configGroup);
        }
    }

    public List<ConfigGroup> getGroups() {
        return this.aSU;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigGroup getGroup(String string) {
        List<ConfigGroup> list = this.aSU;
        synchronized (list) {
            for (ConfigGroup configGroup : this.aSU) {
                if (!configGroup.getKey().equals(string)) continue;
                return configGroup;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigCategory getConfigCategory(String string) {
        List<ConfigGroup> list = this.aSU;
        synchronized (list) {
            for (ConfigGroup configGroup : this.aSU) {
                for (ConfigCategory configCategory : configGroup.getCategories()) {
                    if (!configCategory.getKey().equals(string)) continue;
                    return configCategory;
                }
            }
        }
        return null;
    }

    public static synchronized StructureAdmin getInstance() {
        if (aTj == null) {
            aTj = new StructureAdmin();
            aTj.init();
        }
        return aTj;
    }

    public static StructureAdmin createNewInstance() {
        return StructureAdmin.getInstance().zl();
    }

    protected StructureAdmin zl() {
        StructureAdmin structureAdmin = new StructureAdmin();
        structureAdmin.init();
        ArrayList<ConfigStructureProvider> arrayList = new ArrayList<ConfigStructureProvider>(this.aTk);
        for (ConfigStructureProvider configStructureProvider : arrayList) {
            configStructureProvider.createConfigStructure(structureAdmin);
        }
        return structureAdmin;
    }

    public <T extends Serializable> ConfigProperty<T> getSpecificProperty(ConfigProperty<T> configProperty) {
        return this.getSpecificProperty(this.getConfigCategory(configProperty.getParentCategory().getKey()), configProperty);
    }

    public <T extends Serializable> ConfigProperty<T> getSpecificProperty(ConfigCategory configCategory, ConfigProperty<T> configProperty) {
        if (configCategory != null) {
            configCategory = this.getConfigCategory(configCategory.getKey());
            for (ConfigProperty<?> configProperty2 : configCategory.getProperties()) {
                ConfigProperty<?> configProperty3 = this.a(configProperty2, configProperty);
                if (configProperty3 == null) continue;
                return configProperty3;
            }
        }
        return null;
    }

    private ConfigProperty<?> a(ConfigProperty<?> configProperty, ConfigProperty<?> configProperty2) {
        ConfigProperty configProperty32;
        if (configProperty2 instanceof CombinedProperty) {
            boolean bl2 = true;
            Iterator<ConfigProperty<?>> object = configProperty2.getChildProperties().iterator();
            configProperty32 = configProperty.getChildProperties().iterator();
            while (object.hasNext() && configProperty32.hasNext()) {
                if (object.next().getKey().equals(configProperty32.next().getKey())) continue;
                bl2 = false;
            }
            if (object.hasNext() != configProperty32.hasNext()) {
                bl2 = false;
            }
            if (bl2) {
                return configProperty;
            }
        } else {
            String string = configProperty2.getKey();
            if (string == null) {
                return null;
            }
            if (configProperty.getKey() != null && configProperty.getKey().equals(string)) {
                return configProperty;
            }
        }
        for (ConfigProperty<?> configProperty4 : configProperty.getChildProperties()) {
            configProperty32 = this.a(configProperty4, configProperty2);
            if (configProperty32 == null) continue;
            return configProperty32;
        }
        ConfigLink configLink = configProperty.getLinkTo();
        if (configLink != null) {
            for (ConfigProperty configProperty32 : configLink.getProperties()) {
                ConfigProperty<?> configProperty5 = this.a(configProperty32, configProperty2);
                if (configProperty5 == null) continue;
                return configProperty5;
            }
        }
        return null;
    }

    public List<ConfigProperty<?>> getProperties(String string) {
        ArrayList arrayList = new ArrayList();
        for (ConfigGroup configGroup : this.aSU) {
            for (ConfigCategory configCategory : configGroup.getCategories()) {
                for (ConfigProperty<?> configProperty : configCategory.getProperties()) {
                    ArrayList<ConfigProperty<?>> arrayList2 = this.a(string, configProperty);
                    if (arrayList2 == null) continue;
                    arrayList.addAll(arrayList2);
                }
            }
        }
        return arrayList;
    }

    public boolean containsProperty(String string) {
        List<ConfigProperty<?>> list = this.getProperties(string);
        return list != null && list.size() > 0;
    }

    private ArrayList<ConfigProperty<?>> a(String string, ConfigProperty<?> configProperty) {
        ArrayList arrayList = new ArrayList();
        if (string == null) {
            return arrayList;
        }
        if (string.equals(configProperty.getKey())) {
            arrayList.add(configProperty);
        }
        for (ConfigProperty<?> configProperty2 : configProperty.getChildProperties()) {
            ArrayList<ConfigProperty<?>> arrayList2 = this.a(string, configProperty2);
            if (arrayList2 == null) continue;
            arrayList.addAll(arrayList2);
        }
        return arrayList;
    }
}

