/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.config.structure.model;

import com.inet.report.config.structure.model.HasConfigProperties;
import com.inet.report.config.structure.model.properties.ConfigProperty;
import com.inet.report.config.structure.model.properties.HasPlusSettings;
import com.inet.report.config.structure.util.ConfigUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ConfigCategory
implements HasConfigProperties,
Serializable,
Cloneable {
    private String description;
    private String key;
    private String helpKey;
    private String plusLicenseTextKey;
    private String icon;
    private int visibility = 3;
    private List<ConfigProperty<?>> properties = new ArrayList();
    private String label;
    private String plusLicenseText;
    private boolean havePlusLicense;
    private boolean readonly;

    private ConfigCategory() {
    }

    public ConfigCategory(String string, String string2) {
        this.key = string;
        this.icon = string2;
    }

    public ConfigCategory(String string, String string2, String string3) {
        this(string, string2);
        this.helpKey = string3;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public ConfigCategory copy() {
        ConfigCategory configCategory = new ConfigCategory(this.key, this.icon);
        configCategory.description = this.description;
        configCategory.visibility = this.visibility;
        return configCategory;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setKey(String string) {
        this.key = string;
    }

    public String getKey() {
        return this.key;
    }

    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + (this.icon == null ? 0 : this.icon.hashCode());
        n2 = 31 * n2 + (this.key == null ? 0 : this.key.hashCode());
        n2 = 31 * n2 + (this.label == null ? 0 : this.label.hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ConfigCategory configCategory = (ConfigCategory)object;
        if (this.icon == null ? configCategory.icon != null : !this.icon.equals(configCategory.icon)) {
            return false;
        }
        if (this.key == null ? configCategory.key != null : !this.key.equals(configCategory.key)) {
            return false;
        }
        return !(this.label == null ? configCategory.label != null : !this.label.equals(configCategory.label));
    }

    @Override
    public List<ConfigProperty<?>> getProperties() {
        return this.properties;
    }

    public void addProperty(ConfigProperty<?> configProperty) {
        if (configProperty.getKey() != null) {
            ConfigUtils.checkKeyUnique(configProperty, this);
        }
        configProperty.setParent(this);
        this.properties.add(configProperty);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setVisibility(int n2) {
        this.visibility = n2;
    }

    public int getVisibility() {
        return this.visibility;
    }

    public void setHavePlusLicense(boolean bl2) {
        this.havePlusLicense = bl2;
    }

    public boolean isHavePlusLicense() {
        return this.havePlusLicense;
    }

    public void setReadonly(boolean bl2) {
        this.readonly = bl2;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public boolean hasChildOfClass(Class<? extends ConfigProperty<?>> clazz) {
        for (ConfigProperty<?> configProperty : this.properties) {
            if (configProperty.getClass() != clazz) continue;
            return true;
        }
        return false;
    }

    public boolean hasChildWhichRequiresPlusLicense() {
        for (ConfigProperty<?> configProperty : this.properties) {
            if (!configProperty.isNeedPlusLicense() && !(configProperty instanceof HasPlusSettings) && !configProperty.hasChildWhichRequiresPlusLicense()) continue;
            return true;
        }
        return false;
    }

    public ConfigProperty<?> getProperty(String string) {
        for (ConfigProperty<?> configProperty : this.properties) {
            if (!configProperty.getKey().equals(string)) continue;
            return configProperty;
        }
        return null;
    }

    public String getHelpKey() {
        return this.helpKey;
    }

    public void setPlusLicenseText(String string) {
        this.plusLicenseText = string;
    }

    public String getPlusLicenseText() {
        return this.plusLicenseText;
    }

    public void setPlusLicenseTextKey(String string) {
        this.plusLicenseTextKey = string;
    }

    public String getPlusLicenseTextKey() {
        return this.plusLicenseTextKey;
    }
}

