/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.config.structure.model;

import com.inet.report.BaseUtils;
import com.inet.report.config.structure.model.MessageProvider;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class DefaulMessageProvider
implements MessageProvider {
    private final String resourceBundleName;
    private DefaulMessageProviderControl control = new DefaulMessageProviderControl();

    public DefaulMessageProvider(String string) {
        if (string == null) {
            throw new IllegalArgumentException("resourceBundleName cannot be null!");
        }
        this.resourceBundleName = string;
    }

    @Override
    public String getMessage(String string, Locale locale, Object ... objectArray) {
        if (string == null) {
            return null;
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        ResourceBundle resourceBundle = ResourceBundle.getBundle(this.getResourceBundleName(), locale, BaseUtils.getUpdateableClassLoader(), this.control);
        return this.findMessage(string, resourceBundle, objectArray);
    }

    @Override
    public String getMessage(String string, Locale locale, ResourceBundle.Control control, Object ... objectArray) {
        if (string == null) {
            return null;
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        ResourceBundle resourceBundle = ResourceBundle.getBundle(this.getResourceBundleName(), locale, BaseUtils.getUpdateableClassLoader(), control);
        return this.findMessage(string, resourceBundle, objectArray);
    }

    private String findMessage(String string, ResourceBundle resourceBundle, Object ... objectArray) {
        if (resourceBundle == null) {
            return null;
        }
        String string2 = null;
        try {
            string2 = resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
        try {
            return MessageFormat.format(string2, objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            BaseUtils.warning(illegalArgumentException);
            return this.getResourceBundleName() + ":" + string + " is erroneous.";
        }
    }

    public String getResourceBundleName() {
        return this.resourceBundleName;
    }

    public static class DefaulMessageProviderControl
    extends ResourceBundle.Control {
        @Override
        public Locale getFallbackLocale(String string, Locale locale) {
            return null;
        }
    }
}

