/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.config.structure.model.client;

import com.inet.report.config.structure.model.ConfigCategory;
import com.inet.report.config.structure.model.ConfigLink;
import com.inet.report.config.structure.model.HasConfigProperties;
import com.inet.report.config.structure.model.properties.ConfigProperty;
import com.inet.report.config.structure.model.properties.InvalidTypeException;
import com.inet.report.config.structure.model.properties.PasswordTextProperty;
import com.inet.report.config.structure.model.properties.SelectConfigProperty;
import com.inet.report.config.structure.util.ConfigUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class ClientModel {
    private HashMap<String, String> originalProperties = new HashMap();
    private HasConfigProperties allPropertiesHolder;

    public ClientModel(ConfigCategory configCategory) {
        this.allPropertiesHolder = configCategory;
        this.storeOriginals(configCategory.getProperties());
    }

    public ClientModel(ConfigLink configLink) {
        this.allPropertiesHolder = configLink;
        this.addLinkedProperties(configLink);
    }

    private void addLinkedProperties(ConfigLink configLink) {
        for (ConfigProperty configProperty : configLink.getProperties()) {
            this.originalProperties.put(configProperty.getKey(), configProperty.getValueAsString());
            this.storeOriginals(configProperty.getChildProperties());
        }
    }

    private void storeOriginals(List<ConfigProperty<?>> list) {
        for (ConfigProperty<?> configProperty : list) {
            this.originalProperties.put(configProperty.getKey(), configProperty.getValueAsString());
            this.storeOriginals(configProperty.getChildProperties());
        }
    }

    public List<ConfigProperty<?>> getModifiedPropertiesToSave() {
        ArrayList arrayList = new ArrayList();
        this.collectModifiedPropertiesToSave(this.allPropertiesHolder.getProperties(), arrayList);
        return arrayList;
    }

    private void collectModifiedPropertiesToSave(Collection<ConfigProperty<?>> collection, Collection<ConfigProperty<?>> collection2) {
        for (ConfigProperty<?> configProperty : collection) {
            String string;
            String string2;
            if (configProperty.getKey() != null && !ConfigUtils.isEqual(string2 = configProperty.getValueAsString(), string = this.originalProperties.get(configProperty.getKey()))) {
                if (configProperty instanceof PasswordTextProperty) {
                    if (!ConfigUtils.isEqual(string2 = ConfigUtils.decrypt(string2), string = ConfigUtils.decrypt(string))) {
                        collection2.add(configProperty);
                    }
                } else {
                    collection2.add(configProperty);
                }
            }
            this.collectModifiedPropertiesToSave(configProperty.getChildProperties(), collection2);
        }
    }

    public void reset() {
        this.reset(this.allPropertiesHolder.getProperties());
    }

    private void reset(List<ConfigProperty<?>> list) {
        for (ConfigProperty<?> configProperty : list) {
            if (configProperty.getKey() != null) {
                try {
                    configProperty.setStringValue(this.originalProperties.get(configProperty.getKey()));
                }
                catch (InvalidTypeException invalidTypeException) {
                    throw new RuntimeException("Cannot reset property's value:" + configProperty.getKey() + " original value is " + this.originalProperties.get(configProperty.getKey()), invalidTypeException);
                }
            }
            this.reset(configProperty.getChildProperties());
        }
    }

    public void applyValues() {
        this.applyValues(this.allPropertiesHolder.getProperties());
    }

    private void applyValues(List<ConfigProperty<?>> list) {
        for (ConfigProperty<?> configProperty : list) {
            if (configProperty.getKey() != null) {
                this.originalProperties.put(configProperty.getKey(), configProperty.getValueAsString());
                if (configProperty instanceof SelectConfigProperty) {
                    SelectConfigProperty selectConfigProperty = (SelectConfigProperty)configProperty;
                    selectConfigProperty.setOriginalValue(selectConfigProperty.getValue());
                }
            }
            this.applyValues(configProperty.getChildProperties());
        }
    }
}

