/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.config.structure.model.client;

import com.inet.report.config.structure.model.Localizable;
import com.inet.report.config.structure.model.LocalizedMessageProvider;

public enum Unit implements Localizable
{
    INCH("unit.inch", 1440.0, false),
    POINT("unit.points", 20.0, false),
    CM("unit.cm", 566.9291338582677, true),
    MM("unit.mm", 56.69291338582677, true),
    TWIPS("unit.twips", 1.0, false),
    PIXEL("unit.pixel", 15.0, false);

    private String key;
    private double twipsPerUnit;

    private Unit(String string2, double d2, boolean bl2) {
        this.key = string2;
        this.twipsPerUnit = d2;
    }

    public int getTwips(double d2) {
        return Double.valueOf(Math.round(d2 * this.twipsPerUnit)).intValue();
    }

    public double getTwips() {
        return this.twipsPerUnit;
    }

    public double convertTwipsToUnit(int n2) {
        return (double)n2 / this.twipsPerUnit;
    }

    public String toString() {
        return this.key;
    }

    @Override
    public String toLocalizedString(LocalizedMessageProvider localizedMessageProvider) {
        return localizedMessageProvider.getMessage(this.key, new Object[0]);
    }

    public String getKey() {
        return this.key;
    }
}

