/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.config.structure.model.properties;

import com.inet.report.config.structure.model.ConfigCategory;
import com.inet.report.config.structure.model.ConfigKey;
import com.inet.report.config.structure.model.ConfigLink;
import com.inet.report.config.structure.model.condition.ConfigCondition;
import com.inet.report.config.structure.model.properties.InvalidTypeException;
import com.inet.report.config.structure.model.validator.async.ConfigValidator;
import com.inet.report.config.structure.model.validator.client.ClientValidator;
import com.inet.report.config.structure.util.ConfigUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public abstract class ConfigProperty<T extends Serializable>
implements Serializable,
Cloneable {
    public static final int VISIBILITY_STANDALONE = 1;
    public static final int VISIBILITY_SERVLET = 2;
    public static final int VISIBILITY_DESIGNER = 4;
    public static final int VISIBILITY_STANDALONE_SERVLET = 3;
    public static final int VISIBILITY_EVERYWHERE = 7;
    private ConfigKey key;
    private String label;
    private String tooltip;
    private ConfigCategory parent;
    private ConfigProperty<?> parentProperty;
    private int visibility = 3;
    private boolean needPlusLicense;
    private List<ConfigProperty<?>> childProperties = new ArrayList(0);
    private ConfigLink linkTo;
    private List<ClientValidator<T>> clientValidators = new ArrayList<ClientValidator<T>>(0);
    private ConfigCondition condition;
    private boolean needRestart;
    private transient List<ConfigValidator<T>> serverValidators = new ArrayList<ConfigValidator<T>>(0);
    private transient List<ConfigValidator<T>> asyncValidators = new ArrayList<ConfigValidator<T>>(0);
    private T value;

    protected ConfigProperty() {
    }

    public ConfigProperty(ConfigKey configKey) {
        this.key = configKey;
    }

    public String getKey() {
        if (this.key == null) {
            return null;
        }
        return this.key.getKey();
    }

    public ConfigKey getConfigKey() {
        return this.key;
    }

    public void setConfigKey(ConfigKey configKey) {
        this.key = configKey;
    }

    public void setLinkTo(ConfigLink configLink) {
        this.linkTo = configLink;
    }

    public ConfigLink getLinkTo() {
        return this.linkTo;
    }

    public void addConfigProperty(ConfigProperty<?> configProperty) {
        if (this.childProperties.contains(configProperty)) {
            throw new IllegalArgumentException("Property " + configProperty + " already added!");
        }
        if (configProperty.getKey() != null) {
            ConfigUtils.checkKeyUnique(configProperty, this.parent);
        }
        if (this.parent != null) {
            configProperty.setParent(this.parent);
        }
        this.childProperties.add(configProperty);
        configProperty.parentProperty = this;
    }

    public List<ConfigProperty<?>> getChildProperties() {
        return this.childProperties;
    }

    public List<ConfigValidator<T>> getServerValidators() {
        return this.serverValidators;
    }

    public void setServerValidators(List<ConfigValidator<T>> list) {
        this.serverValidators = list;
    }

    public List<ConfigValidator<T>> getAsyncValidators() {
        return this.asyncValidators;
    }

    public void setAsyncValidators(List<ConfigValidator<T>> list) {
        this.asyncValidators = list;
    }

    public void addAsyncValidator(ConfigValidator<T> configValidator) {
        this.asyncValidators.add(configValidator);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(String string) {
        this.tooltip = string;
    }

    public List<ClientValidator<T>> getClientValidators() {
        return this.clientValidators;
    }

    public void setClientValidators(List<ClientValidator<T>> list) {
        this.clientValidators = list;
    }

    public void addClientValidator(ClientValidator<T> clientValidator) {
        this.clientValidators.add(clientValidator);
    }

    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + (this.childProperties == null ? 0 : this.childProperties.hashCode());
        n2 = 31 * n2 + (this.clientValidators == null ? 0 : this.clientValidators.hashCode());
        n2 = 31 * n2 + (this.key == null ? 0 : this.key.hashCode());
        n2 = 31 * n2 + (this.linkTo == null ? 0 : this.linkTo.hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ConfigProperty configProperty = (ConfigProperty)object;
        if (this.childProperties == null ? configProperty.childProperties != null : !this.childProperties.equals(configProperty.childProperties)) {
            return false;
        }
        if (this.clientValidators == null ? configProperty.clientValidators != null : !this.clientValidators.equals(configProperty.clientValidators)) {
            return false;
        }
        if (this.key == null ? configProperty.key != null : !this.key.equals(configProperty.key)) {
            return false;
        }
        return !(this.linkTo == null ? configProperty.linkTo != null : !this.linkTo.equals(configProperty.linkTo));
    }

    public ConfigCondition getCondition() {
        return this.condition;
    }

    public void setCondition(ConfigCondition configCondition) {
        this.condition = configCondition;
    }

    public T getValue() {
        if (this.value == null) {
            return this.getDefaultValue();
        }
        return this.value;
    }

    public abstract void setStringValue(String var1) throws InvalidTypeException;

    public abstract String getValueAsString();

    public final void setValue(T t2) {
        this.value = t2;
    }

    public abstract T getDefaultValue();

    public void setParent(ConfigCategory configCategory) {
        this.parent = configCategory;
        for (ConfigProperty<?> configProperty : this.getChildProperties()) {
            configProperty.setParent(configCategory);
        }
    }

    public void setVisibility(int n2) {
        this.visibility = n2;
    }

    public int getVisibility() {
        return this.visibility;
    }

    public boolean isNeedPlusLicense() {
        return this.needPlusLicense;
    }

    public void setNeedPlusLicense(boolean bl2) {
        this.needPlusLicense = bl2;
    }

    public boolean isNeedRestart() {
        return this.needRestart;
    }

    public void setNeedRestart(boolean bl2) {
        this.needRestart = bl2;
    }

    public ConfigCategory getParentCategory() {
        return this.parent;
    }

    public ConfigProperty<?> getParentProperty() {
        return this.parentProperty;
    }

    public boolean hasChildWhichRequiresPlusLicense() {
        for (ConfigProperty<?> configProperty : this.childProperties) {
            if (!configProperty.isNeedPlusLicense() && !configProperty.hasChildWhichRequiresPlusLicense()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public String[] getExtraLabelKeys() {
        return null;
    }
}

