/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.config.structure.model.properties;

import com.inet.report.config.structure.model.ConfigKey;
import com.inet.report.config.structure.model.properties.InvalidTypeException;
import com.inet.report.config.structure.model.properties.NumberProperty;
import com.inet.report.config.structure.model.validator.client.ClientValidator;

public class FloatNumberProperty
extends NumberProperty {
    private FloatNumberProperty() {
        super(null);
    }

    public FloatNumberProperty(ConfigKey configKey) {
        super(configKey);
    }

    public FloatNumberProperty(ConfigKey configKey, ClientValidator<Number> clientValidator) {
        super(configKey, clientValidator);
    }

    @Override
    public void setStringValue(String string) throws InvalidTypeException {
        if (string == null) {
            this.setValue(null);
            return;
        }
        try {
            this.setValue(Double.valueOf(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidTypeException("error.type.number");
        }
    }

    @Override
    public Number getDefaultValue() {
        String string = this.getConfigKey().getDefault();
        if (string != null) {
            try {
                return Double.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }
}

