/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.config.structure.model.properties;

import com.inet.report.config.structure.model.ConfigKey;
import com.inet.report.config.structure.model.properties.ConfigProperty;
import com.inet.report.config.structure.model.properties.InvalidTypeException;
import com.inet.report.config.structure.model.validator.client.ClientValidator;

public class NumberProperty
extends ConfigProperty<Number> {
    private NumberProperty() {
    }

    public NumberProperty(ConfigKey configKey) {
        super(configKey);
    }

    public NumberProperty(ConfigKey configKey, ClientValidator<Number> clientValidator) {
        super(configKey);
        if (clientValidator != null) {
            this.addClientValidator(clientValidator);
        }
    }

    @Override
    public String getValueAsString() {
        Number number = (Number)this.getValue();
        if (number == null) {
            return null;
        }
        return number.toString();
    }

    @Override
    public void setStringValue(String string) throws InvalidTypeException {
        if (string == null || string.isEmpty()) {
            this.setValue(null);
            return;
        }
        try {
            this.setValue(Integer.valueOf(string));
        }
        catch (NumberFormatException numberFormatException) {
            try {
                this.setValue(Double.valueOf(string));
            }
            catch (NumberFormatException numberFormatException2) {
                throw new InvalidTypeException("error.type.number");
            }
        }
    }

    @Override
    public Number getDefaultValue() {
        String string = this.getConfigKey().getDefault();
        if (string != null) {
            try {
                return Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }
}

