/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.config.structure.model.validator.async;

import com.inet.report.config.structure.MsgAdmin;
import com.inet.report.config.structure.model.client.Unit;
import com.inet.report.config.structure.model.properties.ConfigProperty;
import com.inet.report.config.structure.model.validator.async.AsyncNumberRangeValidator;
import com.inet.report.i18n.Msg;

public class AsyncFontSizeRangeValidator
extends AsyncNumberRangeValidator {
    private AsyncFontSizeRangeValidator() {
        super(Integer.MIN_VALUE);
    }

    public AsyncFontSizeRangeValidator(int n2, int n3) {
        super(n2, n3);
    }

    public AsyncFontSizeRangeValidator(int n2) {
        super(n2);
    }

    @Override
    public String check(ConfigProperty<Number> configProperty) {
        Number number = configProperty.getValue();
        if (number == null) {
            return MsgAdmin.getInstance().getMsg("error.validator.range.null", Msg.getThreadLocale(), new Object[0]);
        }
        float f2 = number.floatValue();
        int n2 = Unit.PIXEL.getTwips(f2);
        if (n2 < this.getMin()) {
            return MsgAdmin.getInstance().getMsg("error.validator.range.min.twips", Msg.getThreadLocale(), this.getMin());
        }
        if (n2 > this.getMax()) {
            return MsgAdmin.getInstance().getMsg("error.validator.range.max.twips", Msg.getThreadLocale(), this.getMax());
        }
        return null;
    }
}

