/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.config.structure.model.validator.async;

import com.inet.report.config.structure.MsgAdmin;
import com.inet.report.config.structure.model.properties.ConfigProperty;
import com.inet.report.config.structure.model.validator.async.ConfigValidator;
import com.inet.report.i18n.Msg;

public class AsyncNumberRangeValidator
implements ConfigValidator<Number> {
    private int min = Integer.MIN_VALUE;
    private int max = Integer.MAX_VALUE;

    private AsyncNumberRangeValidator() {
    }

    public AsyncNumberRangeValidator(int n2, int n3) {
        if (n2 > n3) {
            int n4 = n2;
            n2 = n3;
            n3 = n4;
        }
        this.min = n2;
        this.max = n3;
    }

    public AsyncNumberRangeValidator(int n2) {
        this.min = n2;
    }

    public int getMax() {
        return this.max;
    }

    public int getMin() {
        return this.min;
    }

    @Override
    public String check(ConfigProperty<Number> configProperty) {
        Number number = configProperty.getValue();
        if (number == null) {
            return MsgAdmin.getInstance().getMsg("error.validator.range.null", Msg.getThreadLocale(), new Object[0]);
        }
        if (number.longValue() < (long)this.min) {
            return MsgAdmin.getInstance().getMsg("error.validator.range.min", Msg.getThreadLocale(), this.min);
        }
        if (number.longValue() > (long)this.max) {
            return MsgAdmin.getInstance().getMsg("error.validator.range.max", Msg.getThreadLocale(), this.max);
        }
        return null;
    }
}

