/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.config.structure.model.validator.async;

import com.inet.report.config.structure.MsgAdmin;
import com.inet.report.config.structure.model.properties.ConfigProperty;
import com.inet.report.config.structure.model.validator.async.ConfigValidator;
import com.inet.report.i18n.Msg;
import java.io.File;

public class DirectoryExistsValidator
implements ConfigValidator<String> {
    private boolean isMultiValue = false;
    private boolean useWorkDirectoryAsDefault = false;

    public DirectoryExistsValidator() {
    }

    public DirectoryExistsValidator(boolean bl2) {
        this(bl2, false);
    }

    public DirectoryExistsValidator(boolean bl2, boolean bl3) {
        this.isMultiValue = bl2;
        this.useWorkDirectoryAsDefault = bl3;
    }

    @Override
    public String check(ConfigProperty<String> configProperty) {
        String string = configProperty.getValue();
        if (this.isMultiValue) {
            String[] stringArray;
            StringBuilder stringBuilder = new StringBuilder();
            for (String string2 : stringArray = string.split("[,;]")) {
                if ((string2 = string2.trim()).isEmpty() || new File(string2).isDirectory()) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(string2);
            }
            if (stringBuilder.length() > 0) {
                return MsgAdmin.getInstance().getMsg("config.error.directorynotfound", Msg.getThreadLocale(), stringBuilder.toString());
            }
        } else if (!string.isEmpty()) {
            if (!new File(string).isDirectory()) {
                return MsgAdmin.getInstance().getMsg("config.error.directorynotfound", Msg.getThreadLocale(), string);
            }
        } else if (this.useWorkDirectoryAsDefault) {
            String string3 = "";
            File file = new File("gibtesnicht").getAbsoluteFile().getParentFile();
            if (file != null) {
                string3 = file.getAbsolutePath();
            }
            return MsgAdmin.getInstance().getMsg("config.error.emptyDirectory", Msg.getThreadLocale(), string3);
        }
        return null;
    }
}

