/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.config.structure.model.validator.async;

import com.inet.report.config.structure.MsgAdmin;
import com.inet.report.config.structure.model.properties.ConfigProperty;
import com.inet.report.config.structure.model.validator.async.ConfigValidator;
import com.inet.report.i18n.Msg;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;

public class LibDirectoryValidator
implements ConfigValidator<String> {
    @Override
    public String check(ConfigProperty<String> configProperty) {
        HashSet<String> hashSet = new HashSet<String>();
        String string = configProperty.getValue();
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : string.split(",")) {
            if ((string2 = string2.trim()).length() <= 0) continue;
            hashSet.add(string2);
        }
        for (String string3 : hashSet) {
            File file = new File(string3);
            if (file.isFile()) {
                if (string3.endsWith(".jar") || string3.endsWith(".zip") || string3.endsWith(".dll") || string3.endsWith(".exe")) continue;
                this.addPathToErrorString(stringBuilder, string3);
                continue;
            }
            if (file.isDirectory()) continue;
            if (string3.endsWith(".jar") || string3.endsWith(".zip") || string3.endsWith(".dll") || string3.endsWith(".exe")) {
                try {
                    new URL(string3);
                    continue;
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            this.addPathToErrorString(stringBuilder, string3);
        }
        if (stringBuilder.length() > 0) {
            return MsgAdmin.getInstance().getMsg("error.validator.libDirectories.notfound", Msg.getThreadLocale(), stringBuilder.toString());
        }
        return null;
    }

    private void addPathToErrorString(StringBuilder stringBuilder, String string) {
        if (stringBuilder.length() > 0) {
            stringBuilder.append(", ");
        }
        stringBuilder.append(string);
    }
}

