/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.config.structure.model.validator.async;

import com.inet.report.config.structure.MsgAdmin;
import com.inet.report.config.structure.model.properties.ConfigProperty;
import com.inet.report.config.structure.model.validator.async.ConfigValidator;
import com.inet.report.i18n.Msg;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;

public class LogFileValidator
implements ConfigValidator<String> {
    private static final long serialVersionUID = 1L;

    @Override
    public String check(ConfigProperty<String> configProperty) {
        String string = configProperty.getValue();
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        File file = new File(string = string.trim());
        if (file.isDirectory()) {
            return MsgAdmin.getInstance().getMsg("config.error.shouldNotBeADirectory", Msg.getThreadLocale(), string);
        }
        if (file.isFile()) {
            boolean bl2 = Files.isWritable(Paths.get(file.toURI()));
            if (!bl2) {
                return MsgAdmin.getInstance().getMsg("config.error.fileNotWriteable", Msg.getThreadLocale(), string);
            }
        } else {
            for (File file2 = file.getParentFile(); file2 != null; file2 = file2.getParentFile()) {
                if (!file2.exists()) continue;
                if (file2.isFile()) {
                    return MsgAdmin.getInstance().getMsg("config.error.notAValidPath", Msg.getThreadLocale(), file2.getAbsolutePath());
                }
                boolean bl3 = Files.isWritable(Paths.get(file.toURI()));
                if (bl3) continue;
            }
        }
        return null;
    }
}

