/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.config.structure.model.validator.client;

import com.inet.report.config.structure.model.client.Unit;
import com.inet.report.config.structure.model.properties.ConfigProperty;
import com.inet.report.config.structure.model.validator.client.NumberRangeValidator;
import com.inet.report.config.structure.model.validator.client.ValidationResult;

public class FontSizeRangeValidator
extends NumberRangeValidator {
    private FontSizeRangeValidator() {
        super(Integer.MIN_VALUE);
    }

    public FontSizeRangeValidator(int n2, int n3) {
        super(n2, n3);
    }

    public FontSizeRangeValidator(int n2) {
        super(n2);
    }

    @Override
    public ValidationResult check(ConfigProperty<Number> configProperty) {
        Number number = configProperty.getValue();
        if (number == null) {
            return new ValidationResult("error.validator.range.null");
        }
        float f2 = number.floatValue();
        int n2 = Unit.PIXEL.getTwips(f2);
        if (n2 < this.getMin()) {
            return new ValidationResult("error.validator.range.min.twips", this.getMin(), n2);
        }
        if (n2 > this.getMax()) {
            return new ValidationResult("error.validator.range.max.twips", this.getMax(), n2);
        }
        return null;
    }
}

