/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.config.structure.model.validator.client;

import com.inet.report.config.structure.model.properties.ConfigProperty;
import com.inet.report.config.structure.model.validator.client.ClientValidator;
import com.inet.report.config.structure.model.validator.client.ValidationResult;

public class InvalidCharacterValidator
implements ClientValidator<String> {
    private String invalidChars = null;
    private boolean isMultiValue = false;

    private InvalidCharacterValidator() {
    }

    public InvalidCharacterValidator(String string) {
        this(string, false);
    }

    public InvalidCharacterValidator(String string, boolean bl2) {
        this.invalidChars = string;
        this.isMultiValue = bl2;
    }

    @Override
    public ValidationResult check(ConfigProperty<String> configProperty) {
        String string = configProperty.getValue();
        if (string == null || string.length() == 0) {
            return null;
        }
        if (this.isMultiValue) {
            StringBuilder stringBuilder = InvalidCharacterValidator.checkCharacterMultiValue(string, this.invalidChars);
            if (stringBuilder.length() > 0) {
                return new ValidationResult("config.error.invalidCharacters.multi", stringBuilder);
            }
        } else {
            String string2 = InvalidCharacterValidator.checkCharactersSingleValue(string, this.invalidChars);
            if (string2.length() > 0) {
                return new ValidationResult("config.error.invalidCharacters", string, string2);
            }
        }
        return null;
    }

    public static StringBuilder checkCharacterMultiValue(String string, String string2) {
        String[] stringArray;
        StringBuilder stringBuilder = new StringBuilder();
        for (String string3 : stringArray = string.split("[,;]")) {
            String string4;
            if ((string3 = string3.trim()).isEmpty() || (string4 = InvalidCharacterValidator.checkCharactersSingleValue(string3, string2)) == null || string4.length() <= 0) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("\"" + string3 + "\":  '" + string4 + "'");
        }
        return stringBuilder;
    }

    public static String checkCharactersSingleValue(String string, String string2) {
        char[] cArray = string.toCharArray();
        String string3 = new String();
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            if (string2.indexOf(cArray[i2]) < 0 && cArray[i2] >= ' ' && (cArray[i2] <= '~' || cArray[i2] >= '\u00a0')) continue;
            string3 = string3.concat(String.valueOf(cArray[i2]));
        }
        return string3;
    }
}

