/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.config.structure.model.validator.client;

import com.inet.report.config.structure.model.properties.ConfigProperty;
import com.inet.report.config.structure.model.validator.client.ClientValidator;
import com.inet.report.config.structure.model.validator.client.ValidationResult;

public class NumberRangeValidator
implements ClientValidator<Number> {
    private int min = Integer.MIN_VALUE;
    private int max = Integer.MAX_VALUE;

    private NumberRangeValidator() {
    }

    public NumberRangeValidator(int n2, int n3) {
        if (n2 > n3) {
            int n4 = n2;
            n2 = n3;
            n3 = n4;
        }
        this.min = n2;
        this.max = n3;
    }

    public NumberRangeValidator(int n2) {
        this.min = n2;
    }

    public int getMax() {
        return this.max;
    }

    public int getMin() {
        return this.min;
    }

    @Override
    public ValidationResult check(ConfigProperty<Number> configProperty) {
        Number number = configProperty.getValue();
        if (number == null) {
            return new ValidationResult("error.validator.range.null");
        }
        if (number.longValue() < (long)this.min) {
            return new ValidationResult("error.validator.range.min", this.min);
        }
        if (number.longValue() > (long)this.max) {
            return new ValidationResult("error.validator.range.max", this.max);
        }
        return null;
    }
}

