/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.config.structure.util;

import com.inet.report.config.structure.model.ConfigCategory;
import com.inet.report.config.structure.model.ConfigKey;
import com.inet.report.config.structure.model.properties.ConfigProperty;
import com.inet.report.config.structure.model.properties.SelectConfigProperty;
import com.inet.report.config.structure.model.properties.SelectOption;
import com.inet.report.config.structure.util.Runner;
import com.inet.report.config.structure.util.a;
import com.inet.report.permissions.SystemPermissions;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public class ConfigUtils {
    private static final int KEY_LENGTH = 16;
    private static final String[] HEX_VALUE = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};
    private static final String ENCRYPT_XOR = "00";

    public static void runThroughProperties(List<ConfigProperty<?>> list, Runner runner) {
        for (ConfigProperty<?> configProperty : list) {
            ConfigUtils.runThroughProperty(configProperty, runner);
        }
    }

    public static void runThroughProperty(ConfigProperty<?> configProperty, Runner runner) {
        runner.run(configProperty);
        for (ConfigProperty<?> configProperty2 : configProperty.getChildProperties()) {
            ConfigUtils.runThroughProperty(configProperty2, runner);
        }
    }

    public static void checkKeyUnique(ConfigProperty<?> configProperty, ConfigCategory configCategory) {
        if (configCategory != null) {
            ConfigUtils.runThroughProperties(configCategory.getProperties(), new a(configProperty));
            List<ConfigProperty<?>> list = configProperty.getChildProperties();
            if (list != null) {
                for (ConfigProperty<?> configProperty2 : list) {
                    ConfigUtils.checkKeyUnique(configProperty2, configCategory);
                }
            }
        }
    }

    public static boolean isEqual(Object object, Object object2) {
        if (object == null && object2 == null) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        return object.equals(object2);
    }

    public static <X extends Serializable> String createReadableDefaultValue(ConfigProperty<X> configProperty) {
        X x2 = configProperty.getDefaultValue();
        String string = null;
        if (x2 != null) {
            SelectOption<Object> selectOption;
            Iterator<SelectOption<Object>> iterator;
            Object object;
            Object object2;
            string = x2.toString();
            if (configProperty instanceof SelectConfigProperty && (object2 = ((SelectConfigProperty)(object = (SelectConfigProperty)configProperty)).getOptions()) != null) {
                iterator = object2.iterator();
                while (iterator.hasNext()) {
                    selectOption = iterator.next();
                    if (!x2.equals(selectOption.getValue())) continue;
                    return selectOption.getLabel();
                }
            }
            if (x2 instanceof List) {
                object = (List)x2;
                object2 = new StringBuilder();
                if (object.size() > 0) {
                    iterator = object.iterator();
                    while (iterator.hasNext()) {
                        selectOption = iterator.next();
                        if (((StringBuilder)object2).length() > 0) {
                            ((StringBuilder)object2).append(", ");
                        }
                        ((StringBuilder)object2).append(((Object)selectOption).toString());
                    }
                }
                return ((StringBuilder)object2).toString();
            }
            if (x2 instanceof SystemPermissions) {
                return null;
            }
        }
        return string;
    }

    public static String decrypt(String string) {
        if (string == null) {
            return "";
        }
        if (string.startsWith(ENCRYPT_XOR)) {
            int n2;
            int n3 = ENCRYPT_XOR.length();
            byte[] byArray = ConfigUtils.unhex(string.substring(n3, n3 += 32));
            byte[] byArray2 = ConfigUtils.unhex(string.substring(n3));
            byte by2 = 0;
            for (n2 = 0; n2 < byArray2.length; ++n2) {
                by2 = byArray2[n2] = (byte)(byArray2[n2] ^ by2 ^ byArray[n2 % 15]);
            }
            n2 = (byArray2[0] & 0xFF) + ((byArray2[1] & 0xFF) << 8);
            try {
                return new String(byArray2, 2, n2, "UTF8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return new String(byArray2, 2, n2);
            }
        }
        return string;
    }

    private static byte[] unhex(String string) {
        byte[] byArray = new byte[string.length() / 2];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray[i2] = (byte)Integer.parseInt(string.substring(2 * i2, 2 * i2 + 2), 16);
        }
        return byArray;
    }

    public static String encrypt(String string) {
        int n2;
        if (string == null) {
            return "";
        }
        byte[] byArray = new byte[16];
        Random random = new Random();
        random.nextBytes(byArray);
        byte[] byArray2 = ConfigUtils.getBytesUTF8(string);
        byte[] byArray3 = new byte[byArray2.length + 2 + 15 & 0x7FFFFFF0];
        random.nextBytes(byArray3);
        for (n2 = 0; n2 < 2; ++n2) {
            byArray3[n2] = (byte)(byArray2.length >> n2 * 8);
        }
        System.arraycopy(byArray2, 0, byArray3, 2, byArray2.length);
        n2 = 0;
        for (int i2 = 0; i2 < byArray3.length; ++i2) {
            int n3 = byArray3[i2];
            byArray3[i2] = (byte)(byArray3[i2] ^ n2 ^ byArray[i2 % 15]);
            n2 = n3;
        }
        return ENCRYPT_XOR + ConfigUtils.hex(byArray) + ConfigUtils.hex(byArray3);
    }

    private static String hex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            stringBuffer.append(HEX_VALUE[byArray[i2] >> 4 & 0xF]);
            stringBuffer.append(HEX_VALUE[byArray[i2] & 0xF]);
        }
        return stringBuffer.toString();
    }

    private static byte[] getBytesUTF8(String string) {
        if (string == null) {
            return null;
        }
        try {
            return string.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string.getBytes();
        }
    }

    public static ConfigProperty<?> findProperty(ConfigCategory configCategory, ConfigKey configKey) {
        return ConfigUtils.findProperty(configCategory.getProperties(), configKey);
    }

    private static ConfigProperty<?> findProperty(List<ConfigProperty<?>> list, ConfigKey configKey) {
        String string = configKey.getKey();
        for (ConfigProperty<?> configProperty : list) {
            ConfigProperty<?> configProperty2;
            if (configProperty.getKey().equals(string)) {
                return configProperty;
            }
            List<ConfigProperty<?>> list2 = configProperty.getChildProperties();
            if (list2 == null || list2.isEmpty() || (configProperty2 = ConfigUtils.findProperty(configProperty.getChildProperties(), configKey)) == null) continue;
            return configProperty2;
        }
        return null;
    }
}

