/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.database;

import com.inet.report.DatabaseConfiguration;
import com.inet.report.DatabaseField;
import com.inet.report.ReportException;
import com.inet.report.TableSource;
import com.inet.report.database.DataFactory;
import com.inet.report.database.TableData;
import java.util.ArrayList;
import javax.annotation.Nonnull;

public abstract class BaseDataFactory
implements DataFactory {
    private DatabaseConfiguration aXd = DatabaseConfiguration.getDefault();

    protected BaseDataFactory() {
    }

    @Override
    public boolean getReportDataPerInstance() {
        return false;
    }

    @Override
    public DatabaseConfiguration getConfiguration() {
        return this.aXd;
    }

    @Override
    public void setConfiguration(@Nonnull DatabaseConfiguration databaseConfiguration) {
        this.aXd = databaseConfiguration;
    }

    @Override
    public TableData getTableSourceData(@Nonnull TableSource tableSource) throws ReportException {
        DatabaseField[] databaseFieldArray;
        ArrayList<DatabaseField> arrayList = new ArrayList<DatabaseField>();
        for (DatabaseField databaseField : databaseFieldArray = tableSource.getDatabaseFields()) {
            if (databaseField.getReferenceHolderCount() <= 0) continue;
            arrayList.add(databaseField);
        }
        return this.getTableSourceData(tableSource, arrayList);
    }

    protected TableData getTableSourceData(@Nonnull TableSource tableSource, @Nonnull ArrayList<DatabaseField> arrayList) throws ReportException {
        throw new ReportException("You need to implement getTableSourceData", 0);
    }
}

