/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.database;

import com.inet.report.BaseUtils;
import com.inet.report.DatabaseTables;
import com.inet.report.Datasource;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.TableSource;
import com.inet.report.database.BaseDataFactory;
import com.inet.report.database.ColumnInfo;
import com.inet.report.database.TableData;
import com.inet.report.database.TableSourceInfo;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public abstract class JdbcData
extends BaseDataFactory {
    @Override
    @Nonnull
    public TableData getTableSourceData(TableSource tableSource) throws ReportException {
        try {
            return new TableData(tableSource.getResultSet());
        }
        catch (SQLException sQLException) {
            throw ReportExceptionFactory.createReportExceptionWithCause(sQLException);
        }
    }

    @Override
    @Nonnull
    public Map<String, TableSourceInfo> getTableSourceInfos(Datasource datasource, String string) throws ReportException {
        HashMap<String, TableSourceInfo> hashMap = new HashMap<String, TableSourceInfo>();
        try {
            String string2;
            String string3;
            String string4;
            ResultSet resultSet = this.getTables(datasource, string);
            boolean bl2 = resultSet.next();
            if (!bl2) {
                resultSet.close();
                resultSet = this.getTables(datasource, null);
                bl2 = resultSet.next();
            }
            if (bl2) {
                do {
                    int n2;
                    string4 = resultSet.getString(1);
                    string3 = resultSet.getString(2);
                    string2 = resultSet.getString(3);
                    String string5 = resultSet.getString(4);
                    if ("VIEW".equals(string5)) {
                        n2 = 10;
                    } else if ("TABLE".equals(string5)) {
                        n2 = 0;
                    } else {
                        if (!"SYSTEM TABLE".equals(string5)) continue;
                        n2 = 1;
                    }
                    TableSourceInfo tableSourceInfo = new TableSourceInfo(string4, string3, string2, n2);
                    hashMap.put(tableSourceInfo.getName(), tableSourceInfo);
                } while (resultSet.next());
            }
            resultSet.close();
            try {
                resultSet = this.getProcedures(datasource, string);
                while (resultSet.next()) {
                    int n3;
                    string4 = resultSet.getString(1);
                    TableSourceInfo tableSourceInfo = new TableSourceInfo(string4, string3 = resultSet.getString(2), string2 = resultSet.getString(3), 20, n3 = resultSet.getInt(8));
                    if (hashMap.get(tableSourceInfo.getName()) != null) continue;
                    hashMap.put(tableSourceInfo.getName(), tableSourceInfo);
                }
                resultSet.close();
            }
            catch (Exception exception) {
                BaseUtils.info("procedures not supported by this datasource: " + exception);
            }
        }
        catch (SQLException sQLException) {
            throw ReportExceptionFactory.createReportExceptionWithCause(sQLException);
        }
        return hashMap;
    }

    @Override
    public List<ColumnInfo> getColumns(Datasource datasource, String string, String string2, String string3, int n2) throws ReportException {
        ArrayList<ColumnInfo> arrayList = new ArrayList<ColumnInfo>();
        try {
            switch (n2) {
                case 1: {
                    ResultSet resultSet = this.getColumns(datasource, string, string2, string3);
                    while (resultSet.next()) {
                        String string4 = resultSet.getString(4);
                        int n3 = DatabaseTables.mapSqlTypeToCCType(resultSet.getInt(5));
                        arrayList.add(new ColumnInfo(string4, n3));
                    }
                    resultSet.close();
                    break;
                }
                case 2: {
                    ResultSet resultSet = this.getProcedureColumns(datasource, string, string2, string3);
                    while (resultSet.next()) {
                        String string5 = resultSet.getString(3);
                        if (string5 != null && !string5.equals(string3)) continue;
                        String string6 = resultSet.getString(4);
                        int n4 = resultSet.getInt(5);
                        int n5 = resultSet.getInt(6);
                        int n6 = resultSet.getInt(10);
                        int n7 = DatabaseTables.mapSqlTypeToCCType(n5);
                        arrayList.add(new ColumnInfo(string6, n7, n4, n5, n6));
                    }
                    resultSet.close();
                }
            }
            return arrayList;
        }
        catch (SQLException sQLException) {
            throw ReportExceptionFactory.createReportExceptionWithCause(sQLException);
        }
    }

    protected abstract ResultSet getTables(Datasource var1, String var2) throws SQLException, ReportException;

    protected abstract ResultSet getProcedures(Datasource var1, String var2) throws SQLException, ReportException;

    protected abstract ResultSet getColumns(Datasource var1, String var2, String var3, String var4) throws SQLException, ReportException;

    protected abstract ResultSet getProcedureColumns(Datasource var1, String var2, String var3, String var4) throws SQLException, ReportException;
}

