/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.database;

import com.inet.report.BaseUtils;
import com.inet.report.DatabaseField;
import com.inet.report.Datasource;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.TableSource;
import com.inet.report.config.datasource.DataSourceConfiguration;
import com.inet.report.database.BaseDataFactory;
import com.inet.report.database.ColumnInfo;
import com.inet.report.database.TableData;
import com.inet.report.database.TableSourceInfo;
import com.inet.report.database.a;
import com.inet.report.i18n.ErrorCode;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.naming.AuthenticationException;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.SizeLimitExceededException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;

public class LdapDataFactory
extends BaseDataFactory {
    private String url;
    private static final String[] aXf = new String[]{"namingContexts"};

    @Override
    @Nonnull
    public TableData getTableSourceData(@Nonnull TableSource tableSource, ArrayList<DatabaseField> arrayList) throws ReportException {
        int n2 = arrayList.size();
        String[] stringArray = new String[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            stringArray[i2] = arrayList.get(i2).getShortName();
        }
        String[] stringArray2 = a.a(this.getConfiguration(), tableSource.getDatabaseIdentifier());
        Datasource datasource = tableSource.getDatasource();
        DirContext dirContext = this.i(datasource);
        try {
            if (stringArray2[1] != null) {
                dirContext = (DirContext)dirContext.lookup(stringArray2[1]);
            }
            NamingEnumeration<SearchResult> namingEnumeration = dirContext.search(stringArray2[2], null, stringArray);
            ArrayList<Object[]> arrayList2 = new ArrayList<Object[]>();
            while (namingEnumeration.hasMoreElements()) {
                SearchResult searchResult = namingEnumeration.next();
                Attributes attributes = searchResult.getAttributes();
                Object[] objectArray = new Object[n2];
                for (int i3 = 0; i3 < n2; ++i3) {
                    Attribute attribute = attributes.get(stringArray[i3]);
                    if (attribute == null || attribute.size() != 1) continue;
                    objectArray[i3] = attribute.get(0);
                }
                arrayList2.add(objectArray);
            }
            return new TableData(stringArray, arrayList2);
        }
        catch (Exception exception) {
            throw ReportExceptionFactory.createReportExceptionWithCause(exception);
        }
    }

    @Override
    @Nonnull
    public List<ColumnInfo> getColumns(@Nonnull Datasource datasource, String string, String string2, String string3, int n2) throws ReportException {
        ArrayList<ColumnInfo> arrayList;
        block7: {
            arrayList = new ArrayList<ColumnInfo>();
            DirContext dirContext = this.i(datasource);
            try {
                NamingEnumeration<SearchResult> namingEnumeration;
                if (string2 != null) {
                    dirContext = (DirContext)dirContext.lookup(string2);
                }
                if (!(namingEnumeration = dirContext.search(string3, null)).hasMoreElements()) break block7;
                SearchResult searchResult = namingEnumeration.next();
                NamingEnumeration<? extends Attribute> namingEnumeration2 = searchResult.getAttributes().getAll();
                try {
                    while (namingEnumeration2.hasMoreElements()) {
                        Attribute attribute = namingEnumeration2.next();
                        ColumnInfo columnInfo = new ColumnInfo(attribute.getID(), 11);
                        arrayList.add(columnInfo);
                    }
                }
                catch (SizeLimitExceededException sizeLimitExceededException) {
                    if (BaseUtils.isDebug()) {
                        BaseUtils.printStackTrace(sizeLimitExceededException);
                    }
                }
            }
            catch (Exception exception) {
                throw ReportExceptionFactory.createReportExceptionWithCause(exception);
            }
        }
        return arrayList;
    }

    @Override
    @Nonnull
    public Map<String, TableSourceInfo> getTableSourceInfos(@Nonnull Datasource datasource, String string) throws ReportException {
        HashMap<String, TableSourceInfo> hashMap = new HashMap<String, TableSourceInfo>();
        InitialLdapContext initialLdapContext = this.i(datasource);
        try {
            Object object;
            Serializable serializable;
            URI uRI = new URI(this.url);
            String string2 = uRI.getPath();
            ArrayList<String> arrayList = new ArrayList<String>();
            if (string2 == null || string2.isEmpty() || string2.equals("/")) {
                serializable = initialLdapContext.getAttributes("", aXf);
                Attribute attribute = serializable.get(aXf[0]);
                int n2 = attribute.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    object = attribute.get(i2);
                    if (object == null) continue;
                    arrayList.add(object.toString());
                }
            } else {
                arrayList.add("");
            }
            serializable = null;
            for (int i3 = 0; i3 < arrayList.size(); ++i3) {
                String string3 = (String)arrayList.get(i3);
                NamingEnumeration<NameClassPair> namingEnumeration = initialLdapContext.list(string3);
                try {
                    while (namingEnumeration.hasMoreElements()) {
                        object = namingEnumeration.next();
                        TableSourceInfo tableSourceInfo = new TableSourceInfo(null, string3, ((NameClassPair)object).getName(), 0);
                        hashMap.put(tableSourceInfo.getName(), tableSourceInfo);
                    }
                    continue;
                }
                catch (NamingException namingException) {
                    serializable = namingException;
                    if (!BaseUtils.isDebug()) continue;
                    BaseUtils.printStackTrace((Throwable)serializable);
                }
            }
            if (hashMap.size() == 0 && serializable != null) {
                throw serializable;
            }
        }
        catch (Exception exception) {
            throw ReportExceptionFactory.createReportExceptionWithCause(exception);
        }
        return hashMap;
    }

    @Nonnull
    private InitialLdapContext i(@Nonnull Datasource datasource) throws ReportException {
        Object object;
        DataSourceConfiguration dataSourceConfiguration = datasource.getDataSourceConfiguration();
        if (dataSourceConfiguration == null) {
            throw new IllegalArgumentException();
        }
        this.url = dataSourceConfiguration.getProperty("ldapurl");
        if (this.url.isEmpty()) {
            object = System.getenv("LOGONSERVER");
            this.url = object != null ? "ldap:" + ((String)object).replace('\\', '/') : "ldap://localhost:389";
        }
        object = new Hashtable();
        ((Hashtable)object).put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        ((Hashtable)object).put("java.naming.provider.url", this.url);
        ((Hashtable)object).put("java.naming.security.authentication", "simple");
        ((Hashtable)object).put("java.naming.security.principal", dataSourceConfiguration.getUser());
        ((Hashtable)object).put("java.naming.security.credentials", dataSourceConfiguration.getPassword());
        ((Hashtable)object).put("java.naming.referral", "follow");
        try {
            return new InitialLdapContext((Hashtable<?, ?>)object, null);
        }
        catch (AuthenticationException authenticationException) {
            throw ReportExceptionFactory.createReportExceptionWithCause(authenticationException, ErrorCode.errorInLoginConfiguration, new Object[0]);
        }
        catch (NamingException namingException) {
            throw ReportExceptionFactory.createReportExceptionWithCause(namingException);
        }
    }
}

