/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.database.beans;

import com.inet.report.BaseUtils;
import com.inet.report.database.beans.BeanDataSourceManager;
import com.inet.report.database.beans.TransferServletException;
import com.inet.report.dw;
import com.inet.report.i18n.Msg;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TransferServlet
extends HttpServlet {
    private Hashtable aXr = new Hashtable();

    private BeanDataSourceManager cU(String string) throws TransferServletException {
        try {
            dw.sw();
            BeanDataSourceManager beanDataSourceManager = (BeanDataSourceManager)this.aXr.get(string);
            if (beanDataSourceManager == null) {
                Class clazz = BaseUtils.classForName(string);
                beanDataSourceManager = (BeanDataSourceManager)clazz.newInstance();
                this.aXr.put(string, beanDataSourceManager);
            }
            return beanDataSourceManager;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.log(classNotFoundException.getMessage(), classNotFoundException);
            throw new TransferServletException("Class " + string + " not found", classNotFoundException);
        }
        catch (Exception exception) {
            this.log(exception.getMessage(), exception);
            throw new TransferServletException("Exception by Manager Class :" + string, exception);
        }
    }

    @Override
    public synchronized void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Msg.setThreadLocale(httpServletRequest);
        String string = httpServletRequest.getParameter("manager_classname");
        String string2 = httpServletRequest.getParameter("method_name");
        String string3 = httpServletRequest.getParameter("bean_user");
        String string4 = BaseUtils.decrypt(httpServletRequest.getParameter("bean_password"));
        if (string == null) {
            this.c(httpServletRequest, httpServletResponse);
        } else {
            BeanDataSourceManager beanDataSourceManager;
            try {
                beanDataSourceManager = this.cU(string);
            }
            catch (TransferServletException transferServletException) {
                this.c(httpServletRequest, httpServletResponse, transferServletException);
                return;
            }
            if ("all_classnames".equalsIgnoreCase(string2)) {
                try {
                    String[] stringArray = beanDataSourceManager.getAllBeanClassNames(string3, string4);
                    this.c(httpServletRequest, httpServletResponse, stringArray);
                }
                catch (TransferServletException transferServletException) {
                    this.c(httpServletRequest, httpServletResponse, transferServletException);
                }
            } else if ("bean_data".equalsIgnoreCase(string2)) {
                String string5 = httpServletRequest.getParameter("bean_classname");
                String string6 = httpServletRequest.getParameter("bean_parameter");
                if (string5 == null) {
                    TransferServletException transferServletException = new TransferServletException("No Java Bean class name specified for getBeanData()", null);
                    this.c(httpServletRequest, httpServletResponse, transferServletException);
                    return;
                }
                try {
                    List list = null;
                    list = string6 == null ? beanDataSourceManager.getBeanData(string5, string3, string4) : beanDataSourceManager.getBeanData(string5, string6, string3, string4);
                    this.c(httpServletRequest, httpServletResponse, list);
                }
                catch (TransferServletException transferServletException) {
                    this.c(httpServletRequest, httpServletResponse, transferServletException);
                }
            } else {
                TransferServletException transferServletException = new TransferServletException("Unknown method \"" + string2 + "\"", null);
                this.c(httpServletRequest, httpServletResponse, transferServletException);
                return;
            }
        }
    }

    private void c(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        httpServletResponse.setContentType("text/html");
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.print("<HTML><BODY><H3>Request OK !</H3></BODY></HTML>\n");
    }

    private void c(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object object) throws IOException {
        httpServletResponse.setContentType("application/x-java-serialized-object");
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(servletOutputStream);
        try {
            objectOutputStream.writeObject(object);
        }
        catch (NotSerializableException notSerializableException) {
            TransferServletException transferServletException = new TransferServletException("Not serializable", notSerializableException);
            this.c(httpServletRequest, httpServletResponse, transferServletException);
            return;
        }
        objectOutputStream.flush();
        objectOutputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        super.destroy();
        Hashtable hashtable = this.aXr;
        synchronized (hashtable) {
            Enumeration enumeration = this.aXr.elements();
            while (enumeration.hasMoreElements()) {
                BeanDataSourceManager beanDataSourceManager = (BeanDataSourceManager)enumeration.nextElement();
                beanDataSourceManager.destroy();
            }
            this.aXr.clear();
        }
    }
}

