/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.filechooser.model.local;

import com.inet.lib.core.OS;
import com.inet.report.filechooser.directorytree.x;
import com.inet.report.filechooser.i18n.Msg;
import com.inet.report.filechooser.model.IFile;
import com.inet.report.filechooser.model.IFolder;
import com.inet.report.filechooser.model.ILocation;
import com.inet.report.filechooser.model.b;
import com.inet.report.filechooser.model.local.LocalFile;
import com.inet.report.filechooser.model.local.LocalLocation;
import com.inet.report.filechooser.model.local.c;
import com.inet.report.filechooser.model.local.d;
import com.inet.report.filechooser.model.local.e;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import sun.awt.shell.ShellFolder;

public class LocalFolder
implements IFolder {
    private final File beS;
    private final LocalFolder beM;
    private final LocalLocation beO;
    private List<IFolder> beT;
    private List<IFile> aPE;
    private Icon icon;
    private Icon beQ;
    private int state;
    private String displayName = null;
    private String beU = null;
    public static final int TYPE_UNDEFINED = 0;
    public static final int TYPE_DESKTOP = 1;
    public static final int TYPE_PERSONAL = 2;
    public static final int TYPE_ADDITIONAL = OS.isWindows() ? 4 : 3;
    public static final int TYPE_DRIVE = OS.isWindows() ? 3 : 4;
    public static final int TYPE_NETWORK = 5;
    private int type = 0;
    private b beV;

    public LocalFolder(File file, LocalFolder localFolder, LocalLocation localLocation) {
        this.beS = file;
        this.beM = localFolder;
        this.beO = localLocation;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n2) {
        this.type = n2;
    }

    @Override
    public ILocation getLocation() {
        return this.beO;
    }

    @Override
    public String getDisplayName() {
        if (this.displayName == null) {
            if (SwingUtilities.isEventDispatchThread()) {
                com.inet.report.filechooser.model.local.b b2 = new com.inet.report.filechooser.model.local.b(this);
                if (this.beO.getNameAndIconLoader() == null) {
                    this.beO.setAndStartNameAndIconLoader(new x());
                }
                this.beO.getNameAndIconLoader().b(b2);
                if (this.beU != null) {
                    return this.beU;
                }
                return this.getName();
            }
            if (this.beU != null) {
                return this.beU;
            }
            if (this.beS.getAbsolutePath().equals("/")) {
                this.displayName = Msg.getMsg("location.local.filesystem");
            } else {
                JFileChooser jFileChooser = this.beO.getFileChooser();
                if (jFileChooser != null) {
                    try {
                        this.displayName = jFileChooser.getName(this.beS);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            if (this.displayName == null) {
                this.displayName = this.getName();
            }
            this.beU = this.displayName;
        }
        return this.displayName;
    }

    @Override
    public String getName() {
        return this.beS.getName();
    }

    @Override
    public int getRights() {
        int n2 = 1;
        if (this.beS.canRead()) {
            n2 += 4;
        }
        if (this.beS.canWrite()) {
            n2 += 2;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IFile> getFiles() {
        if (this.aPE == null) {
            File[] fileArray = this.beS.listFiles(new c(this));
            LocalFolder localFolder = this;
            synchronized (localFolder) {
                if (this.aPE == null) {
                    this.aPE = new ArrayList<IFile>();
                    if (fileArray != null) {
                        for (File file : fileArray) {
                            this.aPE.add(new LocalFile(file, this, this.beO));
                        }
                    }
                }
            }
        }
        return this.aPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IFolder> getFolders() {
        JFileChooser jFileChooser = this.beO.getFileChooser();
        if (this.beT == null) {
            File[] fileArray;
            File[] fileArray2 = null;
            if (this.beS instanceof ShellFolder && !(fileArray = (File[])this.beS).isFileSystem()) {
                fileArray2 = fileArray.listFiles(false);
            }
            fileArray = this.beS.listFiles(new d(this, jFileChooser));
            LocalFolder localFolder = this;
            synchronized (localFolder) {
                if (this.beT == null) {
                    this.beT = new ArrayList<IFolder>();
                    if (fileArray2 != null) {
                        for (File file : fileArray2) {
                            this.beT.add(new LocalFolder(file, this, this.beO));
                        }
                    }
                    if (fileArray != null) {
                        for (File file : fileArray) {
                            this.beT.add(new LocalFolder(file, this, this.beO));
                        }
                    }
                }
            }
        }
        return this.beT;
    }

    @Override
    public Icon getIcon(boolean bl2, boolean bl3) {
        if (this.icon != null) {
            return this.icon;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            e e2 = new e(this);
            if (this.beO.getNameAndIconLoader() == null) {
                this.beO.setAndStartNameAndIconLoader(new x());
            }
            this.beO.getNameAndIconLoader().b(e2);
            if (this.beQ != null) {
                return this.beQ;
            }
            this.icon = UIManager.getIcon("FileView.directoryIcon");
            if (this.icon == null) {
                this.icon = UIManager.getIcon("Tree.closedIcon");
            }
            return this.icon;
        }
        JFileChooser jFileChooser = this.beO.getFileChooser();
        if (jFileChooser != null) {
            try {
                this.icon = jFileChooser.getIcon(this.beS);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.icon == null) {
            this.icon = UIManager.getIcon("FileView.directoryIcon");
        }
        if (this.icon == null) {
            this.icon = UIManager.getIcon("Tree.closedIcon");
        }
        this.beQ = this.icon;
        return this.icon;
    }

    @Override
    public IFolder getParent() {
        return this.beM;
    }

    @Override
    public String getAbsolutePath() {
        return this.beS.getAbsolutePath();
    }

    @Override
    public String getRelativePath() {
        return this.beS.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCache() {
        LocalFolder localFolder = this;
        synchronized (localFolder) {
            if (this.getType() == 5 && (this.getState() == 5 || this.getState() == 3)) {
                this.aPE = null;
                return;
            }
            this.setState(0);
            this.beT = null;
            this.icon = null;
            this.aPE = null;
        }
    }

    @Override
    public boolean isInitialzed() {
        return true;
    }

    public boolean equals(Object object) {
        if (object instanceof LocalFolder) {
            return this.getAbsolutePath().equals(((LocalFolder)object).getAbsolutePath());
        }
        return super.equals(object);
    }

    public int hashCode() {
        return this.beS.hashCode();
    }

    @Override
    public void setState(int n2) {
        this.state = n2;
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public IFolder getRoot() {
        IFolder iFolder = this;
        while (iFolder.getParent() != null) {
            iFolder = iFolder.getParent();
        }
        return iFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IFile createFile(String string, InputStream inputStream) throws IllegalArgumentException, IOException {
        if (string == null || inputStream == null) {
            throw new IllegalArgumentException("Name or content have not to be null");
        }
        File file = new File(this.beS, string);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            byte[] byArray = new byte[4096];
            int n2 = 0;
            while ((n2 = inputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n2);
            }
            fileOutputStream.flush();
        }
        finally {
            fileOutputStream.close();
            inputStream.close();
        }
        return new LocalFile(file, this, this.beO);
    }

    @Override
    public IFolder createFolder(String string) throws IllegalArgumentException, IOException {
        if (string == null) {
            throw new IllegalArgumentException("Name have not to be null");
        }
        File file = new File(this.beS, string);
        if (file.isDirectory()) {
            throw new IllegalArgumentException("Folder with the name '" + string + "' already exists");
        }
        if (!file.mkdir()) {
            throw new IOException("Folder with name '" + string + "' could not be created");
        }
        return new LocalFolder(file, this, this.beO);
    }

    @Override
    public IFolder getFolder(String string) {
        File file = new File(this.beS, string);
        if (file.isDirectory()) {
            boolean bl2;
            JFileChooser jFileChooser = this.beO.getFileChooser();
            boolean bl3 = bl2 = jFileChooser == null ? true : jFileChooser.isTraversable(file);
            if (bl2) {
                return new LocalFolder(file, this, this.beO);
            }
        }
        return null;
    }

    @Override
    public IFile getFile(String string) {
        File file = new File(this.beS, string);
        if (file.isFile()) {
            return new LocalFile(file, this, this.beO);
        }
        return null;
    }

    @Override
    public boolean rename(String string) {
        this.displayName = null;
        return this.beS.renameTo(new File(this.beS.getParentFile(), string));
    }

    @Override
    public boolean delete() {
        return this.beS.delete();
    }

    public String toString() {
        return this.getDisplayName();
    }

    public File getSystemFolder() {
        return this.beS;
    }

    @Override
    public void setFolderChangedListener(b b2) {
        this.beV = b2;
    }

    @Override
    public boolean exists() {
        return this.beS.exists();
    }

    @Override
    public boolean isVirtual() {
        return false;
    }

    @Override
    public boolean isAllUsers() {
        return false;
    }

    static /* synthetic */ LocalLocation a(LocalFolder localFolder) {
        return localFolder.beO;
    }

    static /* synthetic */ File b(LocalFolder localFolder) {
        return localFolder.beS;
    }

    static /* synthetic */ String a(LocalFolder localFolder, String string) {
        localFolder.displayName = string;
        return localFolder.displayName;
    }

    static /* synthetic */ String c(LocalFolder localFolder) {
        return localFolder.displayName;
    }

    static /* synthetic */ b d(LocalFolder localFolder) {
        return localFolder.beV;
    }

    static /* synthetic */ String b(LocalFolder localFolder, String string) {
        localFolder.beU = string;
        return localFolder.beU;
    }

    static /* synthetic */ Icon a(LocalFolder localFolder, Icon icon) {
        localFolder.icon = icon;
        return localFolder.icon;
    }

    static /* synthetic */ Icon e(LocalFolder localFolder) {
        return localFolder.icon;
    }

    static /* synthetic */ Icon b(LocalFolder localFolder, Icon icon) {
        localFolder.beQ = icon;
        return localFolder.beQ;
    }
}

