/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.filechooser.model.webdav;

import com.inet.report.filechooser.model.IFile;
import com.inet.report.filechooser.model.IFolder;
import com.inet.report.filechooser.model.ILocation;
import com.inet.report.filechooser.model.webdav.WebDavLocation;
import com.inet.report.filechooser.model.webdav.WebDavRootFolder;
import com.inet.report.filechooser.utils.a;
import com.inet.report.repository.davclient.DavResource;
import java.awt.Image;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;

public class WebDavFile
implements IFile {
    private final DavResource bfi;
    private final IFolder bfj;
    private String path;
    private final WebDavLocation bfk;
    private Icon beP;

    public WebDavFile(DavResource davResource, IFolder iFolder, WebDavLocation webDavLocation) {
        this.bfi = davResource;
        this.bfj = iFolder;
        this.bfk = webDavLocation;
        this.path = "";
        IFolder iFolder2 = iFolder;
        if (iFolder2 != null) {
            if (iFolder2.getParent() != null) {
                this.path = iFolder2.getDisplayName() + "/" + this.path;
            }
            while (iFolder2.getParent() != null) {
                if ((iFolder2 = iFolder2.getParent()) instanceof WebDavRootFolder) continue;
                this.path = iFolder2.getDisplayName() + "/" + this.path;
            }
        }
        this.path = "/" + this.path;
    }

    @Override
    public ILocation getLocation() {
        return this.bfk;
    }

    @Override
    public String getDisplayName() {
        return this.bfi.getName();
    }

    @Override
    public Icon getIcon(boolean bl2, boolean bl3) {
        if (this.getName().toLowerCase().endsWith(".rpt")) {
            return a.bgB;
        }
        if (this.getName().toLowerCase().endsWith(".dataview")) {
            return a.bgC;
        }
        return UIManager.getIcon("FileView.fileIcon");
    }

    @Override
    public List<String> getKeywords() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(this.bfi.getTags());
        return arrayList;
    }

    @Override
    public boolean setKeywords(List<String> list) {
        return this.bfi.saveTags(list);
    }

    @Override
    public Date getLastModified() {
        return this.bfi.getLastModifiedDate();
    }

    @Override
    public String getName() {
        return this.bfi.getResource().getName();
    }

    @Override
    public IFolder getParent() {
        return this.bfj;
    }

    @Override
    public String getRelativePath() {
        return this.path;
    }

    @Override
    public Icon getPreview() {
        if (this.beP != null) {
            return this.beP;
        }
        Image image = this.bfi.getThumbnail();
        return image == null ? null : new ImageIcon(image);
    }

    @Override
    public int getRights() {
        return this.bfi.getPermission();
    }

    @Override
    public long getSize() {
        return this.bfi.getLength();
    }

    @Override
    public String getAbsolutePath() {
        return this.bfi.getResource().getHttpURL().toString();
    }

    public boolean equals(Object object) {
        if (object instanceof WebDavFile) {
            return this.getAbsolutePath().equals(((WebDavFile)object).getAbsolutePath());
        }
        return super.equals(object);
    }

    @Override
    public boolean isInitialized() {
        return this.bfi.isInitialized();
    }

    @Override
    public boolean isThumbnailCached() {
        return this.beP != null || this.bfi.isThumbnailCached();
    }

    @Override
    public void setThumbNail(Icon icon) {
        this.beP = icon;
    }

    @Override
    public boolean exists() {
        return this.bfi.exists();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        InputStream inputStream = this.bfi.getResource().getMethodData();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[4096];
        int n2 = 0;
        while ((n2 = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        byteArrayOutputStream.close();
        inputStream.close();
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    @Override
    public boolean delete() {
        return this.bfi.delete();
    }

    @Override
    public boolean rename(String string) {
        return this.bfi.rename(string);
    }

    public String toString() {
        return this.getDisplayName();
    }
}

